/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils.commands.arguments;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArgumentParser<T> {
    private final TypeToken<T> type = new TypeToken<T>(this.getClass()){};
    public final Class<?> typeClass = this.type.getRawType();

    @Nullable
    public abstract T parse(@NotNull String var1) throws Exception;

    @NotNull
    public List<String> complete(String current, Parameter parameter) {
        return Collections.emptyList();
    }

    public static class BooleanParser
    extends ArgumentParser<Boolean> {
        private static final Map<String, List<String>> VALUES = Maps.newHashMap();

        @Override
        @Nullable
        public Boolean parse(@NotNull String s2) {
            return Boolean.parseBoolean(VALUES.entrySet().stream().filter(it -> ((String)it.getKey()).equalsIgnoreCase(s2) || ((List)it.getValue()).contains(s2.toLowerCase())).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new IllegalArgumentException(s2 + " is not any of: " + String.join((CharSequence)", ", VALUES.keySet()))));
        }

        @Override
        @NotNull
        public List<String> complete(String current, Parameter parameter) {
            if (current != null && !current.trim().isEmpty()) {
                for (String v : VALUES.keySet()) {
                    if (!v.startsWith(current.toLowerCase(Locale.ENGLISH))) continue;
                    return Lists.newArrayList((Object[])new String[]{v});
                }
            }
            return new ArrayList<String>(VALUES.keySet());
        }

        static {
            VALUES.put("true", Lists.newArrayList((Object[])new String[]{"on", "yes", "y", "enabled", "enable", "1"}));
            VALUES.put("false", Lists.newArrayList((Object[])new String[]{"off", "no", "n", "disabled", "disable", "0"}));
        }
    }

    public static class StringParser
    extends ArgumentParser<String> {
        @Override
        @Nullable
        public String parse(@NotNull String arg) {
            return arg;
        }
    }

    public static class FloatParser
    extends ArgumentParser<Float> {
        @Override
        @Nullable
        public Float parse(@NotNull String arg) {
            return Float.valueOf(Float.parseFloat(arg));
        }
    }

    public static class IntegerParser
    extends ArgumentParser<Integer> {
        @Override
        @Nullable
        public Integer parse(@NotNull String arg) {
            return Integer.parseInt(arg);
        }
    }

    public static class DoubleParser
    extends ArgumentParser<Double> {
        @Override
        @Nullable
        public Double parse(@NotNull String arg) {
            return Double.parseDouble(arg);
        }
    }
}

