/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils.commands;

import cc.polyfrost.oneconfig.libs.universal.UChat;
import cc.polyfrost.oneconfig.utils.StringUtils;
import cc.polyfrost.oneconfig.utils.commands.CommandManager;
import cc.polyfrost.oneconfig.utils.commands.PlatformCommandManager;
import cc.polyfrost.oneconfig.utils.commands.annotations.Description;
import cc.polyfrost.oneconfig.utils.commands.annotations.Greedy;
import cc.polyfrost.oneconfig.utils.commands.arguments.EntityPlayerArgumentParser;
import cc.polyfrost.oneconfig.utils.commands.arguments.PlayerArgumentParser;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.ClientCommandHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformCommandManagerImpl
extends PlatformCommandManager {
    @Override
    public void createCommand(final CommandManager.OCCommand root) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandBase(){

            public String func_71517_b() {
                return root.getMetadata().value();
            }

            public String func_71518_a(ICommandSender sender) {
                return "/" + root.getMetadata().value();
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args2) {
                try {
                    String[] result2 = this.doCommand(args2);
                    if (result2.length != 0 && result2[0] != null) {
                        for (String s2 : result2) {
                            UChat.chat(s2);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UChat.chat("Error while running @ROOT_COMMAND@ method! Please report this to the developer.".replace("@ROOT_COMMAND@", root.getMetadata().value()));
                }
            }

            public List<String> func_71514_a() {
                return Arrays.asList(root.getMetadata().aliases());
            }

            public int func_82362_a() {
                return -1;
            }

            public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args2, BlockPos targetPos) {
                ArrayList<String> opts = new ArrayList<String>();
                CommandManager.Pair<String[], CommandManager.InternalCommand> command2 = this.getCommand(args2);
                try {
                    if (command2 != null) {
                        Parameter currentParam = command2.getValue().getUnderlyingMethod().getParameters()[command2.getKey().length - 1];
                        PlatformCommandManagerImpl.this.appendToOptions(opts, currentParam);
                        opts.addAll(CommandManager.INSTANCE.parsers.get(currentParam.getType()).complete(args2[args2.length - 1], currentParam));
                    }
                    opts.addAll(this.getApplicableOptsFor(args2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return opts.isEmpty() ? null : opts;
            }

            private String[] doCommand(@NotNull String[] args2) {
                if (args2.length == 0) {
                    if (root.mainMethod != null) {
                        return new String[]{root.mainMethod.invoke(new String[0])};
                    }
                    return root.helpCommand;
                }
                if (args2[0].equalsIgnoreCase("help")) {
                    if (args2.length == 1) {
                        return root.helpCommand;
                    }
                    String[] newArgs2 = Arrays.copyOfRange(args2, 1, args2.length);
                    CommandManager.Pair<String[], CommandManager.InternalCommand> command2 = this.getCommand(newArgs2);
                    return root.getAdvancedHelp(command2 == null ? null : command2.getValue());
                }
                CommandManager.Pair<String[], CommandManager.InternalCommand> command3 = this.getCommand(args2);
                if (command3 != null) {
                    return new String[]{command3.getValue().invoke(command3.getKey())};
                }
                return new String[]{(Object)((Object)root.getMetadata().chatColor()) + "Command not found! Type /@ROOT_COMMAND@ help for help.".replace("@ROOT_COMMAND@", root.getMetadata().value())};
            }

            @Nullable
            private CommandManager.Pair<String[], CommandManager.InternalCommand> getCommand(String[] args2) {
                String argsIn = String.join((CharSequence)"\ud7ff", args2).toLowerCase();
                for (int i = args2.length - 1; i >= 0; --i) {
                    CommandManager.InternalCommand command2 = this.get(root, argsIn);
                    if (command2 != null) {
                        String primaryPath = command2.getPrimaryPath().replace("\ud7ffMAIN\ud7ff\ud7ffMAIN", "").replace("MAIN\ud7ff\ud7ffMAIN", "");
                        int skipArgs = 0;
                        if (!primaryPath.isEmpty()) {
                            ++skipArgs;
                        }
                        for (char c : primaryPath.toCharArray()) {
                            if (c != "\ud7ff".toCharArray()[0]) continue;
                            ++skipArgs;
                        }
                        String[] newArgs2 = new String[args2.length - skipArgs];
                        System.arraycopy(args2, skipArgs, newArgs2, 0, args2.length - skipArgs);
                        return new CommandManager.Pair<String[], CommandManager.InternalCommand>(newArgs2, command2);
                    }
                    argsIn = StringUtils.substringToLastIndexOf(argsIn, "\ud7ff");
                }
                return null;
            }

            private CommandManager.InternalCommand get(CommandManager.OCCommand command2, String in) {
                CommandManager.Pair fallbackCommand;
                for (String[] ss : command2.commandsMap.values()) {
                    for (String s2 : ss) {
                        if (!s2.equalsIgnoreCase(in) && !s2.equalsIgnoreCase(in + "\ud7ff" + "MAIN\ud7ff\ud7ffMAIN")) continue;
                        return command2.commandsMap.entrySet().stream().filter(it -> it.getValue() == ss).map(Map.Entry::getKey).findFirst().orElse(null);
                    }
                }
                String[] argsIn = in.toLowerCase().split("\ud7ff");
                if (this.getApplicableOptsFor(argsIn).isEmpty() && (fallbackCommand = PlatformCommandManagerImpl.getFallback(command2, in)) != null) {
                    return (CommandManager.InternalCommand)fallbackCommand.getValue();
                }
                return null;
            }

            private Collection<String> getApplicableOptsFor(String[] args2) {
                HashSet<String> opts = new HashSet<String>();
                String current = String.join((CharSequence)"\ud7ff", args2);
                root.commandsMap.values().forEach(paths -> {
                    for (String p : paths) {
                        String s2;
                        String[] split;
                        if (p.endsWith("MAIN\ud7ff\ud7ffMAIN") || !p.startsWith(current) || args2.length - 1 >= (split = p.split("\ud7ff")).length || (s2 = split[args2.length - 1]).isEmpty()) continue;
                        opts.add(s2);
                    }
                });
                opts.remove("main");
                return opts;
            }
        });
    }

    private void appendToOptions(List<String> opts, Parameter currentParam) {
        String[] targets;
        Description description2 = currentParam.isAnnotationPresent(Description.class) ? currentParam.getAnnotation(Description.class) : null;
        String[] stringArray = targets = description2 != null && description2.autoCompletesTo().length != 0 ? description2.autoCompletesTo() : null;
        if (targets != null) {
            opts.addAll(Arrays.asList(targets));
        }
    }

    private static CommandManager.Pair<String, CommandManager.InternalCommand> getFallback(CommandManager.OCCommand command2, String in) {
        if ((in = in.trim()).isEmpty()) {
            CommandManager.InternalCommand cmd = command2.commandsMap.entrySet().stream().filter(e -> Arrays.asList((Object[])e.getValue()).contains("MAIN\ud7ff\ud7ffMAIN")).map(Map.Entry::getKey).filter(it -> it.getUnderlyingMethod().getParameterCount() == 0).findFirst().orElse(null);
            if (cmd == null) {
                return null;
            }
            return new CommandManager.Pair<String, CommandManager.InternalCommand>("MAIN\ud7ff\ud7ffMAIN", cmd);
        }
        String[] splitData = in.split("\ud7ff");
        for (int i = splitData.length; i >= 0; --i) {
            CharSequence[] split = Arrays.copyOfRange(splitData, 0, i);
            String path = String.join((CharSequence)"\ud7ff", split).trim();
            ArrayList<CommandManager.InternalCommand> commands = new ArrayList<CommandManager.InternalCommand>();
            block1: for (Map.Entry<CommandManager.InternalCommand, String[]> entry : command2.commandsMap.entrySet()) {
                String[] acceptedPaths;
                CommandManager.InternalCommand potentialCommand = entry.getKey();
                for (String cmdPath : acceptedPaths = entry.getValue()) {
                    boolean matchesPath = cmdPath.equals(path);
                    if (path.isEmpty()) {
                        matchesPath = false;
                    }
                    boolean matchesMain = cmdPath.equals(path + (path.isEmpty() ? "" : "\ud7ff") + "MAIN\ud7ff\ud7ffMAIN".toLowerCase(Locale.ROOT));
                    if (!matchesPath && !matchesMain) continue;
                    commands.add(potentialCommand);
                    continue block1;
                }
            }
            for (CommandManager.InternalCommand command1 : commands) {
                Method method = command1.getUnderlyingMethod();
                if (method.getParameterCount() == 0) continue;
                if (method.getParameterCount() == splitData.length) {
                    return new CommandManager.Pair<String, CommandManager.InternalCommand>(path, command1);
                }
                if (!method.getParameters()[method.getParameterCount() - 1].isAnnotationPresent(Greedy.class)) continue;
                return new CommandManager.Pair<String, CommandManager.InternalCommand>(path, command1);
            }
        }
        return null;
    }

    static {
        CommandManager.INSTANCE.addParser(new EntityPlayerArgumentParser());
        CommandManager.INSTANCE.addParser(new PlayerArgumentParser());
    }
}

