/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils.commands;

import cc.polyfrost.oneconfig.libs.universal.ChatColor;
import cc.polyfrost.oneconfig.utils.SimpleProfiler;
import cc.polyfrost.oneconfig.utils.commands.PlatformCommandManager;
import cc.polyfrost.oneconfig.utils.commands.annotations.Command;
import cc.polyfrost.oneconfig.utils.commands.annotations.Description;
import cc.polyfrost.oneconfig.utils.commands.annotations.Greedy;
import cc.polyfrost.oneconfig.utils.commands.annotations.Main;
import cc.polyfrost.oneconfig.utils.commands.annotations.SubCommand;
import cc.polyfrost.oneconfig.utils.commands.annotations.SubCommandGroup;
import cc.polyfrost.oneconfig.utils.commands.arguments.ArgumentParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager {
    public static final CommandManager INSTANCE = new CommandManager();
    static final PlatformCommandManager platform = ServiceLoader.load(PlatformCommandManager.class, PlatformCommandManager.class.getClassLoader()).iterator().next();
    static final String NOT_FOUND_TEXT = "Command not found! Type /@ROOT_COMMAND@ help for help.";
    static final String NOT_FOUND_HELP_TEXT = "Help for this command was not found! Type /@ROOT_COMMAND@ help for generic help first.";
    static final String METHOD_RUN_ERROR = "Error while running @ROOT_COMMAND@ method! Please report this to the developer.";
    static final String DELIMITER = "\ud7ff";
    final HashMap<Class<?>, ArgumentParser<?>> parsers = new HashMap();
    private final String[] EMPTY_ARRAY = new String[]{""};
    static final String MAIN_METHOD_NAME = "MAIN\ud7ff\ud7ffMAIN";

    private CommandManager() {
        this.addParser(new ArgumentParser.StringParser());
        this.addParser(new ArgumentParser.IntegerParser());
        this.addParser(new ArgumentParser.IntegerParser(), Integer.TYPE);
        this.addParser(new ArgumentParser.DoubleParser());
        this.addParser(new ArgumentParser.DoubleParser(), Double.TYPE);
        this.addParser(new ArgumentParser.FloatParser());
        this.addParser(new ArgumentParser.FloatParser(), Float.TYPE);
        this.addParser(new ArgumentParser.BooleanParser());
        this.addParser(new ArgumentParser.BooleanParser(), Boolean.TYPE);
    }

    public void addParser(ArgumentParser<?> parser, Class<?> cls) {
        this.parsers.put(cls, parser);
    }

    public void addParser(ArgumentParser<?> parser) {
        this.addParser(parser, parser.typeClass);
    }

    public void registerCommand(Object obj) {
        SimpleProfiler.push("registering command");
        platform.createCommand(new OCCommand(obj));
        SimpleProfiler.pop("registering command");
    }

    public static void register(Object obj) {
        INSTANCE.registerCommand(obj);
    }

    @Deprecated
    public void registerCommand(Class<?> cls) {
        try {
            this.registerCommand(cls.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Legacy support failed, Replace #registerCommand(YourCommand.class) with #registerCommand(new YourCommand())");
        }
    }

    @NotNull
    private static Object createIsnOf(Class<?> cls, Object parent) {
        try {
            if (Modifier.isStatic(cls.getModifiers())) {
                Constructor<?> constructor = cls.getDeclaredConstructor(new Class[0]);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return constructor.newInstance(new Object[0]);
            }
            Constructor<?> constructor = cls.getDeclaredConstructor(parent.getClass());
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(parent);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while creating subcommand!", e);
        }
    }

    @NotNull
    static String[] computePaths(@NotNull InternalCommand in) {
        ArrayList<String> out = new ArrayList<String>();
        for (String path : in.getParentPaths()) {
            for (String alias : in.getAliases()) {
                out.add((path + (path.isEmpty() ? "" : DELIMITER) + alias).toLowerCase());
            }
        }
        return out.toArray(new String[0]);
    }

    @NotNull
    private static String[] computePaths(@NotNull String[] paths, @NotNull Class<?> cls) {
        ArrayList<String> out = new ArrayList<String>();
        SubCommandGroup annotation = cls.getAnnotation(SubCommandGroup.class);
        for (String path : paths) {
            String prefix = path + (path.isEmpty() ? "" : DELIMITER);
            for (String alias : annotation.aliases()) {
                out.add((prefix + alias).toLowerCase());
            }
            out.add((prefix + annotation.value()).toLowerCase());
        }
        return out.toArray(new String[0]);
    }

    static final class Pair<K, V> {
        @NotNull
        private final K key;
        @NotNull
        private final V value;

        Pair(@NotNull K key, @NotNull V value) {
            this.key = key;
            this.value = value;
        }

        @NotNull
        K getKey() {
            return this.key;
        }

        @NotNull
        V getValue() {
            return this.value;
        }

        @NotNull
        @Contract(pure=true)
        public String toString() {
            return "CommandManager.Pair{key=" + this.key + ", value=" + this.value + "}";
        }
    }

    class InternalCommand
    implements Comparable<InternalCommand> {
        private final Method method;
        private final SubCommand meta;
        private final String[] aliases;
        private final String[] paths;
        private final boolean hasHelp;
        private final Object parent;

        private InternalCommand(@NotNull Object parent, Method methodIn, String[] paths) {
            this.parent = parent;
            if (!methodIn.isAccessible()) {
                methodIn.setAccessible(true);
            }
            this.method = methodIn;
            this.meta = methodIn.isAnnotationPresent(SubCommand.class) ? methodIn.getAnnotation(SubCommand.class) : null;
            this.hasHelp = this.meta != null && !this.meta.description().isEmpty();
            this.aliases = new String[this.meta != null ? this.meta.aliases().length + 1 : 1];
            if (this.meta != null) {
                this.aliases[0] = methodIn.getName();
                System.arraycopy(this.meta.aliases(), 0, this.aliases, 1, this.meta.aliases().length);
            } else {
                this.aliases[0] = CommandManager.MAIN_METHOD_NAME;
            }
            this.paths = paths;
            int i = 0;
            for (Parameter parameter : this.method.getParameters()) {
                if (!CommandManager.this.parsers.containsKey(parameter.getType())) {
                    throw new IllegalArgumentException("Method " + this.method.getName() + " has a parameter of class " + parameter.getType().getSimpleName() + " which does not have a valid parser; see CommandManager.addParser");
                }
                if (parameter.isAnnotationPresent(Greedy.class) && i != this.method.getParameters().length - 1) {
                    throw new IllegalArgumentException("Method " + this.method.getName() + " has a greedy parameter " + parameter.getName() + " which is not the last parameter; this is not supported");
                }
                ++i;
            }
        }

        @Nullable
        String invoke(String ... argsIn) {
            try {
                if (argsIn == null) {
                    this.method.invoke(this.parent, new Object[0]);
                    return null;
                }
                if (!(argsIn.length == this.method.getParameterCount() || this.method.getParameterCount() != 0 && this.method.getParameters()[this.method.getParameterCount() - 1].isAnnotationPresent(Greedy.class))) {
                    return (Object)((Object)ChatColor.RED) + "Incorrect number of parameters, expected " + this.method.getParameterCount() + " but got " + argsIn.length;
                }
                return this.invokeWith(this.method, argsIn);
            }
            catch (Exception e) {
                e.printStackTrace();
                return (Object)((Object)ChatColor.RED) + CommandManager.METHOD_RUN_ERROR.replace("@ROOT_COMMAND@", this.getName());
            }
        }

        private String invokeWith(Method method, String[] argsIn) throws InvocationTargetException, IllegalAccessException {
            Object[] args2 = new Object[method.getParameterCount()];
            Parameter[] parameters2 = method.getParameters();
            int i = 0;
            for (Parameter parameter : parameters2) {
                try {
                    args2[i] = i == args2.length - 1 && parameter.isAnnotationPresent(Greedy.class) ? Arrays.stream(argsIn).skip(i).collect(Collectors.joining(" ")) : CommandManager.this.parsers.get(parameter.getType()).parse(argsIn[i]);
                }
                catch (NumberFormatException ne) {
                    return (Object)((Object)ChatColor.RED) + "Error while parsing parameter '" + argsIn[i] + "': Parameter should be a number!";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return (Object)((Object)ChatColor.RED) + "Error while parsing parameter '" + argsIn[i] + "': " + e.getMessage();
                }
                ++i;
            }
            method.invoke(this.parent, args2);
            return null;
        }

        String[] getAliases() {
            return this.aliases;
        }

        String[] getParentPaths() {
            return this.paths;
        }

        String getName() {
            return this.aliases[0];
        }

        String getPrimaryPath() {
            return this.paths[0] + (this.paths[0].isEmpty() ? "" : CommandManager.DELIMITER) + this.aliases[0];
        }

        @Nullable
        String getHelp() {
            if (this.hasHelp) {
                return this.meta.description();
            }
            return null;
        }

        Method getUnderlyingMethod() {
            return this.method;
        }

        public String toString() {
            return "InternalCommand{method=" + this.method.getName() + ", primary=" + this.getPrimaryPath() + ", aliases=" + Arrays.toString(this.aliases) + ", parents=" + Arrays.toString(this.paths).replaceAll(CommandManager.DELIMITER, " ") + '}';
        }

        @Override
        public int compareTo(@NotNull InternalCommand cmd) {
            return this.getPrimaryPath().compareTo(cmd.getPrimaryPath());
        }
    }

    protected class OCCommand {
        final Map<InternalCommand, String[]> commandsMap = new HashMap<InternalCommand, String[]>();
        final String[] helpCommand;
        private final Command meta;
        InternalCommand mainMethod;

        private OCCommand(Object commandIsn) {
            Class<?> cls = commandIsn.getClass();
            if (cls.isAnnotationPresent(Command.class)) {
                this.meta = cls.getAnnotation(Command.class);
                for (Method method : cls.getDeclaredMethods()) {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    this.create(CommandManager.this.EMPTY_ARRAY, commandIsn, method);
                }
                for (GenericDeclaration genericDeclaration : cls.getDeclaredClasses()) {
                    if (!((Class)genericDeclaration).isAnnotationPresent(SubCommandGroup.class)) continue;
                    this.walk(CommandManager.this.EMPTY_ARRAY, CommandManager.createIsnOf((Class)genericDeclaration, commandIsn));
                }
                this.helpCommand = this.meta.customHelpMessage().length == 0 ? this.genHelpCommand() : this.meta.customHelpMessage();
            } else {
                throw new IllegalArgumentException("Master command class " + cls.getSimpleName() + " is not annotated with @Command!");
            }
        }

        private void create(String[] parentPaths, @NotNull Object parent, @NotNull Method method) {
            if (parent.getClass().equals(Class.class)) {
                return;
            }
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (!method.isAnnotationPresent(SubCommand.class)) {
                if (method.isAnnotationPresent(Main.class)) {
                    if (this.mainMethod == null) {
                        if (Arrays.equals(parentPaths, CommandManager.this.EMPTY_ARRAY) && method.getParameterCount() == 0) {
                            this.mainMethod = new InternalCommand(parent, method, parentPaths);
                        } else {
                            Method[] methods2 = method.getDeclaringClass().getDeclaredMethods();
                            int mains = (int)Stream.of(methods2).filter(m4 -> m4.isAnnotationPresent(Main.class)).count();
                            if (mains == 1) {
                                this.mainMethod = new InternalCommand(parent, method, parentPaths);
                            }
                        }
                    }
                } else {
                    return;
                }
            }
            InternalCommand internalCommand = new InternalCommand(parent, method, parentPaths);
            if (this.commandsMap.keySet().stream().anyMatch(internalCommand::equals)) {
                throw new IllegalArgumentException("Command " + method.getName() + " is already registered!");
            }
            this.commandsMap.put(internalCommand, CommandManager.computePaths(internalCommand));
        }

        private void walk(String[] paths, @NotNull Object self) {
            Class<?> classIn = self.getClass();
            paths = CommandManager.computePaths(paths, classIn);
            for (Method method : classIn.getDeclaredMethods()) {
                this.create(paths, self, method);
            }
            for (GenericDeclaration genericDeclaration : classIn.getDeclaredClasses()) {
                if (!((Class)genericDeclaration).isAnnotationPresent(SubCommandGroup.class)) continue;
                Object subcommand = CommandManager.createIsnOf((Class)genericDeclaration, self);
                this.walk(paths, subcommand);
            }
        }

        @NotNull
        private String[] genHelpCommand() {
            String masterName = this.meta.value();
            StringBuilder sb = new StringBuilder(200);
            sb.append((Object)this.meta.chatColor()).append((Object)ChatColor.BOLD).append("Help for /").append(masterName).append((Object)ChatColor.RESET).append((Object)this.meta.chatColor());
            if (!this.meta.description().isEmpty()) {
                sb.append(" - ").append(this.meta.description());
            }
            sb.append(":           ").append(Arrays.toString(this.meta.aliases())).append("\n").append((Object)this.meta.chatColor());
            Iterator it = this.commandsMap.keySet().stream().sorted().iterator();
            while (it.hasNext()) {
                String path;
                InternalCommand command2 = (InternalCommand)it.next();
                Method method = command2.getUnderlyingMethod();
                if (command2.getPrimaryPath().endsWith(CommandManager.MAIN_METHOD_NAME)) {
                    Main annotation = method.isAnnotationPresent(Main.class) ? method.getAnnotation(Main.class) : null;
                    path = command2.getPrimaryPath().substring(0, command2.getPrimaryPath().length() - CommandManager.MAIN_METHOD_NAME.length()).replaceAll(CommandManager.DELIMITER, " ").trim();
                    sb.append("/").append(masterName).append(path.isEmpty() ? "" : " ").append(path).append(" ");
                    Parameter[] parameterArray = method.getParameters();
                    int n = parameterArray.length;
                    for (int i = 0; i < n; ++i) {
                        Parameter parameter = parameterArray[i];
                        this.appendParameter(sb, parameter);
                    }
                    sb.append("- ").append(annotation != null && !annotation.description().isEmpty() ? annotation.description() : "Main command").append("\n").append((Object)this.meta.chatColor());
                    continue;
                }
                path = command2.getPrimaryPath().replaceAll(CommandManager.DELIMITER, " ");
                sb.append("/").append(masterName).append(" ").append(path).append(" ");
                for (Parameter parameter : command2.method.getParameters()) {
                    this.appendParameter(sb, parameter);
                }
                if (command2.hasHelp) {
                    sb.append("- ").append(command2.getHelp());
                }
                sb.append("\n").append((Object)this.meta.chatColor());
            }
            return sb.toString().split("\n");
        }

        private void appendParameter(StringBuilder sb, Parameter parameter) {
            String s2 = parameter.isAnnotationPresent(Description.class) ? parameter.getAnnotation(Description.class).value() : parameter.getType().getSimpleName();
            sb.append("<").append(s2);
            if (parameter.getType().isArray() || parameter.isAnnotationPresent(Greedy.class)) {
                sb.append("...");
            }
            sb.append("> ");
        }

        String[] getAdvancedHelp(InternalCommand command2) {
            if (command2 != null) {
                StringBuilder sb = new StringBuilder(200);
                sb.append((Object)this.meta.chatColor()).append((Object)ChatColor.BOLD).append("Advanced help for /").append(this.meta.value()).append(" ").append(command2.getPrimaryPath().replaceAll(CommandManager.DELIMITER, " "));
                sb.append((Object)ChatColor.RESET).append((Object)this.meta.chatColor()).append(": ").append("\n").append((Object)this.meta.chatColor());
                if (command2.hasHelp) {
                    sb.append((Object)ChatColor.BOLD).append("Description: ").append((Object)ChatColor.RESET).append((Object)this.meta.chatColor()).append(command2.getHelp()).append("\n").append((Object)this.meta.chatColor());
                }
                if (command2.getAliases().length > 0) {
                    sb.append("Aliases: ").append(String.join((CharSequence)", ", command2.getAliases())).append("\n").append((Object)this.meta.chatColor());
                }
                sb.append("Parameters:\n").append((Object)this.meta.chatColor());
                for (Parameter parameter : command2.method.getParameters()) {
                    Description description2 = parameter.isAnnotationPresent(Description.class) ? parameter.getAnnotation(Description.class) : null;
                    String s2 = description2 != null ? description2.value() : parameter.getType().getSimpleName();
                    sb.append("<").append(s2);
                    if (parameter.getType().isArray() || parameter.isAnnotationPresent(Greedy.class)) {
                        sb.append("...");
                    }
                    sb.append(">");
                    String desc = description2 != null && !description2.description().isEmpty() ? description2.description() : null;
                    sb.append(desc != null ? ": " + desc : "\n").append((Object)this.meta.chatColor());
                }
                return sb.toString().split("\n");
            }
            return new String[]{(Object)((Object)this.meta.chatColor()) + CommandManager.NOT_FOUND_HELP_TEXT.replace("@ROOT_COMMAND@", this.meta.value())};
        }

        Command getMetadata() {
            return this.meta;
        }
    }
}

