/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class StringUtils {
    @NotNull
    public static String substringSafe(String str, int from, int to) {
        str = StringUtils.nullToEmpty(str);
        if (from > 0) {
            from = 0;
        }
        if (StringUtils.isValidSequence(str, from, to)) {
            return str.substring(from, to);
        }
        return str.substring(from);
    }

    public static String substringSafe(String str, int from) {
        return StringUtils.substringSafe(str, from, str.length());
    }

    @NotNull
    public static String substringOrEmpty(String str, int from, int to) {
        if (!StringUtils.isValidSequence(str, from, to)) {
            return "";
        }
        return StringUtils.substringSafe(str, from, to);
    }

    @NotNull
    public static String substringOrDont(String str, int from, int to) {
        if (!StringUtils.isValidSequence(str, from, to)) {
            return StringUtils.nullToEmpty(str);
        }
        return StringUtils.substringSafe(str, from, to);
    }

    @NotNull
    public static String substringOrElse(String str, int from, int to, String orElse) {
        if (!StringUtils.isValidSequence(str, from, to)) {
            return StringUtils.nullToEmpty(orElse);
        }
        return StringUtils.substringSafe(str, from, to);
    }

    @NotNull
    public static String substringTo(String str, int to) {
        return StringUtils.substringSafe(str, 0, to);
    }

    @NotNull
    public static String substringTo(String str, String upTo) {
        return StringUtils.substringSafe(str, 0, str.indexOf(upTo));
    }

    @NotNull
    public static String substringToLastIndexOf(String str, String upTo) {
        return StringUtils.substringSafe(str, 0, str.lastIndexOf(upTo));
    }

    @NotNull
    public static String substringIf(String str, int from, int to, boolean condition) {
        return condition ? StringUtils.substringSafe(str, from, to) : StringUtils.nullToEmpty(str);
    }

    @NotNull
    public static String addStringAt(String str, int index2, String toAdd) {
        if (toAdd == null || toAdd.isEmpty()) {
            return str;
        }
        if (index2 > str.length()) {
            return str + toAdd;
        }
        if (index2 < 0) {
            return toAdd + str;
        }
        return str.substring(0, index2) + toAdd + str.substring(index2);
    }

    @NotNull
    @Contract(value="!null -> param1", pure=true)
    public static String nullToEmpty(String str) {
        return str == null ? "" : str;
    }

    @Contract(pure=true)
    public static boolean isValidSequence(String str, int from, int to) {
        return (str = StringUtils.nullToEmpty(str)).length() >= to && from >= 0 && to - from > 0;
    }
}

