/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils;

import cc.polyfrost.oneconfig.events.event.RenderEvent;
import cc.polyfrost.oneconfig.events.event.Stage;
import cc.polyfrost.oneconfig.events.event.TickEvent;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.DummyAnimation;
import cc.polyfrost.oneconfig.gui.animations.EaseInOutQuad;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.internal.config.Preferences;
import cc.polyfrost.oneconfig.internal.utils.Notification;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.UResolution;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.asset.Icon;
import cc.polyfrost.oneconfig.utils.gui.GuiUtils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class Notifications {
    public static final Notifications INSTANCE = new Notifications();
    private final LinkedHashMap<Notification, Animation> notifications = new LinkedHashMap();
    private final float DEFAULT_DURATION = 4000.0f;
    private float deltaTime = 0.0f;
    private Animation dummyAnimation;
    private static final Icon DEFAULT_ICON = new Icon(SVGs.ONECONFIG_HEAD_DARK);
    private static final File crashPatchSkyClientFile = new File("./OneConfig/CrashPatch/SKYCLIENT");
    private static final File oldCrashPatchSkyClientFile = new File("./W-OVERFLOW/CrashPatch/SKYCLIENT");

    private Notifications() {
    }

    public void send(String title, String message, @Nullable Icon icon, float duration, @Nullable Callable<Float> progressbar, @Nullable Runnable action) {
        Notification notification = new Notification(title, message, icon, duration, progressbar, action);
        this.notifications.put(notification, new DummyAnimation(-1.0f));
    }

    public void send(String title, String message, float duration, @Nullable Callable<Float> progressbar, @Nullable Runnable action) {
        this.send(title, message, null, duration, progressbar, action);
    }

    public void send(String title, String message, @Nullable Icon icon, float duration, @Nullable Callable<Float> progressbar) {
        this.send(title, message, icon, duration, progressbar, null);
    }

    public void send(String title, String message, @Nullable Icon icon, float duration, @Nullable Runnable action) {
        this.send(title, message, icon, duration, null, action);
    }

    public void send(String title, String message, float duration, @Nullable Callable<Float> progressbar) {
        this.send(title, message, duration, progressbar, null);
    }

    public void send(String title, String message, float duration, @Nullable Runnable action) {
        this.send(title, message, duration, null, action);
    }

    public void send(String title, String message, @Nullable Icon icon, @Nullable Callable<Float> progressbar) {
        this.send(title, message, icon, 4000.0f, progressbar);
    }

    public void send(String title, String message, @Nullable Icon icon, @Nullable Runnable action) {
        this.send(title, message, icon, 4000.0f, action);
    }

    public void send(String title, String message, @Nullable Callable<Float> progressbar) {
        this.send(title, message, 4000.0f, progressbar);
    }

    public void send(String title, String message, @Nullable Icon icon, float duration) {
        this.send(title, message, icon, duration, (Callable<Float>)null);
    }

    public void send(String title, String message, @Nullable Runnable action) {
        this.send(title, message, 4000.0f, action);
    }

    public void send(String title, String message, float duration) {
        this.send(title, message, duration, (Callable<Float>)null);
    }

    public void send(String title, String message, @Nullable Icon icon) {
        this.send(title, message, icon, (Callable<Float>)null);
    }

    public void send(String title, String message) {
        this.send(title, message, (Callable<Float>)null);
    }

    @Subscribe
    private void onRenderEvent(RenderEvent event) {
        if (event.stage == Stage.START) {
            this.deltaTime += GuiUtils.getDeltaTime();
            return;
        }
        if (this.notifications.size() == 0) {
            return;
        }
        NanoVGHelper.INSTANCE.setupAndDraw(vg -> {
            float desiredPosition = -16.0f;
            float scale = OneConfigGui.getScaleFactor();
            for (Map.Entry<Notification, Animation> entry2 : this.notifications.entrySet()) {
                if (entry2.getValue().getEnd() == -1.0f) {
                    entry2.setValue(new DummyAnimation(desiredPosition));
                } else if (desiredPosition != entry2.getValue().getEnd()) {
                    entry2.setValue(new EaseInOutQuad(250, entry2.getValue().get(0.0f), desiredPosition, false));
                }
                float height = entry2.getKey().draw(vg, (float)UResolution.getWindowHeight() / scale + entry2.getValue().get(this.deltaTime), scale, this.deltaTime);
                desiredPosition -= height + 16.0f;
            }
            this.notifications.entrySet().removeIf(entry -> ((Notification)entry.getKey()).isFinished());
        });
        this.deltaTime = 0.0f;
    }

    @Subscribe
    private void onTickEvent(TickEvent event) {
        if (Preferences.firstLaunch && event.stage == Stage.START && !(Platform.getGuiPlatform().getCurrentScreen() instanceof OneConfigGui) && Platform.getServerPlatform().doesPlayerExist()) {
            Preferences.firstLaunch = false;
            Preferences.getInstance().save();
            this.dummyAnimation = new EaseInOutQuad(4000, 0.0f, 1.0f, false);
            boolean isSkyClient = this.isSkyClient();
            String message = isSkyClient ? "SkyClient now includes OneConfig, the next-gen config library for Minecraft. You can now simply press '" + Preferences.oneConfigKeyBind.getDisplay() + "' to configure all your mods!" : "Press '" + Preferences.oneConfigKeyBind.getDisplay() + "' to open OneConfig, the next-gen config library for Minecraft.";
            this.send("Welcome to OneConfig!", message, DEFAULT_ICON, -1.0f, () -> {
                if (Platform.getGuiPlatform().getCurrentScreen() instanceof OneConfigGui || Preferences.oneconfigOpened) {
                    Preferences.oneconfigOpened = true;
                    Preferences.getInstance().save();
                    return Float.valueOf(this.dummyAnimation.get(GuiUtils.getDeltaTime()));
                }
                return Float.valueOf(0.0f);
            }, () -> GuiUtils.displayScreen((Object)OneConfigGui.create()));
        }
    }

    private boolean isSkyClient() {
        if (crashPatchSkyClientFile.exists()) {
            return true;
        }
        if (oldCrashPatchSkyClientFile.exists()) {
            return true;
        }
        return Platform.getLoaderPlatform().getLoadedMods().stream().anyMatch(mod -> mod != null && StringUtils.contains((CharSequence)mod.id, (CharSequence)"skyclient") || StringUtils.contains((CharSequence)mod.id, (CharSequence)"skyblockclient") || StringUtils.equals((CharSequence)mod.id, (CharSequence)"scc"));
    }
}

