/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils;

import cc.polyfrost.oneconfig.libs.universal.UDesktop;
import cc.polyfrost.oneconfig.utils.JsonUtils;
import com.google.gson.JsonElement;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public final class NetworkUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getString(String url, String userAgent, int timeout, boolean useCaches) {
        try (InputStreamReader input = new InputStreamReader(NetworkUtils.setupConnection(url, userAgent, timeout, useCaches), StandardCharsets.UTF_8);){
            String string = IOUtils.toString((Reader)input);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getString(String url) {
        return NetworkUtils.getString(url, "OneConfig/1.0.0", 5000, false);
    }

    public static JsonElement getJsonElement(String url, String userAgent, int timeout, boolean useCaches) {
        return JsonUtils.parseString(NetworkUtils.getString(url, userAgent, timeout, useCaches));
    }

    public static JsonElement getJsonElement(String url) {
        return NetworkUtils.getJsonElement(url, "OneConfig/1.0.0", 5000, false);
    }

    public static boolean downloadFile(String url, File file, String userAgent, int timeout, boolean useCaches) {
        url = url.replace(" ", "%20");
        try (FileOutputStream fileOut = new FileOutputStream(file);
             BufferedInputStream in = new BufferedInputStream(NetworkUtils.setupConnection(url, userAgent, timeout, useCaches));){
            IOUtils.copy((InputStream)in, (OutputStream)fileOut);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean downloadFile(String url, File file) {
        return NetworkUtils.downloadFile(url, file, "OneConfig/1.0.0", 5000, false);
    }

    public static void browseLink(String uri) {
        UDesktop.browse(URI.create(uri));
    }

    public static InputStream setupConnection(String url, String userAgent, int timeout, boolean useCaches) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        connection.setUseCaches(useCaches);
        connection.addRequestProperty("User-Agent", userAgent);
        connection.setReadTimeout(timeout);
        connection.setConnectTimeout(timeout);
        connection.setDoOutput(true);
        return connection.getInputStream();
    }
}

