/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils;

import cc.polyfrost.oneconfig.internal.config.Preferences;
import cc.polyfrost.oneconfig.platform.LoaderPlatform;
import cc.polyfrost.oneconfig.platform.Platform;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LogScanner {
    static final Logger LOGGER = LogManager.getLogger((String)"OneConfig Log Scanner");

    @NotNull
    public static Set<LoaderPlatform.ActiveMod> identifyFromStacktrace(Throwable e) {
        HashSet<LoaderPlatform.ActiveMod> mods = new HashSet<LoaderPlatform.ActiveMod>();
        LogScanner.visitChildrenThrowables(e, throwable -> {
            for (LoaderPlatform.ActiveMod newMod : LogScanner.identifyFromThrowable(throwable)) {
                if (!mods.stream().noneMatch(mod -> mod.id.equals(newMod.id))) continue;
                mods.add(newMod);
            }
        });
        return mods;
    }

    @NotNull
    public static Set<LoaderPlatform.ActiveMod> identifyCallerFromStacktrace(Throwable e) {
        StackTraceElement target = null;
        int i = 0;
        for (StackTraceElement element : e.getStackTrace()) {
            if (!(i <= 2 || element.isNativeMethod() || element.getClassName().startsWith("sun.") || element.getClassName().startsWith("java.") || element.getClassName().startsWith("javax.") || element.getClassName().startsWith("jdk.") || element.getClassName().startsWith("com.sun."))) {
                target = element;
                break;
            }
            ++i;
        }
        if (target == null) {
            return Collections.emptySet();
        }
        Set<LoaderPlatform.ActiveMod> classMods = LogScanner.identifyFromClass(target.getClassName());
        return classMods.isEmpty() ? Collections.emptySet() : classMods;
    }

    private static void visitChildrenThrowables(Throwable e, Consumer<Throwable> visitor2) {
        visitor2.accept(e);
        for (Throwable child : e.getSuppressed()) {
            LogScanner.visitChildrenThrowables(child, visitor2);
        }
    }

    private static Set<LoaderPlatform.ActiveMod> identifyFromThrowable(Throwable e) {
        LinkedHashSet<String> involvedClasses = new LinkedHashSet<String>();
        while (e != null) {
            for (StackTraceElement element : e.getStackTrace()) {
                involvedClasses.add(element.getClassName());
            }
            e = e.getCause();
        }
        LinkedHashSet<LoaderPlatform.ActiveMod> mods = new LinkedHashSet<LoaderPlatform.ActiveMod>();
        for (String className : involvedClasses) {
            Set<LoaderPlatform.ActiveMod> classMods = LogScanner.identifyFromClass(className);
            mods.addAll(classMods);
        }
        return mods;
    }

    private static void debug(Supplier<String> message) {
        if (Preferences.DEBUG) {
            LOGGER.info(message.get());
        }
    }

    @NotNull
    public static Set<LoaderPlatform.ActiveMod> identifyFromClass(String className) {
        List<LoaderPlatform.ActiveMod> modMap = Platform.getLoaderPlatform().getLoadedMods();
        modMap.removeIf(Objects::isNull);
        if (className.startsWith("org.spongepowered.asm.mixin.")) {
            LogScanner.debug(() -> "Ignoring class " + className + " for identification because it is a mixin class");
            return Collections.emptySet();
        }
        try {
            Class<?> clazz = Class.forName(className, false, LogScanner.class.getClassLoader());
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                LogScanner.debug(() -> "Ignoring class " + className + " for identification because the code source could not be found");
                return Collections.emptySet();
            }
            URL url = codeSource.getLocation();
            if (url == null) {
                LOGGER.warn("Failed to identify mod for " + className);
                return Collections.emptySet();
            }
            if (url.toURI().toString().startsWith("jar:")) {
                url = new URL(url.toURI().toString().substring(4, url.toURI().toString().lastIndexOf("!")));
            }
            if (url.toURI().toString().endsWith(".class") && Platform.getInstance().isDevelopmentEnvironment()) {
                LOGGER.error("The mod you are currently developing caused this issue, or another class file. Returning 'this'.");
                LOGGER.error("Class: " + className);
                return Collections.singleton(new LoaderPlatform.ActiveMod("this", "this", "Unknown", null));
            }
            Set<LoaderPlatform.ActiveMod> mods = LogScanner.getModsAt(Paths.get(url.toURI()), modMap);
            if (!mods.isEmpty()) {
                LogScanner.debug(() -> "Successfully placed blame of '" + className + "' on '" + ((LoaderPlatform.ActiveMod)mods.stream().findFirst().get()).name + "'");
            }
            return mods;
        }
        catch (ClassNotFoundException | NoClassDefFoundError | MalformedURLException | URISyntaxException e) {
            LogScanner.debug(() -> "Ignoring class " + className + " for identification because an error occurred");
            return Collections.emptySet();
        }
    }

    @NotNull
    private static Set<LoaderPlatform.ActiveMod> getModsAt(Path path, List<LoaderPlatform.ActiveMod> modMap) {
        Set<LoaderPlatform.ActiveMod> mods = modMap.stream().filter(m4 -> m4.source.equals(path)).collect(Collectors.toSet());
        if (!mods.isEmpty()) {
            return mods;
        }
        if (Platform.getInstance().isDevelopmentEnvironment()) {
            String resourcesPathString = path.toString().replace("\\", "/").replace("common/build/classes/java/main", "fabric/build/resources/main").replace("common/build/classes/kotlin/main", "fabric/build/resources/main").replace("classes/java/main", "resources/main").replace("classes/kotlin/main", "resources/main");
            Path resourcesPath = Paths.get(resourcesPathString, new String[0]);
            return modMap.stream().filter(m4 -> m4.source.equals(resourcesPath)).collect(Collectors.toSet());
        }
        LogScanner.debug(() -> "Mod at path '" + path.toAbsolutePath() + "' is at fault, but it could not be found in the map of mod paths: ");
        return Collections.emptySet();
    }
}

