/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.utils;

import cc.polyfrost.oneconfig.utils.NetworkUtils;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;

public final class IOUtils {
    public static ByteBuffer resourceToByteBuffer(String path) throws IOException {
        return IOUtils.resourceToByteBuffer(path, IOUtils.class);
    }

    public static ByteBuffer resourceToByteBuffer(String path, Class<?> clazz) throws IOException {
        byte[] bytes;
        if ((path = path.trim()).startsWith("http")) {
            try (InputStream in = NetworkUtils.setupConnection(path, "OneConfig", 5000, true);){
                bytes = org.apache.commons.io.IOUtils.toByteArray((InputStream)in);
            }
        } else {
            File file = new File(path);
            InputStream stream = file.exists() && file.isFile() ? Files.newInputStream(file.toPath(), new OpenOption[0]) : clazz.getResourceAsStream(path);
            if (stream == null) {
                throw new FileNotFoundException(path);
            }
            bytes = org.apache.commons.io.IOUtils.toByteArray((InputStream)stream);
        }
        ByteBuffer data2 = ByteBuffer.allocateDirect(bytes.length).order(ByteOrder.nativeOrder()).put(bytes);
        ((Buffer)data2).flip();
        return data2;
    }

    @Deprecated
    public static ByteBuffer resourceToByteBufferNullable(String path) {
        try {
            return IOUtils.resourceToByteBuffer(path);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static ByteBuffer resourceToByteBufferNullable(String path, Class<?> clazz) {
        try {
            return IOUtils.resourceToByteBuffer(path, clazz);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static void copyStringToClipboard(String s2) {
        StringSelection stringSelection = new StringSelection(s2);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public static String getStringFromClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void copyImageToClipboard(Image image) {
        ImageSelection imageSelection = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    public static Image getImageFromClipboard() {
        try {
            return (Image)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.imageFlavor);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileChecksum(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            int bytesRead;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] bytesBuffer = new byte[1024];
            while ((bytesRead = inputStream.read(bytesBuffer)) != -1) {
                digest.update(bytesBuffer, 0, bytesRead);
            }
            String string = IOUtils.convertByteArrayToHexString(digest.digest());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuilder stringBuffer = new StringBuilder();
        for (byte arrayByte : arrayBytes) {
            stringBuffer.append(Integer.toString((arrayByte & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    private static class ImageSelection
    implements Transferable {
        private final Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        @NotNull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }
}

