/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.renderer;

import cc.polyfrost.oneconfig.libs.universal.UGraphics;
import cc.polyfrost.oneconfig.platform.Platform;
import java.util.regex.Pattern;

public class TextRenderer {
    private static final Pattern regex = Pattern.compile("(?i)\u00a7[0-9a-f]");
    private static boolean drawingBorder = false;

    public static int drawBorderedText(String text, float x, float y, int color, int opacity) {
        String noColors = regex.matcher(text).replaceAll("\u00a7r");
        drawingBorder = true;
        int yes = 0;
        if (opacity / 4 > 3) {
            for (int xOff = -2; xOff <= 2; ++xOff) {
                for (int yOff = -2; yOff <= 2; ++yOff) {
                    if (xOff * xOff == yOff * yOff) continue;
                    yes = (int)((float)yes + Platform.getGLPlatform().drawText(noColors, (float)xOff / 2.0f + x, (float)yOff / 2.0f + y, opacity / 4 << 24, false));
                }
            }
        }
        drawingBorder = false;
        return yes += (int)Platform.getGLPlatform().drawText(text, x, y, color, false);
    }

    public static float getStringWidth(String text) {
        return Platform.getGLPlatform().getStringWidth(text);
    }

    public static void drawScaledString(String text, float x, float y, int color, TextType type2, float scale) {
        UGraphics.GL.pushMatrix();
        UGraphics.GL.scale(scale, scale, 1.0f);
        switch (type2) {
            case NONE: {
                Platform.getGLPlatform().drawText(text, x * (1.0f / scale), y * (1.0f / scale), color, false);
                break;
            }
            case SHADOW: {
                Platform.getGLPlatform().drawText(text, x * (1.0f / scale), y * (1.0f / scale), color, true);
                break;
            }
            case FULL: {
                TextRenderer.drawBorderedText(text, x * (1.0f / scale), y * (1.0f / scale), color, 255);
            }
        }
        UGraphics.GL.popMatrix();
    }

    public static boolean isDrawingTextBorder() {
        return drawingBorder;
    }

    public static enum TextType {
        NONE,
        SHADOW,
        FULL;


        public static TextType toType(int type2) {
            return TextType.values()[type2];
        }
    }
}

