/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.platform.impl;

import cc.polyfrost.oneconfig.platform.LoaderPlatform;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoaderPlatformImpl
implements LoaderPlatform {
    @Override
    public boolean isModLoaded(String id) {
        return Loader.isModLoaded((String)id);
    }

    @Override
    public boolean hasActiveModContainer() {
        return Loader.instance().activeModContainer() != null;
    }

    @Override
    @NotNull
    public List<LoaderPlatform.ActiveMod> getLoadedMods() {
        try {
            return Loader.instance().getActiveModList().stream().map(this::toActiveMod).collect(Collectors.toList());
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Override
    public LoaderPlatform.ActiveMod getActiveModContainer() {
        return this.toActiveMod(Loader.instance().activeModContainer());
    }

    @Override
    public LoaderPlatform.ActiveMod toActiveMod(@Nullable Object in) {
        try {
            ModContainer container = (ModContainer)in;
            if (container == null) {
                return null;
            }
            return new LoaderPlatform.ActiveMod(container.getName(), container.getModId(), container.getVersion(), container.getSource().toPath());
        }
        catch (Exception e) {
            return null;
        }
    }
}

