/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.platform;

import cc.polyfrost.oneconfig.platform.GLPlatform;
import cc.polyfrost.oneconfig.platform.GuiPlatform;
import cc.polyfrost.oneconfig.platform.I18nPlatform;
import cc.polyfrost.oneconfig.platform.LoaderPlatform;
import cc.polyfrost.oneconfig.platform.MousePlatform;
import cc.polyfrost.oneconfig.platform.ServerPlatform;
import java.util.ServiceLoader;

public interface Platform {
    public static Platform getInstance() {
        return PlatformHolder.INSTANCE.platform;
    }

    public static MousePlatform getMousePlatform() {
        return PlatformHolder.INSTANCE.mousePlatform;
    }

    public static LoaderPlatform getLoaderPlatform() {
        return PlatformHolder.INSTANCE.loaderPlatform;
    }

    public static ServerPlatform getServerPlatform() {
        return PlatformHolder.INSTANCE.serverPlatform;
    }

    public static GLPlatform getGLPlatform() {
        return PlatformHolder.INSTANCE.glPlatform;
    }

    public static GuiPlatform getGuiPlatform() {
        return PlatformHolder.INSTANCE.guiPlatform;
    }

    public static I18nPlatform getI18nPlatform() {
        return PlatformHolder.INSTANCE.i18nPlatform;
    }

    public boolean isCallingFromMinecraftThread();

    public int getMinecraftVersion();

    public boolean isDevelopmentEnvironment();

    public Loader getLoader();

    public static enum Loader {
        FORGE,
        FABRIC;

    }

    public static class PlatformHolder {
        static PlatformHolder INSTANCE = new PlatformHolder();
        Platform platform = ServiceLoader.load(Platform.class, Platform.class.getClassLoader()).iterator().next();
        MousePlatform mousePlatform = ServiceLoader.load(MousePlatform.class, MousePlatform.class.getClassLoader()).iterator().next();
        LoaderPlatform loaderPlatform = ServiceLoader.load(LoaderPlatform.class, LoaderPlatform.class.getClassLoader()).iterator().next();
        ServerPlatform serverPlatform = ServiceLoader.load(ServerPlatform.class, ServerPlatform.class.getClassLoader()).iterator().next();
        GLPlatform glPlatform = ServiceLoader.load(GLPlatform.class, GLPlatform.class.getClassLoader()).iterator().next();
        GuiPlatform guiPlatform = ServiceLoader.load(GuiPlatform.class, GuiPlatform.class.getClassLoader()).iterator().next();
        I18nPlatform i18nPlatform = ServiceLoader.load(I18nPlatform.class, I18nPlatform.class.getClassLoader()).iterator().next();

        private PlatformHolder() {
        }
    }
}

