/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.universal.shader;

import cc.polyfrost.oneconfig.libs.universal.shader.DirectShaderUniform;
import cc.polyfrost.oneconfig.libs.universal.shader.FloatMatrixUniform;
import cc.polyfrost.oneconfig.libs.universal.shader.GlShader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL20;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcc/polyfrost/oneconfig/libs/universal/shader/DirectFloatMatrixUniform;", "Lcc/polyfrost/oneconfig/libs/universal/shader/DirectShaderUniform;", "Lcc/polyfrost/oneconfig/libs/universal/shader/FloatMatrixUniform;", "", "location", "<init>", "(I)V", "", "array", "", "setValue", "([F)V", "universalcraft"})
public final class DirectFloatMatrixUniform
extends DirectShaderUniform
implements FloatMatrixUniform {
    public DirectFloatMatrixUniform(int location) {
        super(location);
    }

    @Override
    public void setValue(@NotNull float[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        ByteBuffer buffer = ByteBuffer.allocateDirect(array.length * 4).order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = buffer.asFloatBuffer();
        floatBuffer.put(array);
        buffer.rewind();
        switch (array.length) {
            case 4: {
                if (GlShader.Companion.getCORE()) {
                    GL20.glUniformMatrix2((int)this.getLocation(), (boolean)false, (FloatBuffer)floatBuffer);
                    break;
                }
                ARBShaderObjects.glUniformMatrix2ARB((int)this.getLocation(), (boolean)false, (FloatBuffer)floatBuffer);
                break;
            }
            case 9: {
                if (GlShader.Companion.getCORE()) {
                    GL20.glUniformMatrix3((int)this.getLocation(), (boolean)false, (FloatBuffer)floatBuffer);
                    break;
                }
                ARBShaderObjects.glUniformMatrix3ARB((int)this.getLocation(), (boolean)false, (FloatBuffer)floatBuffer);
                break;
            }
            case 16: {
                if (GlShader.Companion.getCORE()) {
                    GL20.glUniformMatrix4((int)this.getLocation(), (boolean)false, (FloatBuffer)floatBuffer);
                    break;
                }
                ARBShaderObjects.glUniformMatrix4ARB((int)this.getLocation(), (boolean)false, (FloatBuffer)floatBuffer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

