/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.universal;

import cc.polyfrost.oneconfig.libs.universal.ChatColor;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import cc.polyfrost.oneconfig.libs.universal.UMinecraft;
import cc.polyfrost.oneconfig.libs.universal.utils.ReleasedDynamicTexture;
import cc.polyfrost.oneconfig.libs.universal.vertex.UVertexConsumer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.Matrix3f;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class UGraphics {
    private static final Pattern formattingCodePattern = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static UMatrixStack UNIT_STACK = UMatrixStack.UNIT;
    public static int ZERO_TEXT_ALPHA = 10;
    private BufferBuilder instance;
    private VertexFormat vertexFormat;

    public UGraphics(BufferBuilder instance) {
        this.instance = instance;
    }

    public UVertexConsumer asUVertexConsumer() {
        return UVertexConsumer.of(this.instance);
    }

    public static UGraphics getFromTessellator() {
        return new UGraphics(UGraphics.getTessellator().func_178180_c());
    }

    @Deprecated
    public static void pushMatrix() {
        GL.pushMatrix();
    }

    @Deprecated
    public static void popMatrix() {
        GL.popMatrix();
    }

    @Deprecated
    public static void translate(float x, float y, float z) {
        GL.translate(x, y, z);
    }

    @Deprecated
    public static void translate(double x, double y, double z) {
        GL.translate(x, y, z);
    }

    @Deprecated
    public static void rotate(float angle, float x, float y, float z) {
        GL.rotate(angle, x, y, z);
    }

    @Deprecated
    public static void scale(float x, float y, float z) {
        GL.scale(x, y, z);
    }

    @Deprecated
    public static void scale(double x, double y, double z) {
        GL.scale(x, y, z);
    }

    public static Tessellator getTessellator() {
        return Tessellator.func_178181_a();
    }

    @Deprecated
    public static void draw() {
        UGraphics.getTessellator().func_78381_a();
    }

    public static void cullFace(int mode) {
        GlStateManager.CullFace[] values2;
        for (GlStateManager.CullFace value : values2 = GlStateManager.CullFace.values()) {
            if (value.field_187328_d != mode) continue;
            GlStateManager.func_187407_a((GlStateManager.CullFace)value);
            return;
        }
        throw new IllegalArgumentException(String.format("Mode %d is not valid!", mode));
    }

    public static void enableLighting() {
        GlStateManager.func_179145_e();
    }

    public static void disableLighting() {
        GlStateManager.func_179140_f();
    }

    public static void disableLight(int mode) {
        GlStateManager.func_179122_b((int)mode);
    }

    public static void enableLight(int mode) {
        GlStateManager.func_179085_a((int)mode);
    }

    public static void enableBlend() {
        GlStateManager.func_179147_l();
    }

    @Deprecated
    public static void disableTexture2D() {
        GlStateManager.func_179090_x();
    }

    public static void disableAlpha() {
        GlStateManager.func_179118_c();
    }

    public static void shadeModel(int mode) {
        GlStateManager.func_179103_j((int)mode);
    }

    public static void blendEquation(int equation) {
        GL14.glBlendEquation((int)equation);
    }

    public static void tryBlendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        GlStateManager.func_179120_a((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
    }

    @Deprecated
    public static void enableTexture2D() {
        GlStateManager.func_179098_w();
    }

    public static void disableBlend() {
        GlStateManager.func_179084_k();
    }

    public static void deleteTexture(int glTextureId) {
        GlStateManager.func_179150_h((int)glTextureId);
    }

    public static void enableAlpha() {
        GlStateManager.func_179141_d();
    }

    public static void configureTexture(int glTextureId, Runnable block) {
        int prevTextureBinding = GL11.glGetInteger((int)32873);
        GlStateManager.func_179144_i((int)glTextureId);
        block.run();
        GlStateManager.func_179144_i((int)prevTextureBinding);
    }

    public static void configureTextureUnit(int index2, Runnable block) {
        int prevActiveTexture = UGraphics.getActiveTexture();
        UGraphics.setActiveTexture(33984 + index2);
        block.run();
        UGraphics.setActiveTexture(prevActiveTexture);
    }

    @Deprecated
    public static void activeTexture(int glId) {
        UGraphics.setActiveTexture(glId);
    }

    public static int getActiveTexture() {
        return GL11.glGetInteger((int)34016);
    }

    public static void setActiveTexture(int glId) {
        GlStateManager.func_179138_g((int)glId);
    }

    @Deprecated
    public static void bindTexture(int glTextureId) {
        GlStateManager.func_179144_i((int)glTextureId);
    }

    @Deprecated
    public static void bindTexture(ResourceLocation resourceLocation) {
        UGraphics.bindTexture(UGraphics.getOrLoadTextureId(resourceLocation));
    }

    public static void bindTexture(int index2, int glTextureId) {
        UGraphics.configureTextureUnit(index2, () -> GlStateManager.func_179144_i((int)glTextureId));
    }

    public static void bindTexture(int index2, ResourceLocation resourceLocation) {
        UGraphics.bindTexture(index2, UGraphics.getOrLoadTextureId(resourceLocation));
    }

    private static int getOrLoadTextureId(ResourceLocation resourceLocation) {
        TextureManager textureManager = UMinecraft.getMinecraft().func_110434_K();
        ITextureObject texture = textureManager.func_110581_b(resourceLocation);
        if (texture == null) {
            texture = new SimpleTexture(resourceLocation);
            textureManager.func_110579_a(resourceLocation, texture);
        }
        return texture.func_110552_b();
    }

    public static int getStringWidth(String in) {
        return UMinecraft.getFontRenderer().func_78256_a(in);
    }

    public static int getFontHeight() {
        return UMinecraft.getFontRenderer().field_78288_b;
    }

    @Deprecated
    public static void drawString(String text, float x, float y, int color, boolean shadow) {
        UGraphics.drawString(UNIT_STACK, text, x, y, color, shadow);
    }

    public static void drawString(UMatrixStack stack, String text, float x, float y, int color, boolean shadow) {
        if ((color >> 24 & 0xFF) <= 10) {
            return;
        }
        if (stack != UNIT_STACK) {
            GL.pushMatrix();
        }
        if (stack != UNIT_STACK) {
            stack.applyToGlobalState();
        }
        UMinecraft.getFontRenderer().func_175065_a(text, x, y, color, shadow);
        if (stack != UNIT_STACK) {
            GL.popMatrix();
        }
    }

    @Deprecated
    public static void drawString(String text, float x, float y, int color, int shadowColor) {
        UGraphics.drawString(UNIT_STACK, text, x, y, color, shadowColor);
    }

    public static void drawString(UMatrixStack stack, String text, float x, float y, int color, int shadowColor) {
        if ((color >> 24 & 0xFF) <= 10) {
            return;
        }
        String shadowText = ChatColor.Companion.stripColorCodes(text);
        if (stack != UNIT_STACK) {
            GL.pushMatrix();
        }
        if (stack != UNIT_STACK) {
            stack.applyToGlobalState();
        }
        UMinecraft.getFontRenderer().func_175065_a(shadowText, x + 1.0f, y + 1.0f, shadowColor, false);
        UMinecraft.getFontRenderer().func_175065_a(text, x, y, color, false);
        if (stack != UNIT_STACK) {
            GL.popMatrix();
        }
    }

    public static List<String> listFormattedStringToWidth(String str, int wrapWidth) {
        return UGraphics.listFormattedStringToWidth(str, wrapWidth, true);
    }

    public static List<String> listFormattedStringToWidth(String str, int wrapWidth, boolean safe) {
        if (safe) {
            String tmp = formattingCodePattern.matcher(str).replaceAll("");
            int max = 0;
            for (String s2 : tmp.split(" ")) {
                max = Math.max(max, UGraphics.getStringWidth(s2));
            }
            wrapWidth = Math.max(max, wrapWidth);
        }
        return UMinecraft.getFontRenderer().func_78271_c(str, wrapWidth);
    }

    public static float getCharWidth(char character) {
        return UMinecraft.getFontRenderer().func_78263_a(character);
    }

    public static void glClear(int mode) {
        GL11.glClear((int)mode);
    }

    public static void glClearStencil(int mode) {
        GL11.glClearStencil((int)mode);
    }

    public static ReleasedDynamicTexture getTexture(InputStream stream) {
        try {
            return new ReleasedDynamicTexture(ImageIO.read(stream));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to read image");
        }
    }

    public static ReleasedDynamicTexture getTexture(BufferedImage img) {
        return new ReleasedDynamicTexture(img);
    }

    public static ReleasedDynamicTexture getEmptyTexture() {
        return new ReleasedDynamicTexture(0, 0);
    }

    public static void glUseProgram(int program) {
        OpenGlHelper.func_153161_d((int)program);
    }

    public static boolean isOpenGl21Supported() {
        return OpenGlHelper.field_148827_a;
    }

    public static boolean areShadersSupported() {
        return OpenGlHelper.func_153193_b();
    }

    public static int glCreateProgram() {
        return OpenGlHelper.func_153183_d();
    }

    public static int glCreateShader(int type2) {
        return OpenGlHelper.func_153195_b((int)type2);
    }

    public static void glCompileShader(int shaderIn) {
        OpenGlHelper.func_153170_c((int)shaderIn);
    }

    public static int glGetShaderi(int shaderIn, int pname) {
        return OpenGlHelper.func_153157_c((int)shaderIn, (int)pname);
    }

    public static String glGetShaderInfoLog(int shader, int maxLen) {
        return OpenGlHelper.func_153158_d((int)shader, (int)maxLen);
    }

    public static void glAttachShader(int program, int shaderIn) {
        OpenGlHelper.func_153178_b((int)program, (int)shaderIn);
    }

    public static void glLinkProgram(int program) {
        OpenGlHelper.func_153179_f((int)program);
    }

    public static int glGetProgrami(int program, int pname) {
        return OpenGlHelper.func_153175_a((int)program, (int)pname);
    }

    public static String glGetProgramInfoLog(int program, int maxLen) {
        return OpenGlHelper.func_153166_e((int)program, (int)maxLen);
    }

    public static void color4f(float red, float green, float blue, float alpha) {
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void directColor3f(float red, float green, float blue) {
        GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
    }

    public static void enableDepth() {
        GlStateManager.func_179126_j();
    }

    public static void depthFunc(int mode) {
        GlStateManager.func_179143_c((int)mode);
    }

    public static void depthMask(boolean flag) {
        GlStateManager.func_179132_a((boolean)flag);
    }

    public static void disableDepth() {
        GlStateManager.func_179097_i();
    }

    public UGraphics beginWithActiveShader(DrawMode mode, CommonVertexFormats format) {
        return this.beginWithActiveShader(mode, format.mc);
    }

    public UGraphics beginWithActiveShader(DrawMode mode, VertexFormat format) {
        this.vertexFormat = format;
        this.instance.func_181668_a(mode.mcMode, format);
        return this;
    }

    public UGraphics beginWithDefaultShader(DrawMode mode, CommonVertexFormats format) {
        return this.beginWithDefaultShader(mode, format.mc);
    }

    public UGraphics beginWithDefaultShader(DrawMode mode, VertexFormat format) {
        return this.beginWithActiveShader(mode, format);
    }

    @Deprecated
    public UGraphics begin(int glMode, CommonVertexFormats format) {
        return this.begin(glMode, format.mc);
    }

    @Deprecated
    public UGraphics begin(int glMode, VertexFormat format) {
        this.instance.func_181668_a(glMode, format);
        return this;
    }

    public void drawDirect() {
        this.doDraw();
    }

    public void drawSorted(int cameraX, int cameraY, int cameraZ) {
        this.instance.func_181674_a((float)cameraX, (float)cameraY, (float)cameraZ);
        this.doDraw();
    }

    private static boolean[] getDesiredTextureUnitState(VertexFormat vertexFormat) {
        boolean[] wantEnabled = new boolean[2];
        for (VertexFormatElement element : vertexFormat.func_177343_g()) {
            if (element.func_177375_c() != VertexFormatElement.EnumUsage.UV) continue;
            int index2 = element.func_177369_e();
            if (wantEnabled.length <= index2) {
                wantEnabled = Arrays.copyOf(wantEnabled, index2 + 1);
            }
            wantEnabled[index2] = true;
        }
        return wantEnabled;
    }

    private void doDraw() {
        VertexFormat vertexFormat = this.vertexFormat;
        if (vertexFormat == null) {
            UGraphics.getTessellator().func_78381_a();
            return;
        }
        boolean[] wantEnabledStates = UGraphics.getDesiredTextureUnitState(vertexFormat);
        boolean[] wasEnabledStates = new boolean[wantEnabledStates.length];
        int i = 0;
        while (i < wasEnabledStates.length) {
            int index2 = i++;
            UGraphics.configureTextureUnit(index2, () -> {
                boolean wantEnabled;
                wasEnabledStates[index2] = GL11.glIsEnabled((int)3553);
                boolean isEnabled = wasEnabledStates[index2];
                if (isEnabled != (wantEnabled = wantEnabledStates[index2])) {
                    if (wantEnabled) {
                        GlStateManager.func_179098_w();
                    } else {
                        GlStateManager.func_179090_x();
                    }
                }
            });
        }
        UGraphics.getTessellator().func_78381_a();
        for (i = 0; i < wasEnabledStates.length; ++i) {
            if (wasEnabledStates[i] == wantEnabledStates[i]) continue;
            if (wasEnabledStates[i]) {
                UGraphics.configureTextureUnit(i, GlStateManager::func_179098_w);
                continue;
            }
            UGraphics.configureTextureUnit(i, GlStateManager::func_179090_x);
        }
    }

    @Deprecated
    public UGraphics pos(double x, double y, double z) {
        return this.pos(UNIT_STACK, x, y, z);
    }

    public UGraphics pos(UMatrixStack stack, double x, double y, double z) {
        if (stack == UNIT_STACK) {
            this.instance.func_181662_b(x, y, z);
        } else {
            Vector4f vec = new Vector4f((float)x, (float)y, (float)z, 1.0f);
            Matrix4f.transform((Matrix4f)stack.peek().getModel(), (Vector4f)vec, (Vector4f)vec);
            this.instance.func_181662_b((double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
        }
        return this;
    }

    @Deprecated
    public UGraphics norm(float x, float y, float z) {
        return this.norm(UNIT_STACK, x, y, z);
    }

    public UGraphics norm(UMatrixStack stack, float x, float y, float z) {
        if (stack == UNIT_STACK) {
            this.instance.func_181663_c(x, y, z);
        } else {
            Vector3f vec = new Vector3f(x, y, z);
            Matrix3f.transform((Matrix3f)stack.peek().getNormal(), (Vector3f)vec, (Vector3f)vec);
            this.instance.func_181663_c(vec.getX(), vec.getY(), vec.getZ());
        }
        return this;
    }

    public UGraphics color(int red, int green, int blue, int alpha) {
        return this.color((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public UGraphics color(float red, float green, float blue, float alpha) {
        this.instance.func_181666_a(red, green, blue, alpha);
        return this;
    }

    public UGraphics color(Color color) {
        return this.color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public UGraphics endVertex() {
        this.instance.func_181675_d();
        return this;
    }

    public UGraphics tex(double u, double v) {
        this.instance.func_187315_a(u, v);
        return this;
    }

    public UGraphics overlay(int u, int v) {
        this.instance.func_187315_a((double)u, (double)v);
        return this;
    }

    public UGraphics light(int u, int v) {
        this.instance.func_187314_a(u, v);
        return this;
    }

    public static class GL {
        public static void pushMatrix() {
            GlStateManager.func_179094_E();
        }

        public static void popMatrix() {
            GlStateManager.func_179121_F();
        }

        public static void translate(float x, float y, float z) {
            GL.translate((double)x, (double)y, (double)z);
        }

        public static void translate(double x, double y, double z) {
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        }

        public static void rotate(float angle, float x, float y, float z) {
            GlStateManager.func_179114_b((float)angle, (float)x, (float)y, (float)z);
        }

        public static void scale(float x, float y, float z) {
            GL.scale((double)x, (double)y, (double)z);
        }

        public static void scale(double x, double y, double z) {
            GlStateManager.func_179139_a((double)x, (double)y, (double)z);
        }
    }

    public static enum CommonVertexFormats {
        POSITION(DefaultVertexFormats.field_181705_e),
        POSITION_COLOR(DefaultVertexFormats.field_181706_f),
        POSITION_TEXTURE(DefaultVertexFormats.field_181707_g),
        POSITION_TEXTURE_COLOR(DefaultVertexFormats.field_181709_i),
        POSITION_COLOR_TEXTURE_LIGHT(DefaultVertexFormats.field_176600_a),
        POSITION_TEXTURE_LIGHT_COLOR(DefaultVertexFormats.field_181711_k),
        POSITION_TEXTURE_COLOR_LIGHT(DefaultVertexFormats.field_181704_d),
        POSITION_TEXTURE_COLOR_NORMAL(DefaultVertexFormats.field_181712_l);

        private final VertexFormat mc;

        private CommonVertexFormats(VertexFormat mc) {
            this.mc = mc;
        }
    }

    public static enum DrawMode {
        LINES(1),
        LINE_STRIP(3),
        TRIANGLES(4),
        TRIANGLE_STRIP(5),
        TRIANGLE_FAN(6),
        QUADS(7);

        private final int glMode;
        private final int mcMode;

        private DrawMode(int glMode) {
            this.glMode = glMode;
            this.mcMode = glMode;
        }

        public static DrawMode fromGl(int glMode) {
            switch (glMode) {
                case 1: {
                    return LINES;
                }
                case 3: {
                    return LINE_STRIP;
                }
                case 4: {
                    return TRIANGLES;
                }
                case 5: {
                    return TRIANGLE_STRIP;
                }
                case 6: {
                    return TRIANGLE_FAN;
                }
                case 7: {
                    return QUADS;
                }
            }
            throw new IllegalArgumentException("Unsupported draw mode " + glMode);
        }
    }
}

