/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.deencapsulation;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import sun.misc.Unsafe;

public final class Deencapsulation {
    private static final MethodHandle CLASS_MODULE;
    private static final MethodHandle CLASS_LOADER_MODULE;
    private static final MethodHandle METHOD_MODIFIERS;

    private Deencapsulation() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deencapsulate(Class<?> classBase) {
        try {
            Method export = Module.class.getDeclaredMethod("implAddOpens", String.class);
            Deencapsulation.setMethodModifiers(export, 1);
            HashSet<Module> modules = new HashSet<Module>();
            Module base = Deencapsulation.getClassModule(classBase);
            if (base.getLayer() != null) {
                modules.addAll(base.getLayer().modules());
            }
            modules.addAll(ModuleLayer.boot().modules());
            for (ClassLoader cl = classBase.getClassLoader(); cl != null; cl = cl.getParent()) {
                modules.add(Deencapsulation.getLoaderModule(cl));
            }
            for (Module module : modules) {
                for (String name : module.getPackages()) {
                    try {
                        export.invoke((Object)module, name);
                    }
                    catch (Exception ex) {
                        throw new AssertionError((Object)ex);
                    }
                }
                continue;
                return;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not export packages", ex);
        }
    }

    private static Module getClassModule(Class<?> klass) {
        try {
            return CLASS_MODULE.invokeExact(klass);
        }
        catch (Throwable t2) {
            throw new AssertionError((Object)t2);
        }
    }

    private static Module getLoaderModule(ClassLoader loader) {
        try {
            return CLASS_LOADER_MODULE.invokeExact(loader);
        }
        catch (Throwable t2) {
            throw new AssertionError((Object)t2);
        }
    }

    private static void setMethodModifiers(Method method, int modifiers) {
        try {
            METHOD_MODIFIERS.invokeExact(method, modifiers);
        }
        catch (Throwable t2) {
            throw new AssertionError((Object)t2);
        }
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Unsafe unsafe = (Unsafe)field.get(null);
            field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            MethodHandles.publicLookup();
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(field), unsafe.staticFieldOffset(field));
            MethodType type2 = MethodType.methodType(Module.class);
            CLASS_MODULE = lookup.findVirtual(Class.class, "getModule", type2);
            CLASS_LOADER_MODULE = lookup.findVirtual(ClassLoader.class, "getUnnamedModule", type2);
            METHOD_MODIFIERS = lookup.findSetter(Method.class, "modifiers", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

