/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.caffeine.cache.stats;

import cc.polyfrost.oneconfig.libs.caffeine.cache.RemovalCause;
import cc.polyfrost.oneconfig.libs.caffeine.cache.stats.CacheStats;
import cc.polyfrost.oneconfig.libs.caffeine.cache.stats.StatsCounter;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

final class GuardedStatsCounter
implements StatsCounter {
    static final Logger logger = Logger.getLogger(GuardedStatsCounter.class.getName());
    final StatsCounter delegate;

    GuardedStatsCounter(StatsCounter delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void recordHits(int count2) {
        try {
            this.delegate.recordHits(count2);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordMisses(int count2) {
        try {
            this.delegate.recordMisses(count2);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordLoadSuccess(long loadTime) {
        try {
            this.delegate.recordLoadSuccess(loadTime);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordLoadFailure(long loadTime) {
        try {
            this.delegate.recordLoadFailure(loadTime);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordEviction() {
        try {
            this.delegate.recordEviction();
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordEviction(int weight) {
        try {
            this.delegate.recordEviction(weight);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public void recordEviction(int weight, RemovalCause cause) {
        try {
            this.delegate.recordEviction(weight, cause);
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
        }
    }

    @Override
    public CacheStats snapshot() {
        try {
            return this.delegate.snapshot();
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by stats counter", t2);
            return CacheStats.empty();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

