/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.caffeine.cache;

import cc.polyfrost.oneconfig.libs.caffeine.cache.Scheduler;
import cc.polyfrost.oneconfig.libs.checker.nullness.qual.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

enum SystemScheduler implements Scheduler
{
    INSTANCE;

    static final @Nullable Method delayedExecutor;

    @Override
    public Future<?> schedule(Executor executor, Runnable command2, long delay, TimeUnit unit) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(command2);
        Objects.requireNonNull(unit);
        try {
            Executor scheduler = (Executor)delayedExecutor.invoke(CompletableFuture.class, new Object[]{delay, unit, executor});
            return CompletableFuture.runAsync(command2, scheduler);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static @Nullable Method getDelayedExecutorMethod() {
        try {
            return CompletableFuture.class.getMethod("delayedExecutor", Long.TYPE, TimeUnit.class, Executor.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    static boolean isPresent() {
        return delayedExecutor != null;
    }

    static {
        delayedExecutor = SystemScheduler.getDelayedExecutorMethod();
    }
}

