/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.caffeine.cache;

import cc.polyfrost.oneconfig.libs.checker.nullness.qual.Nullable;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

interface LinkedDeque<E>
extends Deque<E> {
    public boolean isFirst(E var1);

    public boolean isLast(E var1);

    public void moveToFront(E var1);

    public void moveToBack(E var1);

    public @Nullable E getPrevious(E var1);

    public void setPrevious(E var1, @Nullable E var2);

    public @Nullable E getNext(E var1);

    public void setNext(E var1, @Nullable E var2);

    @Override
    public PeekingIterator<E> iterator();

    @Override
    public PeekingIterator<E> descendingIterator();

    public static interface PeekingIterator<E>
    extends Iterator<E> {
        public @Nullable E peek();

        public static <E> PeekingIterator<E> concat(final PeekingIterator<E> first2, final PeekingIterator<E> second2) {
            return new PeekingIterator<E>(){

                @Override
                public boolean hasNext() {
                    return first2.hasNext() || second2.hasNext();
                }

                @Override
                public E next() {
                    if (first2.hasNext()) {
                        return first2.next();
                    }
                    if (second2.hasNext()) {
                        return second2.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public @Nullable E peek() {
                    return first2.hasNext() ? first2.peek() : second2.peek();
                }
            };
        }

        public static <E> PeekingIterator<E> comparing(final PeekingIterator<E> first2, final PeekingIterator<E> second2, final Comparator<E> comparator) {
            return new PeekingIterator<E>(){

                @Override
                public boolean hasNext() {
                    return first2.hasNext() || second2.hasNext();
                }

                @Override
                public E next() {
                    Object o2;
                    if (!first2.hasNext()) {
                        return second2.next();
                    }
                    if (!second2.hasNext()) {
                        return first2.next();
                    }
                    Object o1 = first2.peek();
                    boolean greaterOrEqual = comparator.compare(o1, o2 = second2.peek()) >= 0;
                    return greaterOrEqual ? first2.next() : second2.next();
                }

                @Override
                public @Nullable E peek() {
                    Object o2;
                    if (!first2.hasNext()) {
                        return second2.peek();
                    }
                    if (!second2.hasNext()) {
                        return first2.peek();
                    }
                    Object o1 = first2.peek();
                    boolean greaterOrEqual = comparator.compare(o1, o2 = second2.peek()) >= 0;
                    return greaterOrEqual ? first2.peek() : second2.peek();
                }
            };
        }
    }
}

