/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.libs.caffeine.cache;

import cc.polyfrost.oneconfig.libs.caffeine.cache.DisabledFuture;
import cc.polyfrost.oneconfig.libs.caffeine.cache.Scheduler;
import cc.polyfrost.oneconfig.libs.checker.nullness.qual.NonNull;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class GuardedScheduler
implements Scheduler,
Serializable {
    static final Logger logger = Logger.getLogger(GuardedScheduler.class.getName());
    static final long serialVersionUID = 1L;
    final Scheduler delegate;

    GuardedScheduler(Scheduler delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public @NonNull Future<?> schedule(@NonNull Executor executor, @NonNull Runnable command2, long delay, @NonNull TimeUnit unit) {
        try {
            Future<?> future = this.delegate.schedule(executor, command2, delay, unit);
            return future == null ? DisabledFuture.INSTANCE : future;
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by scheduler; discarded task", t2);
            return DisabledFuture.INSTANCE;
        }
    }
}

