/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.utils;

import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.ChainedAnimation;
import cc.polyfrost.oneconfig.gui.animations.ColorAnimation;
import cc.polyfrost.oneconfig.gui.animations.DummyAnimation;
import cc.polyfrost.oneconfig.gui.animations.EaseInOutQuad;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.libs.universal.UResolution;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.asset.Icon;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.renderer.scissor.Scissor;
import cc.polyfrost.oneconfig.renderer.scissor.ScissorHelper;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.MathUtils;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Nullable;

public final class Notification {
    private final String title;
    private final String message;
    private final Icon icon;
    private final Animation animation;
    private final Callable<Float> progressBar;
    private final Runnable action;
    private final InputHandler inputHandler = new InputHandler();
    private final ColorAnimation bgColor = new ColorAnimation(new ColorPalette(Colors.GRAY_800, Colors.GRAY_700, Colors.GRAY_900));
    private final ColorAnimation titleColor = new ColorAnimation(new ColorPalette(Colors.WHITE_80, Colors.WHITE, Colors.WHITE));
    private final ColorAnimation messageColor = new ColorAnimation(new ColorPalette(Colors.WHITE_60, Colors.WHITE_90, Colors.WHITE_90));
    private boolean hovered = false;

    public Notification(String title, String message, @Nullable Icon icon, float duration, @Nullable Callable<Float> progressBar, @Nullable Runnable action) {
        this.title = title;
        this.message = message;
        this.icon = icon;
        this.animation = new ChainedAnimation(new EaseInOutQuad(250, 0.0f, 330.0f, false), progressBar == null ? new DummyAnimation(330.0f, duration) : new DummyAnimation(330.0f, () -> ((Float)progressBar.call()).floatValue() >= 1.0f), new EaseInOutQuad(250, 330.0f, 0.0f, false));
        this.progressBar = progressBar;
        this.action = action;
    }

    public float draw(long vg, float y, float scale, float deltaTime) {
        NanoVGHelper renderer = NanoVGHelper.INSTANCE;
        renderer.scale(vg, scale, scale);
        this.inputHandler.scale(scale, scale);
        float x = (float)UResolution.getWindowWidth() / scale - this.animation.get(this.hovered ? 0.0f : deltaTime);
        float textX = this.icon == null ? x + 16.0f : x + 64.0f;
        float textMaxLength = this.icon == null ? 268.0f : 220.0f;
        float messageHeight = renderer.getWrappedStringHeight(vg, this.message, textMaxLength, 12.0f, 1.0f, Fonts.REGULAR);
        float height = this.getHeight(messageHeight);
        this.hovered = this.inputHandler.isAreaHovered(x, y -= height, 314.0f, height);
        if (this.hovered && this.inputHandler.isClicked() && this.action != null) {
            this.action.run();
        }
        int bgColor = this.bgColor.getColor(this.hovered, this.hovered && this.inputHandler.isMouseDown());
        int titleColor = this.titleColor.getColor(this.hovered, this.hovered && this.inputHandler.isMouseDown());
        int messageColor = this.messageColor.getColor(this.hovered, this.hovered && this.inputHandler.isMouseDown());
        renderer.drawRoundedRect(vg, x, y, 314.0f, height, bgColor, 8.0f);
        if (this.icon != null) {
            this.icon.draw(vg, x + 16.0f, y + (height - (this.progressBar == null ? 0.0f : 5.0f)) / 2.0f - 16.0f, 32.0f, 32.0f, titleColor, scale);
        }
        renderer.drawText(vg, this.title, textX, y + 30.0f, titleColor, 16.0f, Fonts.SEMIBOLD);
        renderer.drawWrappedString(vg, this.message, textX, y + 46.0f, textMaxLength, messageColor, 12.0f, 1.0f, Fonts.REGULAR);
        if (this.progressBar != null) {
            try {
                ScissorHelper scissorHelper = ScissorHelper.INSTANCE;
                float progress = MathUtils.clamp(this.progressBar.call().floatValue());
                Scissor scissor1 = scissorHelper.scissor(vg, x + 314.0f * progress, y + height - 5.0f, 314.0f * (1.0f - progress), 5.0f);
                renderer.drawRoundedRect(vg, x, y, 314.0f, height, Colors.PRIMARY_800, 8.0f);
                scissorHelper.resetScissor(vg, scissor1);
                Scissor scissor2 = scissorHelper.scissor(vg, x, y + height - 5.0f, 314.0f * progress - (314.0f * progress < 2.5f || 311.5f * progress > 2.5f ? 0.0f : 2.5f), 5.0f);
                renderer.drawRoundedRect(vg, x, y, 314.0f, height, Colors.PRIMARY_500, 8.0f);
                scissorHelper.resetScissor(vg, scissor2);
                if (314.0f * progress >= 2.5f && 311.5f * progress <= 2.5f) {
                    renderer.drawRoundedRect(vg, x + 2.5f, y + height - 5.0f, Math.max(0.0f, 314.0f * progress - 5.0f), 5.0f, Colors.PRIMARY_500, 2.5f);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        renderer.resetTransform(vg);
        return height;
    }

    private float getHeight(float messageHeight) {
        float height = 68.0f + messageHeight;
        if (this.progressBar != null) {
            height += 5.0f;
        }
        return height;
    }

    public boolean isFinished() {
        return this.animation.isFinished();
    }
}

