/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.utils;

import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.EaseOutQuad;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.asset.SVG;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DescriptionRenderer {
    private static final NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;

    public static int drawDescription(long vg, int x, int y, @NotNull String description2, @Nullable String warningDescription, @NotNull Supplier<Animation> animationSupplier, @NotNull Consumer<Animation> animationSetter, @Nullable SVG icon, boolean shouldDrawDescription, @NotNull DescriptionPosition position, @NotNull InputHandler inputHandler) {
        int returnValue;
        float textWidth;
        float textHeight;
        Animation animation = animationSupplier.get();
        EaseOutQuad targetAnim = null;
        if (animation.getEnd() != 1.0f && shouldDrawDescription) {
            targetAnim = new EaseOutQuad(150, animation.get(0.0f), 1.0f, false);
        } else if (animation.getEnd() != 0.0f && !shouldDrawDescription) {
            targetAnim = new EaseOutQuad(150, animation.get(0.0f), 0.0f, false);
        }
        if (targetAnim != null) {
            animation = targetAnim;
            animationSetter.accept(targetAnim);
        }
        if (!shouldDrawDescription && animation.isFinished()) {
            return -1;
        }
        float[] descriptionBounds = nanoVGHelper.getWrappedStringBounds(vg, description2, 400.0f, 16.0f, 1.0f, Fonts.MEDIUM);
        float[] warningBounds = new float[]{};
        if (warningDescription == null) {
            textHeight = descriptionBounds[3] - descriptionBounds[1];
            textWidth = descriptionBounds[2] - descriptionBounds[0];
        } else {
            warningBounds = nanoVGHelper.getWrappedStringBounds(vg, warningDescription, 400.0f, 16.0f, 1.0f, Fonts.MEDIUM);
            textHeight = descriptionBounds[3] - descriptionBounds[1] + (warningBounds[3] - warningBounds[1]);
            textWidth = Math.max(descriptionBounds[2] - descriptionBounds[0], warningBounds[2] - warningBounds[0]);
        }
        nanoVGHelper.setAlpha(vg, animation.get());
        switch (position) {
            case RIGHT: {
                nanoVGHelper.translate(vg, -(textWidth + 68.0f), 0.0f);
                break;
            }
            case MIDDLE: {
                nanoVGHelper.translate(vg, -(textWidth / 2.0f + 34.0f), 0.0f);
            }
        }
        if (warningDescription != null) {
            returnValue = (int)(91.0f + (textHeight - 32.0f));
            nanoVGHelper.drawRoundedRect(vg, (float)x - 1.0f, (float)y - 42.0f - 47.0f - (textHeight - 32.0f), textWidth + 70.0f, returnValue, Colors.GRAY_700, 8.0f);
            nanoVGHelper.drawRoundedRect(vg, (float)x - 1.0f, (float)y - 42.0f - 47.0f - (textHeight - 32.0f), textWidth + 70.0f, returnValue, ColorUtils.getColor(204, 204, 204, 25), 8.0f);
            nanoVGHelper.drawRoundedRect(vg, x, (float)y - 42.0f - 46.0f - (textHeight - 32.0f), textWidth + 68.0f, (float)returnValue - 2.0f, Colors.GRAY_700, 8.0f);
            nanoVGHelper.drawSvg(vg, SVGs.WARNING, (float)(x + 16), (float)y - 30.0f - (warningBounds[3] - warningBounds[1] - 16.0f), 20.0f, 20.0f, ColorUtils.getColor(223, 51, 39));
            nanoVGHelper.drawWrappedString(vg, warningDescription, x + 52, (float)y - 19.0f - (warningBounds[3] - warningBounds[1] - 16.0f), 400.0f, ColorUtils.getColor(223, 51, 39), 16.0f, 1.0f, Fonts.MEDIUM);
            nanoVGHelper.drawLine(vg, (float)x + 16.0f, (float)y - 42.0f - 47.0f - (textHeight - 32.0f) + (91.0f + (textHeight - 32.0f)) / 2.0f, (float)x + textWidth + 68.0f - 16.0f, (float)y - 42.0f - 47.0f - (textHeight - 32.0f) + (91.0f + (textHeight - 32.0f)) / 2.0f, 1.0f, ColorUtils.getColor(204, 204, 204, 25));
            nanoVGHelper.drawSvg(vg, SVGs.INFO_ARROW, (float)(x + 16), (float)y - 14.0f - 45.0f - (textHeight - 16.0f), 20.0f, 20.0f, Colors.WHITE_80);
            nanoVGHelper.drawWrappedString(vg, description2, x + 52, (float)y - 3.0f - 45.0f - (textHeight - 16.0f), 400.0f, Colors.WHITE_80, 16.0f, 1.0f, Fonts.MEDIUM);
        } else {
            returnValue = (int)(46.0f + (textHeight - 16.0f));
            nanoVGHelper.drawRoundedRect(vg, (float)x - 1.0f, (float)y - 42.0f - 1.0f - (textHeight - 16.0f), textWidth + 70.0f, returnValue, Colors.GRAY_700, 8.0f);
            nanoVGHelper.drawRoundedRect(vg, (float)x - 1.0f, (float)y - 42.0f - 1.0f - (textHeight - 16.0f), textWidth + 70.0f, returnValue, ColorUtils.getColor(204, 204, 204, 25), 8.0f);
            nanoVGHelper.drawRoundedRect(vg, x, (float)y - 42.0f - (textHeight - 16.0f), textWidth + 68.0f, (float)returnValue - 2.0f, Colors.GRAY_700, 8.0f);
            nanoVGHelper.drawSvg(vg, icon == null ? SVGs.INFO_ARROW : icon, (float)(x + 16), (float)y - 30.0f - (textHeight - 16.0f), 20.0f, 20.0f, Colors.WHITE_80);
            nanoVGHelper.drawWrappedString(vg, description2, x + 52, (float)(y - 19) - (textHeight - 16.0f), 400.0f, Colors.WHITE_80, 16.0f, 1.0f, Fonts.MEDIUM);
        }
        switch (position) {
            case RIGHT: {
                nanoVGHelper.translate(vg, textWidth + 68.0f, 0.0f);
                break;
            }
            case MIDDLE: {
                nanoVGHelper.translate(vg, textWidth / 2.0f + 34.0f, 0.0f);
            }
        }
        nanoVGHelper.setAlpha(vg, 1.0f);
        return returnValue;
    }

    public static enum DescriptionPosition {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

