/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.utils;

import cc.polyfrost.oneconfig.utils.LogScanner;
import cc.polyfrost.oneconfig.utils.Notifications;
import java.util.HashSet;
import java.util.Set;

public final class Deprecator {
    private static final Set<String> warned = new HashSet<String>();

    public static void markDeprecated() {
        try {
            throw new Exception("This method is deprecated");
        }
        catch (Exception e) {
            String culprit = LogScanner.identifyCallerFromStacktrace(e).stream().map(activeMod -> activeMod.name).findFirst().orElse("Unknown");
            if (culprit.equals("OneConfig")) {
                return;
            }
            if (warned.add(culprit)) {
                Notifications.INSTANCE.send("Deprecation Warning", "The mod '" + culprit + "' is using a deprecated method, and will no longer work in the future. Please report this to the mod author.");
                try {
                    throw new UnsupportedOperationException("Method " + e.getStackTrace()[1].getClassName() + "." + e.getStackTrace()[1].getMethodName() + "() is deprecated; but is still being used by mod " + culprit + "!");
                }
                catch (UnsupportedOperationException e1) {
                    e1.printStackTrace();
                }
            }
            return;
        }
    }
}

