/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.renderer;

import cc.polyfrost.oneconfig.renderer.TinyFD;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class TinyFDImpl
implements TinyFD {
    @Override
    public File openSaveSelector(String title, @Nullable String defaultFilePath, String[] filterPatterns, String filterDescription) {
        PointerBuffer p = null;
        if (filterPatterns != null && filterPatterns.length != 0) {
            p = TinyFDImpl.stringsToPointerBuffer(filterPatterns);
        }
        String out = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)(title == null ? "Save" : title), (CharSequence)defaultFilePath, (PointerBuffer)p, (CharSequence)filterDescription);
        return out == null ? null : new File(out);
    }

    @Override
    public File openFileSelector(String title, @Nullable String defaultFilePath, String[] filterPatterns, String filterDescription) {
        PointerBuffer p = null;
        if (filterPatterns != null && filterPatterns.length != 0) {
            p = TinyFDImpl.stringsToPointerBuffer(filterPatterns);
        }
        String out = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)(title == null ? "Open file" : title), (CharSequence)defaultFilePath, (PointerBuffer)p, (CharSequence)filterDescription, (boolean)false);
        return out == null ? null : new File(out);
    }

    @Override
    public File[] openMultiFileSelector(String title, @Nullable String defaultFilePath, String[] filterPatterns, String filterDescription) {
        String out;
        PointerBuffer p = null;
        if (filterPatterns != null && filterPatterns.length != 0) {
            p = TinyFDImpl.stringsToPointerBuffer(filterPatterns);
        }
        if ((out = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)(title == null ? "Open files" : title), (CharSequence)defaultFilePath, (PointerBuffer)p, (CharSequence)filterDescription, (boolean)true)) == null) {
            return null;
        }
        String[] split = out.split("\\|");
        File[] files = new File[split.length];
        for (int i = 0; i < split.length; ++i) {
            files[i] = new File(split[i]);
        }
        return files;
    }

    @Override
    public File openFolderSelector(String title, @Nullable String defaultFolderPath) {
        String out = TinyFileDialogs.tinyfd_selectFolderDialog((CharSequence)(title == null ? "Select folder" : title), (CharSequence)defaultFolderPath);
        return out == null ? null : new File(out);
    }

    @Override
    public boolean showMessageBox(String title, String message, @NotNull String dialog, String icon, boolean defaultState) {
        return TinyFileDialogs.tinyfd_messageBox((CharSequence)title, (CharSequence)message, (CharSequence)dialog, (CharSequence)icon, (boolean)defaultState);
    }

    @Override
    public int showNotification(String title, String message, String icon) {
        return TinyFileDialogs.tinyfd_notifyPopup((CharSequence)title, (CharSequence)message, (CharSequence)icon);
    }

    private static PointerBuffer stringsToPointerBuffer(String[] strings) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer p = stack.mallocPointer(strings.length);
            for (int i = 0; i < strings.length; ++i) {
                p.put(i, stack.UTF8((CharSequence)strings[i]));
            }
            PointerBuffer pointerBuffer = (PointerBuffer)p.flip();
            return pointerBuffer;
        }
    }
}

