/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.renderer;

import cc.polyfrost.oneconfig.config.data.InfoType;
import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.events.event.FramebufferRenderEvent;
import cc.polyfrost.oneconfig.events.event.Stage;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.UGraphics;
import cc.polyfrost.oneconfig.libs.universal.UResolution;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.TextRenderer;
import cc.polyfrost.oneconfig.renderer.asset.AssetHelper;
import cc.polyfrost.oneconfig.renderer.asset.Image;
import cc.polyfrost.oneconfig.renderer.asset.SVG;
import cc.polyfrost.oneconfig.renderer.font.Font;
import cc.polyfrost.oneconfig.renderer.font.FontHelper;
import cc.polyfrost.oneconfig.utils.IOUtils;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.NetworkUtils;
import cc.polyfrost.oneconfig.utils.color.ColorUtils;
import java.nio.ByteBuffer;
import java.util.function.LongConsumer;
import org.lwjgl.BufferUtils;
import org.lwjgl.nanovg.NVGColor;
import org.lwjgl.nanovg.NVGPaint;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.nanovg.NanoVGGL2;
import org.lwjgl.opengl.GL11;

public final class NanoVGHelperImpl
implements NanoVGHelper {
    private long vg = -1L;
    private static int[] readingPixels = null;
    private static int[] readColors = new int[]{0};
    private boolean drawing = false;
    private boolean goingToCancel = false;

    public NanoVGHelperImpl() {
        EventManager.INSTANCE.register(new Object(){

            @Subscribe
            private void onFramebufferRender(FramebufferRenderEvent event) {
                if (event.stage == Stage.END && NanoVGHelperImpl.this.drawing) {
                    if (NanoVGHelperImpl.this.goingToCancel) {
                        NanoVGHelperImpl.this.drawing = false;
                        NanoVGHelperImpl.this.goingToCancel = false;
                    } else {
                        NanoVGHelperImpl.this.goingToCancel = true;
                    }
                }
            }
        });
    }

    @Override
    public void setupAndDraw(LongConsumer consumer2) {
        this.setupAndDraw(1, false, consumer2);
    }

    @Override
    public void setupAndDraw(boolean mcScaling, LongConsumer consumer2) {
        this.setupAndDraw(1, mcScaling, consumer2);
    }

    @Override
    public void setupAndDraw(int nvgFlags, boolean mcScaling, LongConsumer consumer2) {
        this.drawing = true;
        if (this.vg == -1L) {
            this.vg = NanoVGGL2.nvgCreate((int)nvgFlags);
            if (this.vg == -1L) {
                throw new RuntimeException("Failed to create nvg context");
            }
            FontHelper.INSTANCE.initialize(this.vg);
        }
        try {
            Platform.getGLPlatform().enableStencil();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glPushAttrib((int)1048575);
        UGraphics.disableAlpha();
        if (mcScaling) {
            NanoVG.nvgBeginFrame((long)this.vg, (float)UResolution.getScaledWidth(), (float)UResolution.getScaledHeight(), (float)((float)UResolution.getScaleFactor()));
        } else {
            NanoVG.nvgBeginFrame((long)this.vg, (float)UResolution.getWindowWidth(), (float)UResolution.getWindowHeight(), (float)1.0f);
        }
        consumer2.accept(this.vg);
        NanoVG.nvgEndFrame((long)this.vg);
        UGraphics.enableAlpha();
        GL11.glPopAttrib();
        if (readingPixels != null) {
            int amount = readingPixels[2] * readingPixels[3];
            readColors = new int[amount];
            ByteBuffer buf = BufferUtils.createByteBuffer((int)(readingPixels[2] * readingPixels[3] * 4));
            GL11.glReadPixels((int)readingPixels[0], (int)readingPixels[1], (int)readingPixels[2], (int)readingPixels[3], (int)6408, (int)5121, (ByteBuffer)buf);
            for (int i = 0; i < amount; ++i) {
                NanoVGHelperImpl.readColors[i] = ColorUtils.getColor(buf.get(), buf.get(), buf.get(), buf.get());
            }
            readingPixels = null;
        }
    }

    @Override
    public void drawRect(long vg, float x, float y, float width, float height, int color) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgRect((long)vg, (float)x, (float)y, (float)width, (float)height);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgFill((long)vg);
        nvgColor.free();
    }

    @Override
    public void drawRoundedRect(long vg, float x, float y, float width, float height, int color, float radius) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgRoundedRect((long)vg, (float)x, (float)y, (float)width, (float)height, (float)radius);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgFill((long)vg);
        nvgColor.free();
    }

    @Override
    public void drawRoundedRectVaried(long vg, float x, float y, float width, float height, int color, float radiusTL, float radiusTR, float radiusBR, float radiusBL) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgRoundedRectVarying((long)vg, (float)x, (float)y, (float)width, (float)height, (float)radiusTL, (float)radiusTR, (float)radiusBR, (float)radiusBL);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgFill((long)vg);
        nvgColor.free();
    }

    @Override
    public void drawHollowRoundRect(long vg, float x, float y, float width, float height, int color, float radius, float thickness) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgRoundedRect((long)vg, (float)(x + thickness), (float)(y + thickness), (float)(width - thickness), (float)(height - thickness), (float)radius);
        NanoVG.nvgStrokeWidth((long)vg, (float)(thickness + 0.5f));
        NanoVG.nvgPathWinding((long)vg, (int)2);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgStrokeColor((long)vg, (NVGColor)nvgColor);
        NanoVG.nvgStroke((long)vg);
        nvgColor.free();
    }

    @Override
    public void drawGradientRect(long vg, float x, float y, float width, float height, int color, int color2, NanoVGHelper.GradientDirection direction) {
        NVGPaint bg = NVGPaint.create();
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgRect((long)vg, (float)x, (float)y, (float)width, (float)height);
        NVGColor nvgColor = this.color(vg, color);
        NVGColor nvgColor2 = this.color(vg, color2);
        float[] pts = NanoVGHelper.GradientDirection.getValues(x, y, width, height, direction);
        NanoVG.nvgFillPaint((long)vg, (NVGPaint)NanoVG.nvgLinearGradient((long)vg, (float)pts[0], (float)pts[1], (float)pts[2], (float)pts[3], (NVGColor)nvgColor, (NVGColor)nvgColor2, (NVGPaint)bg));
        NanoVG.nvgFillPaint((long)vg, (NVGPaint)bg);
        NanoVG.nvgFill((long)vg);
        nvgColor.free();
        nvgColor2.free();
    }

    @Override
    public void drawGradientRoundedRect(long vg, float x, float y, float width, float height, int color, int color2, float radius, NanoVGHelper.GradientDirection direction) {
        NVGPaint bg = NVGPaint.create();
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgRoundedRect((long)vg, (float)x, (float)y, (float)width, (float)height, (float)radius);
        NVGColor nvgColor = this.color(vg, color);
        NVGColor nvgColor2 = this.color(vg, color2);
        float[] pts = NanoVGHelper.GradientDirection.getValues(x, y, width, height, direction);
        NanoVG.nvgFillPaint((long)vg, (NVGPaint)NanoVG.nvgLinearGradient((long)vg, (float)pts[0], (float)pts[1], (float)pts[2], (float)pts[3], (NVGColor)nvgColor, (NVGColor)nvgColor2, (NVGPaint)bg));
        NanoVG.nvgFill((long)vg);
        nvgColor.free();
        nvgColor2.free();
    }

    @Override
    public void drawHSBBox(long vg, float x, float y, float width, float height, int colorTarget) {
        this.drawRoundedRect(vg, x, y, width, height, colorTarget, 8.0f);
        NVGPaint bg = NVGPaint.create();
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgRoundedRect((long)vg, (float)x, (float)y, (float)width, (float)height, (float)8.0f);
        NVGColor nvgColor = this.color(vg, -1);
        NVGColor nvgColor2 = this.color(vg, Colors.TRANSPARENT);
        NanoVG.nvgFillPaint((long)vg, (NVGPaint)NanoVG.nvgLinearGradient((long)vg, (float)x, (float)y, (float)(x + width), (float)y, (NVGColor)nvgColor, (NVGColor)nvgColor2, (NVGPaint)bg));
        NanoVG.nvgFill((long)vg);
        nvgColor.free();
        nvgColor2.free();
        NVGPaint bg2 = NVGPaint.create();
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgRoundedRect((long)vg, (float)x, (float)y, (float)width, (float)height, (float)8.0f);
        NVGColor nvgColor3 = this.color(vg, Colors.TRANSPARENT);
        NVGColor nvgColor4 = this.color(vg, Colors.BLACK);
        NanoVG.nvgFillPaint((long)vg, (NVGPaint)NanoVG.nvgLinearGradient((long)vg, (float)x, (float)y, (float)x, (float)(y + height), (NVGColor)nvgColor3, (NVGColor)nvgColor4, (NVGPaint)bg2));
        NanoVG.nvgFill((long)vg);
        nvgColor3.free();
        nvgColor4.free();
    }

    @Override
    public void drawCircle(long vg, float x, float y, float radius, int color) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgCircle((long)vg, (float)x, (float)y, (float)radius);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgFill((long)vg);
        nvgColor.free();
    }

    @Override
    public void drawEllipse(long vg, float x, float y, float radiusX, float radiusY, int color) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgEllipse((long)vg, (float)x, (float)y, (float)radiusX, (float)radiusY);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgFill((long)vg);
        nvgColor.free();
    }

    @Override
    public void drawHollowEllipse(long vg, float x, float y, float radiusX, float radiusY, int color, float thickness) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgEllipse((long)vg, (float)x, (float)y, (float)radiusX, (float)radiusY);
        NanoVG.nvgStrokeWidth((long)vg, (float)(thickness + 0.5f));
        NanoVG.nvgPathWinding((long)vg, (int)2);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgStrokeColor((long)vg, (NVGColor)nvgColor);
        NanoVG.nvgStroke((long)vg);
        nvgColor.free();
    }

    @Override
    public void drawText(long vg, String text, float x, float y, int color, float size, Font font) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgFontSize((long)vg, (float)size);
        NanoVG.nvgFontFace((long)vg, (CharSequence)font.getName());
        NanoVG.nvgTextAlign((long)vg, (int)17);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgText((long)vg, (float)x, (float)y, (CharSequence)text);
        nvgColor.free();
    }

    @Override
    public void drawCenteredText(long vg, String text, float x, float y, int color, float size, Font font) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgFontSize((long)vg, (float)size);
        NanoVG.nvgFontFace((long)vg, (CharSequence)font.getName());
        NanoVG.nvgTextAlign((long)vg, (int)18);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgText((long)vg, (float)x, (float)y, (CharSequence)text);
        nvgColor.free();
    }

    @Override
    public void drawWrappedString(long vg, String text, float x, float y, float width, int color, float size, Font font) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgFontSize((long)vg, (float)size);
        NanoVG.nvgFontFace((long)vg, (CharSequence)font.getName());
        NanoVG.nvgTextAlign((long)vg, (int)17);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgTextBox((long)vg, (float)x, (float)y, (float)width, (CharSequence)text);
        nvgColor.free();
    }

    @Override
    public void drawWrappedString(long vg, String text, float x, float y, float width, int color, float size, float lineHeight, Font font) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgFontSize((long)vg, (float)size);
        NanoVG.nvgFontFace((long)vg, (CharSequence)font.getName());
        NanoVG.nvgTextLineHeight((long)vg, (float)lineHeight);
        NanoVG.nvgTextAlign((long)vg, (int)17);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgTextBox((long)vg, (float)x, (float)y, (float)width, (CharSequence)text);
        nvgColor.free();
    }

    @Override
    public float[] getWrappedStringBounds(long vg, String text, float width, float fontSize, Font font) {
        float[] bounds = new float[4];
        NanoVG.nvgFontSize((long)vg, (float)fontSize);
        NanoVG.nvgFontFace((long)vg, (CharSequence)font.getName());
        NanoVG.nvgTextBoxBounds((long)vg, (float)0.0f, (float)0.0f, (float)width, (CharSequence)text, (float[])bounds);
        return bounds;
    }

    @Override
    public float[] getWrappedStringBounds(long vg, String text, float width, float fontSize, float lineHeight, Font font) {
        float[] bounds = new float[4];
        NanoVG.nvgFontSize((long)vg, (float)fontSize);
        NanoVG.nvgFontFace((long)vg, (CharSequence)font.getName());
        NanoVG.nvgTextLineHeight((long)vg, (float)lineHeight);
        NanoVG.nvgTextBoxBounds((long)vg, (float)0.0f, (float)0.0f, (float)width, (CharSequence)text, (float[])bounds);
        return bounds;
    }

    @Override
    public float getWrappedStringHeight(long vg, String text, float width, float fontSize, float lineHeight, Font font) {
        float[] bounds = new float[4];
        NanoVG.nvgFontSize((long)vg, (float)fontSize);
        NanoVG.nvgFontFace((long)vg, (CharSequence)font.getName());
        NanoVG.nvgTextLineHeight((long)vg, (float)lineHeight);
        NanoVG.nvgTextBoxBounds((long)vg, (float)0.0f, (float)0.0f, (float)width, (CharSequence)text, (float[])bounds);
        return bounds[3] - bounds[1];
    }

    @Override
    public float getWrappedStringWidth(long vg, String text, float width, float fontSize, Font font) {
        float[] bounds = new float[4];
        NanoVG.nvgFontSize((long)vg, (float)fontSize);
        NanoVG.nvgFontFace((long)vg, (CharSequence)font.getName());
        NanoVG.nvgTextBoxBounds((long)vg, (float)0.0f, (float)0.0f, (float)width, (CharSequence)text, (float[])bounds);
        return bounds[2] - bounds[0];
    }

    @Override
    public float getWrappedStringWidth(long vg, String text, float width, float fontSize, float lineHeight, Font font) {
        float[] bounds = new float[4];
        NanoVG.nvgFontSize((long)vg, (float)fontSize);
        NanoVG.nvgFontFace((long)vg, (CharSequence)font.getName());
        NanoVG.nvgTextLineHeight((long)vg, (float)lineHeight);
        NanoVG.nvgTextBoxBounds((long)vg, (float)0.0f, (float)0.0f, (float)width, (CharSequence)text, (float[])bounds);
        return bounds[2] - bounds[0];
    }

    @Override
    public void drawURL(long vg, String url, float x, float y, float size, Font font, InputHandler inputHandler) {
        this.drawText(vg, url, x, y, Colors.PRIMARY_500, size, font);
        float length = this.getTextWidth(vg, url, size, font);
        this.drawRect(vg, x, y + size / 2.0f, length, 1.0f, Colors.PRIMARY_500);
        if (inputHandler.isAreaClicked((int)(x - 2.0f), (int)(y - 1.0f), (int)(length + 4.0f), (int)(size / 2.0f + 3.0f))) {
            NetworkUtils.browseLink(url);
        }
    }

    @Override
    @Deprecated
    public void drawImage(long vg, String filePath, float x, float y, float width, float height) {
        this.drawImage(vg, filePath, x, y, width, height, IOUtils.class);
    }

    @Override
    public void drawImage(long vg, String filePath, float x, float y, float width, float height, Class<?> clazz) {
        AssetHelper assetHelper = AssetHelper.INSTANCE;
        if (assetHelper.loadImage(vg, filePath, clazz)) {
            NVGPaint imagePaint = NVGPaint.calloc();
            int image = assetHelper.getImage(filePath);
            NanoVG.nvgBeginPath((long)vg);
            NanoVG.nvgImagePattern((long)vg, (float)x, (float)y, (float)width, (float)height, (float)0.0f, (int)image, (float)1.0f, (NVGPaint)imagePaint);
            NanoVG.nvgRect((long)vg, (float)x, (float)y, (float)width, (float)height);
            NanoVG.nvgFillPaint((long)vg, (NVGPaint)imagePaint);
            NanoVG.nvgFill((long)vg);
            imagePaint.free();
        }
    }

    @Override
    @Deprecated
    public void drawImage(long vg, String filePath, float x, float y, float width, float height, int color) {
        this.drawImage(vg, filePath, x, y, width, height, color, IOUtils.class);
    }

    @Override
    public void drawImage(long vg, String filePath, float x, float y, float width, float height, int color, Class<?> clazz) {
        AssetHelper assetHelper = AssetHelper.INSTANCE;
        if (assetHelper.loadImage(vg, filePath, clazz)) {
            NVGPaint imagePaint = NVGPaint.calloc();
            int image = assetHelper.getImage(filePath);
            NanoVG.nvgBeginPath((long)vg);
            NanoVG.nvgImagePattern((long)vg, (float)x, (float)y, (float)width, (float)height, (float)0.0f, (int)image, (float)1.0f, (NVGPaint)imagePaint);
            this.drawImageCommon(vg, x, y, width, height, color, imagePaint);
            imagePaint.free();
        }
    }

    private void drawImageCommon(long vg, float x, float y, float width, float height, int color, NVGPaint imagePaint) {
        NanoVG.nvgRGBA((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)), (byte)((byte)(color >> 24 & 0xFF)), (NVGColor)imagePaint.innerColor());
        NanoVG.nvgRect((long)vg, (float)x, (float)y, (float)width, (float)height);
        NanoVG.nvgFillPaint((long)vg, (NVGPaint)imagePaint);
        NanoVG.nvgFill((long)vg);
    }

    @Override
    public void drawImage(long vg, Image image, float x, float y, float width, float height) {
        AssetHelper assetHelper = AssetHelper.INSTANCE;
        if (assetHelper.loadImage(vg, image)) {
            this.drawImage(vg, image.filePath, x, y, width, height, image.getClass());
        }
    }

    @Override
    public void drawImage(long vg, Image image, float x, float y, float width, float height, int color) {
        AssetHelper assetHelper = AssetHelper.INSTANCE;
        if (assetHelper.loadImage(vg, image)) {
            this.drawImage(vg, image.filePath, x, y, width, height, color, image.getClass());
        }
    }

    @Override
    @Deprecated
    public void drawRoundImage(long vg, String filePath, float x, float y, float width, float height, float radius) {
        this.drawRoundImage(vg, filePath, x, y, width, height, radius, IOUtils.class);
    }

    @Override
    public void drawRoundImage(long vg, String filePath, float x, float y, float width, float height, float radius, Class<?> clazz) {
        AssetHelper assetHelper = AssetHelper.INSTANCE;
        if (assetHelper.loadImage(vg, filePath, clazz)) {
            NVGPaint imagePaint = NVGPaint.calloc();
            int image = assetHelper.getImage(filePath);
            NanoVG.nvgBeginPath((long)vg);
            NanoVG.nvgImagePattern((long)vg, (float)x, (float)y, (float)width, (float)height, (float)0.0f, (int)image, (float)1.0f, (NVGPaint)imagePaint);
            NanoVG.nvgRoundedRect((long)vg, (float)x, (float)y, (float)width, (float)height, (float)radius);
            NanoVG.nvgFillPaint((long)vg, (NVGPaint)imagePaint);
            NanoVG.nvgFill((long)vg);
            imagePaint.free();
        }
    }

    @Override
    @Deprecated
    public void drawRoundImage(long vg, Image image, float x, float y, float width, float height, float radius) {
        if (AssetHelper.INSTANCE.loadImage(vg, image)) {
            this.drawRoundImage(vg, image.filePath, x, y, width, height, radius, image.getClass());
        }
    }

    @Override
    public float getTextWidth(long vg, String text, float fontSize, Font font) {
        float[] bounds = new float[4];
        NanoVG.nvgFontSize((long)vg, (float)fontSize);
        NanoVG.nvgFontFace((long)vg, (CharSequence)font.getName());
        return NanoVG.nvgTextBounds((long)vg, (float)0.0f, (float)0.0f, (CharSequence)text, (float[])bounds);
    }

    @Override
    public void drawLine(long vg, float x, float y, float endX, float endY, float width, int color) {
        NanoVG.nvgBeginPath((long)vg);
        NanoVG.nvgMoveTo((long)vg, (float)x, (float)y);
        NanoVG.nvgLineTo((long)vg, (float)endX, (float)endY);
        NVGColor nvgColor = this.color(vg, color);
        NanoVG.nvgStrokeColor((long)vg, (NVGColor)nvgColor);
        NanoVG.nvgStrokeWidth((long)vg, (float)width);
        NanoVG.nvgStroke((long)vg);
        nvgColor.free();
    }

    @Override
    public void drawDropShadow(long vg, float x, float y, float w, float h2, float blur, float spread, float cornerRadius) {
        try (NVGPaint shadowPaint = NVGPaint.calloc();
             NVGColor firstColor = NVGColor.calloc();
             NVGColor secondColor = NVGColor.calloc();){
            this.fillNVGColorWithRGBA(0.0f, 0.0f, 0.0f, 0.5f, firstColor);
            this.fillNVGColorWithRGBA(0.0f, 0.0f, 0.0f, 0.0f, secondColor);
            NanoVG.nvgBoxGradient((long)vg, (float)(x - spread), (float)(y - spread), (float)(w + 2.0f * spread), (float)(h2 + 2.0f * spread), (float)(cornerRadius + spread), (float)blur, (NVGColor)firstColor, (NVGColor)secondColor, (NVGPaint)shadowPaint);
            NanoVG.nvgBeginPath((long)vg);
            NanoVG.nvgRoundedRect((long)vg, (float)(x - spread - blur), (float)(y - spread - blur), (float)(w + 2.0f * spread + 2.0f * blur), (float)(h2 + 2.0f * spread + 2.0f * blur), (float)(cornerRadius + spread));
            NanoVG.nvgRoundedRect((long)vg, (float)x, (float)y, (float)w, (float)h2, (float)cornerRadius);
            NanoVG.nvgPathWinding((long)vg, (int)2);
            NanoVG.nvgFillPaint((long)vg, (NVGPaint)shadowPaint);
            NanoVG.nvgFill((long)vg);
        }
    }

    @Override
    public void fillNVGColorWithRGBA(float r, float g2, float b, float a, NVGColor color) {
        color.r(r);
        color.g(g2);
        color.b(b);
        color.a(a);
    }

    @Override
    public NVGColor color(long vg, int color) {
        NVGColor nvgColor = NVGColor.calloc();
        NanoVG.nvgRGBA((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)), (byte)((byte)(color >> 24 & 0xFF)), (NVGColor)nvgColor);
        NanoVG.nvgFillColor((long)vg, (NVGColor)nvgColor);
        return nvgColor;
    }

    @Override
    public void scale(long vg, float x, float y) {
        NanoVG.nvgScale((long)vg, (float)x, (float)y);
    }

    @Override
    public void translate(long vg, float x, float y) {
        NanoVG.nvgTranslate((long)vg, (float)x, (float)y);
    }

    @Override
    public void rotate(long vg, double angle) {
        NanoVG.nvgRotate((long)vg, (float)((float)Math.toRadians(angle)));
    }

    @Override
    public void resetTransform(long vg) {
        NanoVG.nvgResetTransform((long)vg);
    }

    @Override
    public void setAlpha(long vg, float alpha) {
        if (OneConfigGui.INSTANCE != null && OneConfigGui.INSTANCE.isDrawing() && alpha > OneConfigGui.INSTANCE.transparencyFactor) {
            alpha = OneConfigGui.INSTANCE.transparencyFactor;
        }
        NanoVG.nvgGlobalAlpha((long)vg, (float)alpha);
    }

    @Override
    @Deprecated
    public void drawSvg(long vg, String filePath, float x, float y, float width, float height, float scale) {
        this.drawSvg(vg, filePath, x, y, width, height, scale, IOUtils.class);
    }

    @Override
    public void drawSvg(long vg, String filePath, float x, float y, float width, float height, float scale, Class<?> clazz) {
        AssetHelper assetHelper = AssetHelper.INSTANCE;
        float w = width * scale;
        float h2 = height * scale;
        if (assetHelper.loadSVG(vg, filePath, w, h2, clazz)) {
            NVGPaint imagePaint = NVGPaint.calloc();
            int image = assetHelper.getSVG(filePath, w, h2);
            NanoVG.nvgBeginPath((long)vg);
            NanoVG.nvgImagePattern((long)vg, (float)x, (float)y, (float)width, (float)height, (float)0.0f, (int)image, (float)1.0f, (NVGPaint)imagePaint);
            NanoVG.nvgRect((long)vg, (float)x, (float)y, (float)width, (float)height);
            NanoVG.nvgFillPaint((long)vg, (NVGPaint)imagePaint);
            NanoVG.nvgFill((long)vg);
            imagePaint.free();
        }
    }

    @Override
    @Deprecated
    public void drawSvg(long vg, String filePath, float x, float y, float width, float height) {
        this.drawSvg(vg, filePath, x, y, width, height, IOUtils.class);
    }

    @Override
    public void drawSvg(long vg, String filePath, float x, float y, float width, float height, Class<?> clazz) {
        if (OneConfigGui.isOpen()) {
            this.drawSvg(vg, filePath, x, y, width, height, OneConfigGui.getScaleFactor(), clazz);
        } else {
            this.drawSvg(vg, filePath, x, y, width, height, 1.0f, clazz);
        }
    }

    @Override
    public void drawSvg(long vg, String filePath, float x, float y, float width, float height, int color, float scale) {
        this.drawSvg(vg, filePath, x, y, width, height, color, scale, IOUtils.class);
    }

    @Override
    public void drawSvg(long vg, String filePath, float x, float y, float width, float height, int color, float scale, Class<?> clazz) {
        AssetHelper assetHelper = AssetHelper.INSTANCE;
        float w = width * scale;
        float h2 = height * scale;
        if (assetHelper.loadSVG(vg, filePath, w, h2, clazz)) {
            NVGPaint imagePaint = NVGPaint.calloc();
            int image = assetHelper.getSVG(filePath, w, h2);
            NanoVG.nvgBeginPath((long)vg);
            NanoVG.nvgImagePattern((long)vg, (float)x, (float)y, (float)width, (float)height, (float)0.0f, (int)image, (float)1.0f, (NVGPaint)imagePaint);
            this.drawImageCommon(vg, x, y, width, height, color, imagePaint);
            imagePaint.free();
        }
    }

    @Override
    public void drawSvg(long vg, String filePath, float x, float y, float width, float height, int color) {
        this.drawSvg(vg, filePath, x, y, width, height, color, IOUtils.class);
    }

    @Override
    public void drawSvg(long vg, String filePath, float x, float y, float width, float height, int color, Class<?> clazz) {
        if (OneConfigGui.isOpen()) {
            this.drawSvg(vg, filePath, x, y, width, height, color, OneConfigGui.getScaleFactor(), clazz);
        } else {
            this.drawSvg(vg, filePath, x, y, width, height, color, 1.0f, clazz);
        }
    }

    @Override
    public void drawSvg(long vg, SVG svg, float x, float y, float width, float height, float scale) {
        this.drawSvg(vg, svg.filePath, x, y, width, height, scale, svg.getClass());
    }

    @Override
    public void drawSvg(long vg, SVG svg, float x, float y, float width, float height) {
        this.drawSvg(vg, svg.filePath, x, y, width, height, svg.getClass());
    }

    @Override
    public void drawSvg(long vg, SVG svg, float x, float y, float width, float height, int color, float scale) {
        this.drawSvg(vg, svg.filePath, x, y, width, height, color, scale, svg.getClass());
    }

    @Override
    public void drawSvg(long vg, SVG svg, float x, float y, float width, float height, int color) {
        if (OneConfigGui.isOpen()) {
            this.drawSvg(vg, svg, x, y, width, height, color, OneConfigGui.getScaleFactor());
        } else {
            this.drawSvg(vg, svg, x, y, width, height, color, 1.0f);
        }
    }

    @Override
    public void drawInfo(long vg, InfoType type2, float x, float y, float size) {
        SVG icon = null;
        int colorOuter = 0;
        int colorInner = 0;
        switch (type2) {
            case INFO: {
                icon = SVGs.INFO_CIRCLE;
                colorOuter = Colors.GRAY_400;
                colorInner = Colors.GRAY_300;
                break;
            }
            case SUCCESS: {
                icon = SVGs.CHECK_CIRCLE;
                colorOuter = Colors.SUCCESS_700;
                colorInner = Colors.SUCCESS_600;
                break;
            }
            case WARNING: {
                icon = SVGs.WARNING;
                colorOuter = Colors.WARNING_600;
                colorInner = Colors.WARNING_500;
                break;
            }
            case ERROR: {
                icon = SVGs.ERROR;
                colorOuter = Colors.ERROR_700;
                colorInner = Colors.ERROR_600;
            }
        }
        float centerX = x + size / 2.0f;
        float centerY = y + size / 2.0f;
        this.drawCircle(vg, centerX, centerY, size / 2.0f, colorOuter);
        this.drawCircle(vg, centerX, centerY, size / 2.0f - size / 12.0f, colorInner);
        float iconSize = size / 1.75f;
        this.drawSvg(vg, icon, centerX - iconSize / 2.0f, centerY - iconSize / 2.0f, iconSize, iconSize);
    }

    @Override
    public int[] readPixels(int x, int y, int width, int height) {
        readingPixels = new int[]{x, y, width, height};
        int[] colors = readColors;
        readColors = new int[]{0};
        return colors;
    }

    @Override
    public boolean isDrawing() {
        return this.drawing;
    }

    @Override
    @Deprecated
    public int drawBorderedText(String text, float x, float y, int color, int opacity) {
        return TextRenderer.drawBorderedText(text, x, y, color, opacity);
    }

    @Override
    @Deprecated
    public void drawScaledString(String text, float x, float y, int color, NanoVGHelper.TextType type2, float scale) {
        TextRenderer.drawScaledString(text, x, y, color, TextRenderer.TextType.toType(type2.ordinal()), scale);
    }
}

