/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.renderer;

import cc.polyfrost.oneconfig.libs.deencapsulation.Deencapsulation;
import cc.polyfrost.oneconfig.renderer.LwjglManager;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.TinyFD;
import cc.polyfrost.oneconfig.renderer.asset.AssetHelper;
import cc.polyfrost.oneconfig.renderer.font.FontHelper;
import cc.polyfrost.oneconfig.renderer.scissor.ScissorHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class LwjglManagerImpl
extends URLClassLoader
implements LwjglManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"OneConfig LWJGL Manager");
    private static final boolean isPojav = LwjglManagerImpl.checkPojav();
    private static final Object unsafeInstance;
    private static final Method defineClassMethod;
    private static final Map<String, String> remappingMap;
    private static final String LWJGL_FUNCTION_PROVIDER = "cc.polyfrost.oneconfig.internal.plugin.hooks.Lwjgl2FunctionProvider";
    private final Set<String> classLoaderInclude = new CopyOnWriteArraySet<String>();
    private final Map<String, Class<?>> classCache = new HashMap();
    private static final String JAR_NAME = "oneconfig-lwjgl3.jar";
    private static final URL jarFile;
    private final AssetHelper assetHelper;
    private final NanoVGHelper nanoVGHelper;
    private final ScissorHelper scissorHelper;
    private final FontHelper fontHelper;
    private final TinyFD tinyFD;

    public LwjglManagerImpl() throws ReflectiveOperationException {
        super(new URL[]{jarFile}, LwjglManager.class.getClassLoader());
        LwjglManagerImpl classLoader;
        ClassLoader classLoader2 = classLoader = isPojav ? this.getClass().getClassLoader() : this;
        if (!isPojav) {
            this.classLoaderInclude.add("cc.polyfrost.oneconfig.internal.renderer.FontHelperImpl");
            this.classLoaderInclude.add("cc.polyfrost.oneconfig.internal.renderer.ScissorHelperImpl");
            this.classLoaderInclude.add("cc.polyfrost.oneconfig.internal.renderer.NanoVGHelperImpl");
            this.classLoaderInclude.add("cc.polyfrost.oneconfig.internal.renderer.AssetHelperImpl");
            this.classLoaderInclude.add("cc.polyfrost.oneconfig.internal.renderer.TinyFDImpl");
            this.classLoaderInclude.add(LWJGL_FUNCTION_PROVIDER);
            Arrays.asList("nanovg", "actually3", "stb", "util.tinyfd", "system").forEach(it -> this.classLoaderInclude.add("org.lwjgl." + it + "."));
            this.classLoaderInclude.add("org.lwjgl.Version");
            String libraryPath = System.getProperty("org.lwjgl.librarypath", "");
            if (!libraryPath.isEmpty()) {
                System.setProperty("oneconfig.lwjgl2.librarypath", libraryPath);
            }
            Class<?> configClass = Class.forName("org.lwjgl.system.Configuration", true, classLoader);
            Method setMethod = configClass.getMethod("set", Object.class);
            Object extractDirField = configClass.getField("SHARED_LIBRARY_EXTRACT_DIRECTORY").get(null);
            setMethod.invoke(extractDirField, new File("./OneConfig/temp").getAbsolutePath());
            Object debugStreamField = configClass.getField("DEBUG_STREAM").get(null);
            setMethod.invoke(debugStreamField, System.err);
        }
        try {
            this.nanoVGHelper = (NanoVGHelper)Class.forName("cc.polyfrost.oneconfig.internal.renderer.NanoVGHelperImpl", true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.scissorHelper = (ScissorHelper)Class.forName("cc.polyfrost.oneconfig.internal.renderer.ScissorHelperImpl", true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.assetHelper = (AssetHelper)Class.forName("cc.polyfrost.oneconfig.internal.renderer.AssetHelperImpl", true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.fontHelper = (FontHelper)Class.forName("cc.polyfrost.oneconfig.internal.renderer.FontHelperImpl", true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.tinyFD = (TinyFD)Class.forName("cc.polyfrost.oneconfig.internal.renderer.TinyFDImpl", true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException exception) {
            exception.printStackTrace();
            throw new RuntimeException("fuck", exception);
        }
    }

    private boolean canBeSharedWithMc(String name) {
        for (String implClass : this.classLoaderInclude) {
            if (!name.startsWith(implClass)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve2) throws ClassNotFoundException {
        if (!this.canBeSharedWithMc(name) && !isPojav) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> cls = this.findLoadedClass(name);
                if (cls == null) {
                    cls = this.findClass(name);
                }
                if (resolve2) {
                    this.resolveClass(cls);
                }
                return cls;
            }
        }
        return this.getParent().loadClass(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String unmappedName;
        if (isPojav) {
            return this.getParent().loadClass(name);
        }
        String remappedName = remappingMap.getOrDefault(name.replace('.', '/'), name).replace('/', '.');
        if (!remappedName.equals(unmappedName = remappingMap.keySet().stream().filter(it -> remappingMap.get(it).equalsIgnoreCase(remappedName.replace('.', '/'))).findFirst().orElse(name).replace('/', '.')) && name.equals(unmappedName)) {
            return this.getParent().loadClass(name);
        }
        if (this.classCache.containsKey(name)) {
            return this.classCache.get(name);
        }
        if (this.canBeSharedWithMc(remappedName)) {
            return this.getParent().loadClass(remappedName);
        }
        try {
            String path = unmappedName.replace('.', '/').concat(".class");
            URL classUrl = null;
            Enumeration<URL> urls = this.getResources(path);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (!url.toString().contains(JAR_NAME)) continue;
                classUrl = url;
                break;
            }
            if (classUrl == null && (classUrl = this.getParent().getResource(path)) == null) {
                throw new ClassNotFoundException(name);
            }
            byte[] classBuffer = IOUtils.toByteArray(classUrl);
            Class<?> clazz = this.defineClassBypass(unmappedName, classBuffer);
            this.classCache.put(remappedName, clazz);
            return clazz;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(name);
        }
    }

    private Class<?> defineClassBypass(String name, byte[] b) {
        name = remappingMap.getOrDefault(name.replace('.', '/'), name).replace('/', '.');
        ClassReader classReader = new ClassReader(b);
        Remapper remapper = new Remapper(){

            public String map(String desc) {
                if (remappingMap.containsKey(desc)) {
                    return (String)remappingMap.get(desc);
                }
                return desc;
            }
        };
        ClassWriter classWriter = new ClassWriter(classReader, 1);
        RemappingClassAdapter classRemapper = new RemappingClassAdapter((ClassVisitor)classWriter, remapper);
        classReader.accept((ClassVisitor)classRemapper, 8);
        b = classWriter.toByteArray();
        if (name.equalsIgnoreCase("org.lwjgl.nanovg.NanoVGGLConfig")) {
            ClassNode node = new ClassNode();
            classReader = new ClassReader(b);
            classReader.accept((ClassVisitor)node, 8);
            this.transform(node);
            classWriter = new ClassWriter(classReader, 1);
            node.accept((ClassVisitor)classWriter);
            b = classWriter.toByteArray();
        }
        try {
            return (Class)defineClassMethod.invoke(unsafeInstance, name, b, 0, b.length, this, null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("whoops...", e);
        }
    }

    private void transform(ClassNode node) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("configGL")) continue;
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(22, 0));
            list.add((AbstractInsnNode)new TypeInsnNode(187, "cc/polyfrost/oneconfig/internal/plugin/hooks/Lwjgl2FunctionProvider"));
            list.add((AbstractInsnNode)new InsnNode(89));
            list.add((AbstractInsnNode)new MethodInsnNode(183, "cc/polyfrost/oneconfig/internal/plugin/hooks/Lwjgl2FunctionProvider", "<init>", "()V", false));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "org/lwjgl/nanovg/NanoVGGLConfig", "config", "(JLorg/lwjgl/system/FunctionProvider;)V", false));
            list.add((AbstractInsnNode)new InsnNode(177));
            method.instructions.clear();
            method.instructions.insert(list);
        }
    }

    private static synchronized URL getJarFile() {
        if (isPojav) {
            return null;
        }
        File tempJar = new File("./OneConfig/temp/oneconfig-lwjgl3.jar");
        tempJar.mkdirs();
        try {
            tempJar.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        tempJar.deleteOnExit();
        String jarName = "lwjgl-legacy";
        try (InputStream in = LwjglManagerImpl.class.getResourceAsStream("/" + jarName + ".jar");){
            assert (in != null);
            Files.copy(in, tempJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            return tempJar.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean checkPojav() {
        try {
            Class.forName("org.lwjgl.glfw.CallbackBridge");
            LOGGER.warn("Pojav detected, letting Pojav handle LWJGL.");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public NanoVGHelper getNanoVGHelper() {
        return this.nanoVGHelper;
    }

    @Override
    public ScissorHelper getScissorHelper() {
        return this.scissorHelper;
    }

    @Override
    public AssetHelper getAssetHelper() {
        return this.assetHelper;
    }

    @Override
    public FontHelper getFontHelper() {
        return this.fontHelper;
    }

    @Override
    public TinyFD getTinyFD() {
        return this.tinyFD;
    }

    static {
        jarFile = LwjglManagerImpl.getJarFile();
        LwjglManagerImpl.registerAsParallelCapable();
        if (!isPojav) {
            Class<?> unsafeClass;
            remappingMap = new HashMap<String, String>();
            remappingMap.put("org/lwjgl/BufferUtils", "org/lwjgl/actually3/BufferUtils");
            remappingMap.put("org/lwjgl/PointerBuffer", "org/lwjgl/actually3/PointerBuffer");
            remappingMap.put("org/lwjgl/CLongBuffer", "org/lwjgl/actually3/CLongBuffer");
            try {
                unsafeClass = Class.forName("jdk.internal.misc.Unsafe");
            }
            catch (Throwable throwable) {
                try {
                    unsafeClass = Class.forName("sun.misc.Unsafe");
                }
                catch (Throwable throwable1) {
                    throw new RuntimeException("Could not find Unsafe class", throwable);
                }
            }
            try {
                try {
                    Deencapsulation.deencapsulate(Object.class);
                    Deencapsulation.deencapsulate(unsafeClass);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                unsafeInstance = unsafeField.get(null);
                defineClassMethod = unsafeClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                defineClassMethod.setAccessible(true);
            }
            catch (ReflectiveOperationException exception) {
                throw new RuntimeException("Error while fetching Unsafe instance.", exception);
            }
        }
        remappingMap = null;
        unsafeInstance = null;
        defineClassMethod = null;
    }
}

