/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.renderer;

import cc.polyfrost.oneconfig.renderer.font.Font;
import cc.polyfrost.oneconfig.renderer.font.FontHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.IOUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.lwjgl.nanovg.NanoVG;

public class FontHelperImpl
implements FontHelper {
    @Override
    public void initialize(long vg) {
        for (Field field : Fonts.class.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object font = field.get(null);
                if (!(font instanceof Font)) continue;
                this.loadFont(vg, (Font)font);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize fonts");
            }
        }
    }

    @Override
    public void loadFont(long vg, Font font) {
        if (font.isLoaded()) {
            return;
        }
        int loaded = -1;
        try {
            ByteBuffer buffer = IOUtils.resourceToByteBuffer(font.getFileName(), font.getClass());
            loaded = NanoVG.nvgCreateFontMem((long)vg, (CharSequence)font.getName(), (ByteBuffer)buffer, (int)0);
            font.setBuffer(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (loaded == -1) {
            throw new RuntimeException("Failed to initialize font " + font.getName());
        }
        font.setLoaded(true);
    }
}

