/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.renderer;

import cc.polyfrost.oneconfig.renderer.asset.AssetHelper;
import cc.polyfrost.oneconfig.renderer.asset.Image;
import cc.polyfrost.oneconfig.renderer.asset.NVGAsset;
import cc.polyfrost.oneconfig.renderer.asset.SVG;
import cc.polyfrost.oneconfig.utils.IOUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.nanovg.NSVGImage;
import org.lwjgl.nanovg.NanoSVG;
import org.lwjgl.nanovg.NanoVG;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryUtil;

public final class AssetHelperImpl
implements AssetHelper {
    public static final int DEFAULT_FLAGS = 7;
    private final Map<String, NVGAsset> imageHashMap = new HashMap<String, NVGAsset>();
    private final Map<String, NVGAsset> svgHashMap = new HashMap<String, NVGAsset>();

    @Override
    public boolean loadImage(long vg, String fileName, int flags, Class<?> clazz) {
        if (!this.imageHashMap.containsKey(fileName)) {
            int[] width = new int[]{0};
            int[] height = new int[]{0};
            int[] channels = new int[]{0};
            ByteBuffer image = IOUtils.resourceToByteBufferNullable(fileName, clazz);
            if (image == null) {
                return false;
            }
            ByteBuffer buffer = STBImage.stbi_load_from_memory((ByteBuffer)image, (int[])width, (int[])height, (int[])channels, (int)4);
            if (buffer == null) {
                return false;
            }
            this.imageHashMap.put(fileName, new NVGAsset(NanoVG.nvgCreateImageRGBA((long)vg, (int)width[0], (int)height[0], (int)flags, (ByteBuffer)buffer), width[0], height[0]));
            return true;
        }
        return true;
    }

    @Override
    public boolean loadImage(long vg, Image image) {
        return this.loadImage(vg, image.filePath, image.flags, image.getClass());
    }

    @Override
    public boolean loadImage(long vg, Image image, Class<?> clazz) {
        return this.loadImage(vg, image.filePath, image.flags, clazz);
    }

    @Override
    public boolean loadImage(long vg, String fileName, Class<?> clazz) {
        return this.loadImage(vg, fileName, 7, clazz);
    }

    @Override
    public boolean loadSVG(long vg, String fileName, float width, float height, int flags, Class<?> clazz) {
        String name = fileName + "-" + width + "-" + height;
        if (!this.svgHashMap.containsKey(name)) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(fileName);
                if (inputStream == null) {
                    return false;
                }
                StringBuilder resultStringBuilder = new StringBuilder();
                try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        resultStringBuilder.append(line);
                    }
                }
                String s2 = resultStringBuilder.toString();
                NSVGImage svg = NanoSVG.nsvgParse((CharSequence)s2, (CharSequence)"px", (float)96.0f);
                if (svg == null) {
                    return false;
                }
                long rasterizer = NanoSVG.nsvgCreateRasterizer();
                int w = (int)svg.width();
                int h2 = (int)svg.height();
                float scale = Math.max(width / (float)w, height / (float)h2);
                w = (int)((float)w * scale);
                h2 = (int)((float)h2 * scale);
                ByteBuffer image = MemoryUtil.memAlloc((int)(w * h2 * 4));
                NanoSVG.nsvgRasterize((long)rasterizer, (NSVGImage)svg, (float)0.0f, (float)0.0f, (float)scale, (ByteBuffer)image, (int)w, (int)h2, (int)(w * 4));
                NanoSVG.nsvgDeleteRasterizer((long)rasterizer);
                NanoSVG.nsvgDelete((NSVGImage)svg);
                this.svgHashMap.put(name, new NVGAsset(NanoVG.nvgCreateImageRGBA((long)vg, (int)w, (int)h2, (int)flags, (ByteBuffer)image), w, h2));
                return true;
            }
            catch (Exception e) {
                System.err.println("Failed to parse SVG file");
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean loadSVG(long vg, SVG svg, float width, float height) {
        return this.loadSVG(vg, svg.filePath, width, height, svg.flags, svg.getClass());
    }

    @Override
    public boolean loadSVG(long vg, SVG svg, float width, float height, Class<?> clazz) {
        return this.loadSVG(vg, svg.filePath, width, height, svg.flags, clazz);
    }

    @Override
    public boolean loadSVG(long vg, String fileName, float width, float height, Class<?> clazz) {
        return this.loadSVG(vg, fileName, width, height, 7, clazz);
    }

    @Override
    public int getImage(String fileName) {
        return this.imageHashMap.get(fileName).getImage();
    }

    @Override
    public NVGAsset getNVGImage(String fileName) {
        return this.imageHashMap.get(fileName);
    }

    @Override
    public void removeImage(long vg, String fileName) {
        NanoVG.nvgDeleteImage((long)vg, (int)this.imageHashMap.get(fileName).getImage());
        this.imageHashMap.remove(fileName);
    }

    @Override
    public void clearImages(long vg) {
        HashMap<String, NVGAsset> temp = new HashMap<String, NVGAsset>(this.imageHashMap);
        for (String image : temp.keySet()) {
            NanoVG.nvgDeleteImage((long)vg, (int)this.imageHashMap.get(image).getImage());
            this.imageHashMap.remove(image);
        }
    }

    @Override
    public int getSVG(String fileName, float width, float height) {
        String name = fileName + "-" + width + "-" + height;
        return this.svgHashMap.get(name).getImage();
    }

    @Override
    public NVGAsset getNVGSVG(String fileName) {
        return this.svgHashMap.get(fileName);
    }

    @Override
    public void removeSVG(long vg, String fileName, float width, float height) {
        String name = fileName + "-" + width + "-" + height;
        NanoVG.nvgDeleteImage((long)vg, (int)this.imageHashMap.get(name).getImage());
        this.svgHashMap.remove(name);
    }

    @Override
    public void clearSVGs(long vg) {
        HashMap<String, NVGAsset> temp = new HashMap<String, NVGAsset>(this.svgHashMap);
        for (String image : temp.keySet()) {
            NanoVG.nvgDeleteImage((long)vg, (int)this.svgHashMap.get(image).getImage());
            this.svgHashMap.remove(image);
        }
    }
}

