/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.plugin.asm;

import cc.polyfrost.oneconfig.internal.init.OneConfigInit;
import cc.polyfrost.oneconfig.internal.plugin.asm.ClassTransformer;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.CoreModManager;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Mixins;

public class OneConfigTweaker
implements ITweaker {
    private static final String MIXIN_TWEAKER = "org.spongepowered.asm.launch.MixinTweaker";

    public OneConfigTweaker() {
        try {
            this.injectMixinTweaker();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        List<SourceFile> sourceFiles = this.getSourceFiles();
        if (sourceFiles.isEmpty()) {
            System.out.println("Not able to determine current file. Mod will NOT work");
            return;
        }
        for (SourceFile sourceFile : sourceFiles) {
            try {
                this.setupSourceFile(sourceFile);
            }
            catch (Throwable t3) {
                t3.printStackTrace();
            }
        }
        MixinEnvironment.getDefaultEnvironment().addTransformerExclusion("com.creativemd.itemphysic.ItemTransformer");
    }

    private void setupSourceFile(SourceFile sourceFile) throws Exception {
        Field ignoredModFile = CoreModManager.class.getDeclaredField("ignoredModFiles");
        ignoredModFile.setAccessible(true);
        ((List)ignoredModFile.get(null)).remove(sourceFile.file.getName());
        CoreModManager.getReparseableCoremods().add(sourceFile.file.getName());
        String coreMod = sourceFile.coreMod;
        if (coreMod != null && !sourceFile.mixin) {
            Method loadCoreMod = CoreModManager.class.getDeclaredMethod("loadCoreMod", LaunchClassLoader.class, String.class, File.class);
            loadCoreMod.setAccessible(true);
            ITweaker tweaker = (ITweaker)loadCoreMod.invoke(null, Launch.classLoader, coreMod, sourceFile.file);
            ((List)Launch.blackboard.get("Tweaks")).add(tweaker);
        }
        if (sourceFile.mixin) {
            try {
                URI arg;
                Method addContainer;
                this.injectMixinTweaker();
                Class<?> MixinBootstrap2 = Class.forName("org.spongepowered.asm.launch.MixinBootstrap");
                Class<?> MixinPlatformManager2 = Class.forName("org.spongepowered.asm.launch.platform.MixinPlatformManager");
                Object platformManager = MixinBootstrap2.getDeclaredMethod("getPlatform", new Class[0]).invoke(null, new Object[0]);
                try {
                    addContainer = MixinPlatformManager2.getDeclaredMethod("addContainer", URI.class);
                    arg = sourceFile.file.toURI();
                }
                catch (NoSuchMethodException ignored) {
                    Class<?> IContainerHandle = Class.forName("org.spongepowered.asm.launch.platform.container.IContainerHandle");
                    Class<?> ContainerHandleURI = Class.forName("org.spongepowered.asm.launch.platform.container.ContainerHandleURI");
                    addContainer = MixinPlatformManager2.getDeclaredMethod("addContainer", IContainerHandle);
                    arg = ContainerHandleURI.getDeclaredConstructor(URI.class).newInstance(sourceFile.file.toURI());
                }
                addContainer.invoke(platformManager, arg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private List<SourceFile> getSourceFiles() {
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        for (URL url : Launch.classLoader.getSources()) {
            try {
                File file;
                URI uri = url.toURI();
                if (!"file".equals(uri.getScheme()) || !(file = new File(uri)).exists() || !file.isFile()) continue;
                String tweakClass = null;
                String coreMod = null;
                boolean mixin = false;
                try (JarFile jar = new JarFile(file);){
                    if (jar.getManifest() != null) {
                        Attributes attributes = jar.getManifest().getMainAttributes();
                        tweakClass = attributes.getValue("TweakClass");
                        coreMod = attributes.getValue("FMLCorePlugin");
                        mixin = attributes.getValue("MixinConfigs") != null;
                    }
                }
                if (!Objects.equals(tweakClass, "cc.polyfrost.oneconfigwrapper.OneConfigWrapper") && !Objects.equals(tweakClass, "cc.polyfrost.oneconfig.loader.stage0.LaunchWrapperTweaker")) continue;
                sourceFiles.add(new SourceFile(file, coreMod, mixin));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sourceFiles;
    }

    private void injectMixinTweaker() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        List tweakClasses = (List)Launch.blackboard.get("TweakClasses");
        if (tweakClasses.contains(MIXIN_TWEAKER)) {
            this.initMixinTweaker();
            return;
        }
        if (Launch.blackboard.get("mixin.initialised") != null) {
            return;
        }
        System.out.println("Injecting MixinTweaker from EssentialSetupTweaker");
        List tweaks = (List)Launch.blackboard.get("Tweaks");
        tweaks.add(this.initMixinTweaker());
    }

    private ITweaker initMixinTweaker() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Launch.classLoader.addClassLoaderExclusion(MIXIN_TWEAKER.substring(0, MIXIN_TWEAKER.lastIndexOf(46)));
        return (ITweaker)Class.forName(MIXIN_TWEAKER, true, (ClassLoader)Launch.classLoader).newInstance();
    }

    public void acceptOptions(List<String> args2, File gameDir, File assetsDir, String profile) {
        boolean captureNext = false;
        for (String arg : args2) {
            if (captureNext) {
                Mixins.addConfiguration(arg);
            }
            captureNext = "--mixin".equals(arg);
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        MixinBootstrap.init();
        Mixins.addConfiguration("mixins.oneconfig.json");
        this.removeLWJGLException();
        Launch.classLoader.registerTransformer(ClassTransformer.class.getName());
        OneConfigInit.initialize(new String[0]);
        Launch.blackboard.put("oneconfig.init.initialized", true);
        Launch.classLoader.addClassLoaderExclusion("cc.polyfrost.oneconfig.internal.plugin.asm.");
    }

    private void removeLWJGLException() {
        try {
            Field f_exceptions = LaunchClassLoader.class.getDeclaredField("classLoaderExceptions");
            f_exceptions.setAccessible(true);
            Set exceptions = (Set)f_exceptions.get(Launch.classLoader);
            exceptions.remove("org.lwjgl.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getLaunchTarget() {
        return null;
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }

    private static class SourceFile {
        final File file;
        final String coreMod;
        final boolean mixin;

        private SourceFile(File file, String coreMod, boolean mixin) {
            this.file = file;
            this.coreMod = coreMod;
            this.mixin = mixin;
        }
    }
}

