/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.plugin.asm;

import cc.polyfrost.oneconfig.internal.plugin.asm.ITransformer;
import cc.polyfrost.oneconfig.internal.plugin.asm.tweakers.VigilantTransformer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassTransformer
implements IClassTransformer {
    private static final Logger logger = LogManager.getLogger((String)"OneConfig ASM");
    private final Multimap<String, ITransformer> transformerMap = ArrayListMultimap.create();
    private static final boolean outputBytecode = Boolean.parseBoolean(System.getProperty("debugBytecode", "false"));

    public ClassTransformer() {
        this.registerTransformer(new VigilantTransformer());
    }

    private void registerTransformer(ITransformer transformer) {
        for (String cls : transformer.getClassName()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Collection transformers = this.transformerMap.get((Object)transformedName);
        if (transformers.isEmpty()) {
            return bytes;
        }
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 8);
        for (ITransformer transformer : transformers) {
            transformer.transform(transformedName, node);
        }
        ClassWriter cw = new ClassWriter(2);
        try {
            node.accept((ClassVisitor)cw);
        }
        catch (Throwable t2) {
            logger.error("Exception when transforming " + transformedName + " : " + t2.getClass().getSimpleName());
            t2.printStackTrace();
        }
        if (outputBytecode) {
            File bytecodeDirectory = new File("bytecode");
            String transformedClassName = transformedName.contains("$") ? transformedName.replace('$', '.') + ".class" : transformedName + ".class";
            if (!bytecodeDirectory.exists()) {
                bytecodeDirectory.mkdirs();
            }
            File bytecodeOutput = new File(bytecodeDirectory, transformedClassName);
            try {
                if (!bytecodeOutput.exists()) {
                    bytecodeOutput.createNewFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try (FileOutputStream os = new FileOutputStream(bytecodeOutput);){
                os.write(cw.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return cw.toByteArray();
    }
}

