/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.mixin;

import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.events.event.FramebufferRenderEvent;
import cc.polyfrost.oneconfig.events.event.InitializationEvent;
import cc.polyfrost.oneconfig.events.event.KeyInputEvent;
import cc.polyfrost.oneconfig.events.event.MouseInputEvent;
import cc.polyfrost.oneconfig.events.event.PreShutdownEvent;
import cc.polyfrost.oneconfig.events.event.RawKeyEvent;
import cc.polyfrost.oneconfig.events.event.RawMouseEvent;
import cc.polyfrost.oneconfig.events.event.RenderEvent;
import cc.polyfrost.oneconfig.events.event.ScreenOpenEvent;
import cc.polyfrost.oneconfig.events.event.ShutdownEvent;
import cc.polyfrost.oneconfig.events.event.Stage;
import cc.polyfrost.oneconfig.events.event.StartEvent;
import cc.polyfrost.oneconfig.events.event.TickEvent;
import cc.polyfrost.oneconfig.events.event.TimerUpdateEvent;
import cc.polyfrost.oneconfig.internal.OneConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Timer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    private Timer field_71428_T;
    private static final String UPDATE_CAMERA_AND_RENDER = "Lnet/minecraft/client/renderer/EntityRenderer;updateCameraAndRender(FJ)V";

    @Inject(method={"shutdownMinecraftApplet"}, at={@At(value="HEAD")})
    private void onShutdown(CallbackInfo ci) {
        EventManager.INSTANCE.post(new PreShutdownEvent());
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void onStart(CallbackInfo ci) {
        EventManager.INSTANCE.post(new StartEvent());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> EventManager.INSTANCE.post(new ShutdownEvent())));
    }

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/fml/client/FMLClientHandler;onInitializationComplete()V", shift=At.Shift.AFTER, remap=false)}, remap=true)
    private void onInit(CallbackInfo ci) {
        OneConfig.INSTANCE.init();
        EventManager.INSTANCE.post(new InitializationEvent());
    }

    @Inject(method={"runGameLoop"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/EntityRenderer;updateCameraAndRender(FJ)V")})
    private void onRenderTickStart(CallbackInfo ci) {
        EventManager.INSTANCE.post(new RenderEvent(Stage.START, this.field_71428_T.field_194147_b));
    }

    @Inject(method={"runGameLoop"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/EntityRenderer;updateCameraAndRender(FJ)V", shift=At.Shift.AFTER)})
    private void onRenderTickEnd(CallbackInfo ci) {
        EventManager.INSTANCE.post(new RenderEvent(Stage.END, this.field_71428_T.field_194147_b));
    }

    @Inject(method={"runGameLoop"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/shader/Framebuffer;framebufferRender(II)V")})
    private void onFramebufferStart(CallbackInfo ci) {
        EventManager.INSTANCE.post(new FramebufferRenderEvent(Stage.START));
    }

    @Inject(method={"runGameLoop"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/shader/Framebuffer;framebufferRender(II)V", shift=At.Shift.AFTER)})
    private void onFramebufferEnd(CallbackInfo ci) {
        EventManager.INSTANCE.post(new FramebufferRenderEvent(Stage.END));
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/profiler/Profiler;startSection(Ljava/lang/String;)V", ordinal=0)})
    private void onClientTickStart(CallbackInfo ci) {
        EventManager.INSTANCE.post(new TickEvent(Stage.START));
    }

    @Inject(method={"runTick"}, at={@At(value="TAIL")})
    private void onClientTickEnd(CallbackInfo ci) {
        EventManager.INSTANCE.post(new TickEvent(Stage.END));
    }

    @ModifyArg(method={"displayGuiScreen"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/eventhandler/EventBus;post(Lnet/minecraftforge/fml/common/eventhandler/Event;)Z", remap=false), remap=true)
    private Event onGuiOpenEvent(Event a) {
        if (a instanceof GuiOpenEvent) {
            GuiOpenEvent forgeEvent = (GuiOpenEvent)a;
            ScreenOpenEvent event = new ScreenOpenEvent(forgeEvent.getGui());
            EventManager.INSTANCE.post(event);
            if (event.isCancelled) {
                forgeEvent.setCanceled(true);
            }
            return forgeEvent;
        }
        return a;
    }

    @Inject(method={"runGameLoop"}, at={@At(value="FIELD", target="Lnet/minecraft/util/Timer;renderPartialTicks:F", opcode=181, shift=At.Shift.AFTER)})
    private void onNonDeltaTickTimerUpdate(CallbackInfo ci) {
        EventManager.INSTANCE.post(new TimerUpdateEvent(this.field_71428_T, false));
    }

    @Inject(method={"runGameLoop"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Timer;updateTimer()V")})
    private void onDeltaTickTimerUpdate(CallbackInfo ci) {
        EventManager.INSTANCE.post(new TimerUpdateEvent(this.field_71428_T, true));
    }

    @Inject(method={"runTickKeyboard"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;debugCrashKeyPressTime:J", opcode=181)})
    private void onKeyEvent(CallbackInfo ci) {
        int state = 0;
        if (Keyboard.getEventKeyState()) {
            state = Keyboard.isRepeatEvent() ? 2 : 1;
        }
        EventManager.INSTANCE.post(new RawKeyEvent(Keyboard.getEventKey(), state));
    }

    @Inject(method={"runTickKeyboard"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/FMLCommonHandler;fireKeyInput()V", remap=false)}, remap=true)
    private void onKeyInputEvent(CallbackInfo ci) {
        EventManager.INSTANCE.post(new KeyInputEvent());
    }

    @Inject(method={"runTickMouse"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/client/ForgeHooksClient;postMouseEvent()Z", remap=false)}, remap=true)
    private void onMouseEvent(CallbackInfo ci) {
        EventManager.INSTANCE.post(new RawMouseEvent(Mouse.getEventButton(), Mouse.getEventButtonState() ? 1 : 0));
    }

    @Inject(method={"runTickMouse"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/FMLCommonHandler;fireMouseInput()V", remap=false)}, remap=true)
    private void onMouseInputEvent(CallbackInfo ci) {
        EventManager.INSTANCE.post(new MouseInputEvent(Mouse.getEventButton()));
    }
}

