/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.hud;

import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.events.event.HudRenderEvent;
import cc.polyfrost.oneconfig.events.event.InitializationEvent;
import cc.polyfrost.oneconfig.hud.Hud;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.UGraphics;
import cc.polyfrost.oneconfig.platform.Platform;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HudCore {
    public static final ConcurrentHashMap<Map.Entry<Field, Object>, Hud> huds = new ConcurrentHashMap();
    public static final ArrayList<BasicOption> hudOptions = new ArrayList();
    private static boolean isPatcher = false;
    public static boolean editing = false;

    @Subscribe
    public void onRender(HudRenderEvent event) {
        if (editing) {
            return;
        }
        for (Hud hud : huds.values()) {
            if (!hud.isEnabled() || hud.isCachingIgnored()) continue;
            hud.deltaTicks = event.deltaTicks;
            UGraphics.enableAlpha();
            UGraphics.enableBlend();
            hud.drawAll(event.matrices, false);
        }
    }

    @Subscribe
    public void onInit(InitializationEvent event) {
        isPatcher = Platform.getLoaderPlatform().isModLoaded("patcher");
    }

    public static void reInitHuds() {
        for (Map.Entry field : huds.keySet()) {
            if (field == null || field.getKey() == null || field.getValue() == null) continue;
            try {
                ((Field)field.getKey()).setAccessible(true);
                Hud oldHud = huds.get(field);
                Hud newHud = (Hud)((Field)field.getKey()).get(field.getValue());
                newHud.setConfig(oldHud.getConfig());
                for (BasicOption option : hudOptions) {
                    if (!option.getParent().equals(oldHud)) continue;
                    option.setParent(newHud);
                }
                huds.put(field, newHud);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static boolean isPatcher() {
        return isPatcher;
    }
}

