/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.gui.impl;

import cc.polyfrost.oneconfig.events.event.RenderEvent;
import cc.polyfrost.oneconfig.events.event.ScreenOpenEvent;
import cc.polyfrost.oneconfig.events.event.Stage;
import cc.polyfrost.oneconfig.internal.gui.BlurHandler;
import cc.polyfrost.oneconfig.internal.mixin.ShaderGroupAccessor;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.UMinecraft;
import cc.polyfrost.oneconfig.libs.universal.UScreen;
import cc.polyfrost.oneconfig.utils.gui.BlurScreen;
import java.util.List;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlurHandlerImpl
implements BlurHandler {
    private final ResourceLocation blurShader = new ResourceLocation("shaders/post/fade_in_blur.json");
    private final Logger logger = LogManager.getLogger((String)"OneConfig - Blur");
    private long start;
    private float progress = 0.0f;

    @Subscribe
    private void onGuiChange(ScreenOpenEvent event) {
        this.reloadBlur(event.screen);
    }

    @Subscribe
    private void onRenderTick(RenderEvent event) {
        if (event.stage != Stage.END) {
            return;
        }
        if (UScreen.getCurrentScreen() == null) {
            return;
        }
        if (!this.isShaderActive()) {
            return;
        }
        if (this.progress >= 5.0f) {
            return;
        }
        this.progress = this.getBlurStrengthProgress();
        try {
            List<Shader> listShaders = ((ShaderGroupAccessor)UMinecraft.getMinecraft().field_71460_t.func_147706_e()).getListShaders();
            if (listShaders == null) {
                return;
            }
            for (Shader shader : listShaders) {
                ShaderUniform su = shader.func_148043_c().func_147991_a("Progress");
                if (su == null) continue;
                su.func_148090_a(this.progress);
            }
        }
        catch (IllegalArgumentException ex) {
            this.logger.error("An error.png occurred while updating OneConfig's blur. Please report this!", (Throwable)ex);
        }
    }

    @Override
    public void reloadBlur(Object gui) {
        if (UMinecraft.getWorld() == null) {
            return;
        }
        if (!this.isShaderActive() && gui instanceof BlurScreen && ((BlurScreen)gui).hasBackgroundBlur()) {
            UMinecraft.getMinecraft().field_71460_t.func_175069_a(this.blurShader);
            this.start = System.currentTimeMillis();
            this.progress = 0.0f;
        } else if (this.isShaderActive() && (gui == null || gui instanceof BlurScreen && ((BlurScreen)gui).hasBackgroundBlur())) {
            String name = UMinecraft.getMinecraft().field_71460_t.func_147706_e().func_148022_b();
            if (!name.endsWith("fade_in_blur.json")) {
                return;
            }
            UMinecraft.getMinecraft().field_71460_t.func_181022_b();
        }
    }

    private float getBlurStrengthProgress() {
        return Math.min((float)(System.currentTimeMillis() - this.start) / 50.0f, 5.0f);
    }

    private boolean isShaderActive() {
        return UMinecraft.getMinecraft().field_71460_t.func_147706_e() != null && OpenGlHelper.field_148824_g;
    }
}

