/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.gui;

import cc.polyfrost.oneconfig.gui.GuiPause;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.hud.Hud;
import cc.polyfrost.oneconfig.hud.Position;
import cc.polyfrost.oneconfig.internal.config.core.ConfigCore;
import cc.polyfrost.oneconfig.internal.hud.HudCore;
import cc.polyfrost.oneconfig.internal.hud.utils.GrabOffset;
import cc.polyfrost.oneconfig.internal.hud.utils.SnappingLine;
import cc.polyfrost.oneconfig.libs.universal.UGraphics;
import cc.polyfrost.oneconfig.libs.universal.UKeyboard;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import cc.polyfrost.oneconfig.libs.universal.UResolution;
import cc.polyfrost.oneconfig.libs.universal.UScreen;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.asset.AssetHelper;
import cc.polyfrost.oneconfig.renderer.asset.NVGAsset;
import cc.polyfrost.oneconfig.utils.MathUtils;
import cc.polyfrost.oneconfig.utils.color.ColorUtils;
import cc.polyfrost.oneconfig.utils.gui.GuiUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HudGui
extends UScreen
implements GuiPause {
    private static final int SNAPPING_DISTANCE = 10;
    private final HashMap<Hud, GrabOffset> editingHuds = new HashMap();
    private boolean isDragging;
    private boolean isSelecting;
    private float selectX;
    private float selectY;
    private boolean isScaling;
    private String superSecretString = "";

    @Override
    public void initScreen(int width, int height) {
        HudCore.editing = true;
        UKeyboard.allowRepeatEvents(true);
        super.initScreen(width, height);
    }

    @Override
    public void onDrawScreen(@NotNull UMatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        int lineWidth = Math.max(1, Math.round(Math.min((float)UResolution.getWindowWidth() / 1920.0f, (float)UResolution.getWindowHeight() / 1080.0f)));
        if (this.isDragging) {
            nanoVGHelper.setupAndDraw(vg -> this.setHudPositions(vg, mouseX, mouseY, true, true, lineWidth));
        } else if (this.isSelecting) {
            this.getHudsInRegion(this.selectX, this.selectY, mouseX, mouseY);
        } else if (this.isScaling && this.editingHuds.size() == 1) {
            nanoVGHelper.setupAndDraw(vg -> {
                Hud hud = (Hud)this.editingHuds.keySet().toArray()[0];
                Position position = hud.position;
                float scaleX = this.getXSnapping(vg, lineWidth, mouseX, position.getWidth(), false);
                hud.setScale(MathUtils.clamp((scaleX - position.getX()) / (position.getWidth() / hud.getScale()), 0.3f, 10.0f), true);
            });
        }
        float scaleFactor = (float)UResolution.getScaleFactor();
        for (Hud hud : HudCore.huds.values()) {
            if (!hud.isEnabled()) continue;
            Position position = hud.position;
            UGraphics.enableAlpha();
            UGraphics.enableBlend();
            hud.drawAll(matrixStack, true);
            if (this.editingHuds.containsKey(hud)) {
                nanoVGHelper.setupAndDraw(true, vg -> nanoVGHelper.drawRect(vg, position.getX(), position.getY(), position.getWidth(), position.getHeight(), ColorUtils.getColor(0, 128, 128, 60)));
            }
            if (hud.isLocked()) {
                nanoVGHelper.setupAndDraw(true, vg -> nanoVGHelper.drawRect(vg, position.getX(), position.getY(), position.getWidth(), position.getHeight(), ColorUtils.getColor(238, 36, 36, 60)));
            }
            nanoVGHelper.setupAndDraw(vg -> {
                nanoVGHelper.drawLine(vg, position.getX() * scaleFactor - (float)lineWidth / 2.0f, position.getY() * scaleFactor - (float)lineWidth / 2.0f, position.getRightX() * scaleFactor + (float)lineWidth / 2.0f, position.getY() * scaleFactor - (float)lineWidth / 2.0f, lineWidth, ColorUtils.getColor(255, 255, 255));
                nanoVGHelper.drawLine(vg, position.getX() * scaleFactor - (float)lineWidth / 2.0f, position.getBottomY() * scaleFactor + (float)lineWidth / 2.0f, position.getRightX() * scaleFactor + (float)lineWidth / 2.0f, position.getBottomY() * scaleFactor + (float)lineWidth / 2.0f, lineWidth, ColorUtils.getColor(255, 255, 255));
                nanoVGHelper.drawLine(vg, position.getX() * scaleFactor - (float)lineWidth / 2.0f, position.getY() * scaleFactor - (float)lineWidth / 2.0f, position.getX() * scaleFactor - (float)lineWidth / 2.0f, position.getBottomY() * scaleFactor + (float)lineWidth / 2.0f, lineWidth, ColorUtils.getColor(255, 255, 255));
                nanoVGHelper.drawLine(vg, position.getRightX() * scaleFactor + (float)lineWidth / 2.0f, position.getY() * scaleFactor - (float)lineWidth / 2.0f, position.getRightX() * scaleFactor + (float)lineWidth / 2.0f, position.getBottomY() * scaleFactor + (float)lineWidth / 2.0f, lineWidth, ColorUtils.getColor(255, 255, 255));
            });
            if (!this.editingHuds.containsKey(hud) || this.editingHuds.size() != 1) continue;
            nanoVGHelper.setupAndDraw(true, vg -> nanoVGHelper.drawRect(vg, position.getRightX() - 4.0f, position.getBottomY() - 4.0f, 8.0f, 8.0f, ColorUtils.getColor(0, 128, 128, 200)));
        }
        if (this.isSelecting) {
            nanoVGHelper.setupAndDraw(true, vg -> nanoVGHelper.drawRect(vg, this.selectX, this.selectY, (float)mouseX - this.selectX, (float)mouseY - this.selectY, ColorUtils.getColor(0, 0, 255, 100)));
        }
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        Position position;
        super.onMouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        this.isDragging = false;
        this.isSelecting = false;
        this.isScaling = false;
        if (this.editingHuds.size() == 1 && mouseX >= (double)((position = ((Hud)this.editingHuds.keySet().toArray()[0]).position).getRightX() - 7.0f) && mouseX <= (double)(position.getRightX() + 7.0f) && mouseY >= (double)(position.getBottomY() - 7.0f) && mouseY <= (double)(position.getBottomY() + 7.0f)) {
            this.isScaling = true;
            return;
        }
        for (Hud hud : HudCore.huds.values()) {
            if (!hud.isEnabled() || !this.mouseClickedHud(hud, (float)mouseX, (float)mouseY) || hud.isLocked()) continue;
            if (!this.editingHuds.containsKey(hud)) {
                if (!UKeyboard.isCtrlKeyDown()) {
                    this.editingHuds.clear();
                }
                this.editingHuds.put(hud, new GrabOffset());
            }
            this.isDragging = true;
            this.editingHuds.forEach((hud2, grabOffset) -> grabOffset.setOffset((float)(mouseX - (double)hud2.position.getX()), (float)(mouseY - (double)hud2.position.getY())));
            return;
        }
        this.isSelecting = true;
        this.selectX = (float)mouseX;
        this.selectY = (float)mouseY;
    }

    @Override
    public void onMouseReleased(double mouseX, double mouseY, int state) {
        this.isDragging = false;
        this.isSelecting = false;
        this.isScaling = false;
        super.onMouseReleased(mouseX, mouseY, state);
    }

    @Override
    public void onKeyPressed(int keyCode, char typedChar, @Nullable UKeyboard.Modifiers modifiers) {
        if (this.isDragging) {
            return;
        }
        this.editingHuds.forEach((hud, grabOffset) -> grabOffset.setOffset(-hud.position.getX(), -hud.position.getY()));
        if (keyCode == UKeyboard.KEY_UP) {
            this.setHudPositions(0.0f, -1.0f, false);
        } else if (keyCode == UKeyboard.KEY_DOWN) {
            this.setHudPositions(0.0f, 1.0f, false);
        } else if (keyCode == UKeyboard.KEY_LEFT) {
            this.setHudPositions(-1.0f, 0.0f, false);
        } else if (keyCode == UKeyboard.KEY_RIGHT) {
            this.setHudPositions(1.0f, 0.0f, false);
        }
        this.superSecretMethod(typedChar);
        super.onKeyPressed(keyCode, typedChar, modifiers);
    }

    @Override
    public void onScreenClose() {
        super.onScreenClose();
        HudCore.editing = false;
        UKeyboard.allowRepeatEvents(false);
        ConfigCore.saveAll();
        GuiUtils.displayScreen((Object)OneConfigGui.create());
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    private void getHudsInRegion(float x1, float y1, float x2, float y2) {
        float temp;
        if (x1 > x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        this.editingHuds.clear();
        for (Hud hud : HudCore.huds.values()) {
            Position pos;
            if (!hud.isEnabled() || hud.isLocked() || !(x1 <= (pos = hud.position).getX() && x2 >= pos.getX()) && (!(x1 <= pos.getRightX()) || !(x2 >= pos.getRightX())) || !(y1 <= pos.getY() && y2 >= pos.getY()) && (!(y1 <= pos.getBottomY()) || !(y2 >= pos.getBottomY()))) continue;
            this.editingHuds.put(hud, new GrabOffset());
        }
    }

    private void setHudPositions(long vg, float mouseX, float mouseY, boolean snap, boolean locked, int lineWidth) {
        for (Hud hud : this.editingHuds.keySet()) {
            GrabOffset grabOffset = this.editingHuds.get(hud);
            Position position = hud.position;
            float x = mouseX - grabOffset.getX();
            float y = mouseY - grabOffset.getY();
            if (this.editingHuds.size() == 1 && snap) {
                x = this.getXSnapping(vg, lineWidth, x, position.getWidth(), true);
                y = this.getYSnapping(vg, lineWidth, y, position.getHeight(), true);
            }
            if (locked) {
                if (x < 0.0f) {
                    x = 0.0f;
                } else if (x + position.getWidth() > (float)UResolution.getScaledWidth()) {
                    x = (float)UResolution.getScaledWidth() - position.getWidth();
                }
                if (y < 0.0f) {
                    y = 0.0f;
                } else if (y + position.getHeight() > (float)UResolution.getScaledHeight()) {
                    y = (float)UResolution.getScaledHeight() - position.getHeight();
                }
            }
            position.setPosition(x, y);
        }
    }

    private void setHudPositions(float mouseX, float mouseY, boolean locked) {
        this.setHudPositions(0L, mouseX, mouseY, false, locked, 0);
    }

    private boolean mouseClickedHud(Hud hud, float mouseX, float mouseY) {
        Position position = hud.position;
        return mouseX >= position.getX() && mouseX <= position.getRightX() && mouseY >= position.getY() && mouseY <= position.getBottomY();
    }

    private float getXSnapping(long vg, float lineWidth, float x, float width, boolean multipleSides) {
        ArrayList<Float> lines = this.getXSnappingLines();
        ArrayList<SnappingLine> snappingLines = new ArrayList<SnappingLine>();
        float closest = (float)(10.0 / UResolution.getScaleFactor());
        for (Float line : lines) {
            SnappingLine snappingLine = new SnappingLine(line.floatValue(), x, width, multipleSides);
            if (Math.round(snappingLine.getDistance()) == Math.round(closest)) {
                snappingLines.add(snappingLine);
                continue;
            }
            if (!(snappingLine.getDistance() < closest)) continue;
            closest = snappingLine.getDistance();
            snappingLines.clear();
            snappingLines.add(snappingLine);
        }
        if (snappingLines.isEmpty()) {
            return x;
        }
        for (SnappingLine snappingLine : snappingLines) {
            snappingLine.drawLine(vg, lineWidth, true);
        }
        return ((SnappingLine)snappingLines.get(0)).getPosition();
    }

    private ArrayList<Float> getXSnappingLines() {
        ArrayList<Float> lines = new ArrayList<Float>();
        lines.add(Float.valueOf((float)UResolution.getScaledWidth() / 2.0f));
        for (Hud hud : HudCore.huds.values()) {
            if (!hud.isEnabled() || this.editingHuds.containsKey(hud)) continue;
            lines.add(Float.valueOf(hud.position.getX()));
            lines.add(Float.valueOf(hud.position.getCenterX()));
            lines.add(Float.valueOf(hud.position.getRightX()));
        }
        return lines;
    }

    private float getYSnapping(long vg, float lineWidth, float y, float height, boolean multipleSides) {
        ArrayList<Float> lines = this.getYSnappingLines();
        ArrayList<SnappingLine> snappingLines = new ArrayList<SnappingLine>();
        float closest = (float)(10.0 / UResolution.getScaleFactor());
        for (Float line : lines) {
            SnappingLine snappingLine = new SnappingLine(line.floatValue(), y, height, multipleSides);
            if (Math.round(snappingLine.getDistance()) == Math.round(closest)) {
                snappingLines.add(snappingLine);
                continue;
            }
            if (!(snappingLine.getDistance() < closest)) continue;
            closest = snappingLine.getDistance();
            snappingLines.clear();
            snappingLines.add(snappingLine);
        }
        if (snappingLines.isEmpty()) {
            return y;
        }
        for (SnappingLine snappingLine : snappingLines) {
            snappingLine.drawLine(vg, lineWidth, false);
        }
        return ((SnappingLine)snappingLines.get(0)).getPosition();
    }

    private ArrayList<Float> getYSnappingLines() {
        ArrayList<Float> lines = new ArrayList<Float>();
        lines.add(Float.valueOf((float)UResolution.getScaledHeight() / 2.0f));
        for (Hud hud : HudCore.huds.values()) {
            if (!hud.isEnabled() || this.editingHuds.containsKey(hud)) continue;
            lines.add(Float.valueOf(hud.position.getY()));
            lines.add(Float.valueOf(hud.position.getCenterY()));
            lines.add(Float.valueOf(hud.position.getBottomY()));
        }
        return lines;
    }

    private void superSecretMethod(char charTyped) {
        String url;
        this.superSecretString = this.superSecretString + charTyped;
        this.superSecretString = this.superSecretString.toLowerCase();
        if (!("blahaj".substring(0, this.superSecretString.length()).equals(this.superSecretString) || "bl\u00e5haj".substring(0, this.superSecretString.length()).equals(this.superSecretString) || "bigrat".substring(0, this.superSecretString.length()).equals(this.superSecretString))) {
            this.superSecretString = "";
            return;
        }
        if (!("blahaj".equals(this.superSecretString) || "bl\u00e5haj".equals(this.superSecretString) || "bigrat".equals(this.superSecretString))) {
            return;
        }
        switch (this.superSecretString) {
            case "blahaj": 
            case "bl\u00e5haj": {
                url = "https://blahaj.shop/api/random/image?" + UUID.randomUUID();
                break;
            }
            case "bigrat": {
                url = "https://bigrat.monster/media/bigrat.png";
                break;
            }
            default: {
                return;
            }
        }
        this.superSecretString = "";
        AtomicBoolean loaded = new AtomicBoolean();
        AssetHelper assetHelper = AssetHelper.INSTANCE;
        NanoVGHelper.INSTANCE.setupAndDraw(vg -> loaded.set(assetHelper.loadImage(vg, url, HudGui.class)));
        if (!loaded.get()) {
            return;
        }
        NVGAsset image = assetHelper.getNVGImage(url);
        int w = image.getWidth();
        int h2 = image.getHeight();
        float s2 = Math.min(300.0f / (float)w, 300.0f / (float)h2);
        final float width = (float)w * s2;
        final float height = (float)h2 * s2;
        HudCore.huds.put(new Map.Entry<Field, Object>(){

            @Override
            public Field getKey() {
                return null;
            }

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            public Object setValue(Object o) {
                return null;
            }
        }, new Hud(true){

            @Override
            protected void draw(UMatrixStack matrices, float x, float y, float scale, boolean example) {
                NanoVGHelper.INSTANCE.setupAndDraw(true, vg -> NanoVGHelper.INSTANCE.drawImage(vg, url, x, y, width * scale, height * scale));
            }

            @Override
            protected float getWidth(float scale, boolean example) {
                return width * scale;
            }

            @Override
            protected float getHeight(float scale, boolean example) {
                return height * scale;
            }
        });
    }
}

