/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.config.profiles;

import cc.polyfrost.oneconfig.internal.config.OneConfigConfig;
import cc.polyfrost.oneconfig.internal.config.core.ConfigCore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Profiles {
    private static final Logger LOGGER = LogManager.getLogger((String)"OneConfig Profiles");
    public static final File nonProfileSpecificDir = new File("OneConfig/config");
    public static final File profileDir = new File("OneConfig/profiles");
    private static ArrayList<String> profiles;

    public static String getCurrentProfile() {
        String[] profilesArray;
        if (OneConfigConfig.getInstance() == null) {
            OneConfigConfig.getInstance();
        }
        if (!profileDir.exists() && !profileDir.mkdir()) {
            LOGGER.fatal("Could not create profiles folder");
            return null;
        }
        if (profiles == null && (profilesArray = profileDir.list((file, s2) -> file.isDirectory())) != null) {
            profiles = new ArrayList<String>(Arrays.asList(profilesArray));
        }
        if (!Profiles.getProfileDir(OneConfigConfig.currentProfile).exists()) {
            Profiles.createProfile(OneConfigConfig.currentProfile);
        }
        return OneConfigConfig.currentProfile;
    }

    public static void createProfile(String name) {
        File folder = new File(profileDir, name);
        if (!folder.exists() && !folder.mkdir()) {
            LOGGER.fatal("Could not create profile folder");
            return;
        }
        profiles.add(name);
    }

    public static File getProfileDir() {
        return Profiles.getProfileDir(Profiles.getCurrentProfile());
    }

    public static File getProfileDir(String profile) {
        return new File(profileDir, profile);
    }

    public static File getProfileFile(String file) {
        return new File(Profiles.getProfileDir(), file);
    }

    public static File getNonProfileSpecificFile(String file) {
        return new File(nonProfileSpecificDir, file);
    }

    public static List<String> getProfiles() {
        return new ArrayList<String>(profiles);
    }

    public static boolean doesProfileExist(String profile) {
        return profiles.contains(profile);
    }

    public static void loadProfile(String profile) {
        ConfigCore.saveAll();
        OneConfigConfig.currentProfile = profile;
        OneConfigConfig.getInstance().save();
        ConfigCore.reInitAll();
    }

    public static void renameProfile(String name, String newName) {
        try {
            File newFile = new File(profileDir, newName);
            FileUtils.moveDirectory((File)Profiles.getProfileDir(name), (File)newFile);
            if (OneConfigConfig.currentProfile.equals(name)) {
                OneConfigConfig.currentProfile = newName;
            }
            profiles.remove(name);
            profiles.add(newName);
        }
        catch (IOException e) {
            LOGGER.error("Failed to rename profile");
        }
    }

    public static void deleteProfile(String name) {
        if (name.equals(Profiles.getCurrentProfile())) {
            if (profiles.size() == 1) {
                LOGGER.error("Cannot delete only profile!");
                return;
            }
            Profiles.loadProfile(profiles.stream().filter(entry -> !entry.equals(name)).findFirst().get());
        }
        try {
            FileUtils.deleteDirectory((File)Profiles.getProfileDir(name));
            profiles.remove(name);
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete profile");
        }
    }
}

