/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.config.core;

import cc.polyfrost.oneconfig.config.core.OneKeyBind;
import cc.polyfrost.oneconfig.events.event.KeyInputEvent;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KeyBindHandler {
    public static final KeyBindHandler INSTANCE = new KeyBindHandler();
    private final ConcurrentHashMap<Map.Entry<Field, Object>, OneKeyBind> keyBinds = new ConcurrentHashMap();

    @Subscribe
    private void onKeyPressed(KeyInputEvent event) {
        for (OneKeyBind keyBind : this.keyBinds.values()) {
            if (!keyBind.isActive()) continue;
            keyBind.run();
        }
    }

    public void addKeyBind(final Field field, final Object instance, OneKeyBind keyBind) {
        this.keyBinds.put(new Map.Entry<Field, Object>(){

            @Override
            public Field getKey() {
                return field;
            }

            @Override
            public Object getValue() {
                return instance;
            }

            @Override
            public Object setValue(Object value) {
                return null;
            }
        }, keyBind);
    }

    public void reInitKeyBinds() {
        for (Map.Entry field : this.keyBinds.keySet()) {
            if (field.getValue() == null) continue;
            try {
                this.keyBinds.put(field, (OneKeyBind)((Field)field.getKey()).get(field.getValue()));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public void clearKeyBinds() {
        this.keyBinds.clear();
    }
}

