/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.config.compatibility.vigilance;

import cc.polyfrost.oneconfig.config.Config;
import cc.polyfrost.oneconfig.config.core.ConfigUtils;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.config.elements.OptionPage;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigButton;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigCheckbox;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigColorElement;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigDropdown;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigNumber;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigSlider;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigSwitch;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigTextBox;
import cc.polyfrost.oneconfig.internal.config.compatibility.vigilance.VigilantAccessor;
import cc.polyfrost.oneconfig.internal.config.core.ConfigCore;
import cc.polyfrost.oneconfig.libs.universal.ChatColor;
import cc.polyfrost.oneconfig.platform.Platform;
import gg.essential.vigilance.Vigilant;
import gg.essential.vigilance.data.CallablePropertyValue;
import gg.essential.vigilance.data.FieldBackedPropertyValue;
import gg.essential.vigilance.data.KPropertyBackedPropertyValue;
import gg.essential.vigilance.data.PropertyAttributesExt;
import gg.essential.vigilance.data.PropertyData;
import gg.essential.vigilance.data.PropertyKt;
import gg.essential.vigilance.data.PropertyType;
import gg.essential.vigilance.data.ValueBackedPropertyValue;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.jvm.ReflectJvmMapping;

public class VigilanceConfig
extends Config {
    public final Vigilant vigilant;

    public VigilanceConfig(Mod modData, String configFile, Vigilant vigilant) {
        super(modData, configFile, true, false);
        this.vigilant = vigilant;
        this.initialize();
    }

    @Override
    public void initialize() {
        if (this.vigilant != null) {
            this.mod.config = this;
            this.generateOptionsList(this.mod.defaultPage);
            ConfigCore.mods.add(this.mod);
        }
    }

    @Override
    public void save() {
        this.vigilant.markDirty();
        this.vigilant.writeData();
    }

    @Override
    public void load() {
    }

    private void generateOptionsList(OptionPage page) {
        for (PropertyData option : ((VigilantAccessor)this.vigilant).getPropertyCollector().getProperties()) {
            PropertyAttributesExt attributes = option.getAttributesExt();
            if (attributes.getHidden()) continue;
            ArrayList<BasicOption> options = ConfigUtils.getSubCategory((OptionPage)page, (String)this.getCategory((PropertyAttributesExt)attributes), (String)this.getSubcategory((PropertyAttributesExt)attributes)).options;
            switch (attributes.getType()) {
                case SWITCH: {
                    options.add(new ConfigSwitch(this.getFieldOfProperty(option), option.getInstance(), this.getName(attributes), attributes.getDescription(), this.getCategory(attributes), this.getSubcategory(attributes), 2));
                    break;
                }
                case CHECKBOX: {
                    options.add(new ConfigCheckbox(this.getFieldOfProperty(option), option.getInstance(), this.getName(attributes), attributes.getDescription(), this.getCategory(attributes), this.getSubcategory(attributes), 2));
                    break;
                }
                case PARAGRAPH: 
                case TEXT: {
                    options.add(new ConfigTextBox(this.getFieldOfProperty(option), option.getInstance(), this.getName(attributes), attributes.getDescription(), this.getCategory(attributes), this.getSubcategory(attributes), 2, attributes.getPlaceholder(), attributes.getProtected(), attributes.getType() == PropertyType.PARAGRAPH));
                    break;
                }
                case SELECTOR: {
                    options.add(new ConfigDropdown(this.getFieldOfProperty(option), option.getInstance(), this.getName(attributes), attributes.getDescription(), this.getCategory(attributes), this.getSubcategory(attributes), 2, attributes.getOptions().toArray(new String[0])));
                    break;
                }
                case PERCENT_SLIDER: {
                    options.add(new ConfigSlider(this.getFieldOfProperty(option), option.getInstance(), this.getName(attributes), attributes.getDescription(), this.getCategory(attributes), this.getSubcategory(attributes), 0.0f, 1.0f, 0, false));
                    break;
                }
                case DECIMAL_SLIDER: {
                    options.add(new ConfigSlider(this.getFieldOfProperty(option), option.getInstance(), this.getName(attributes), attributes.getDescription(), this.getCategory(attributes), this.getSubcategory(attributes), attributes.getMinF(), attributes.getMaxF(), 0, false));
                    break;
                }
                case NUMBER: {
                    options.add(new ConfigNumber(this.getFieldOfProperty(option), option.getInstance(), this.getName(attributes), attributes.getDescription(), this.getCategory(attributes), this.getSubcategory(attributes), attributes.getMin(), attributes.getMax(), attributes.getIncrement(), 2));
                    break;
                }
                case SLIDER: {
                    options.add(new ConfigSlider(this.getFieldOfProperty(option), option.getInstance(), this.getName(attributes), attributes.getDescription(), this.getCategory(attributes), this.getSubcategory(attributes), attributes.getMin(), attributes.getMax(), 0, false));
                    break;
                }
                case COLOR: {
                    options.add(new CompatConfigColorElement(this.getFieldOfProperty(option), option.getInstance(), this.getName(attributes), attributes.getDescription(), this.getCategory(attributes), this.getSubcategory(attributes), 2, attributes.getAllowAlpha()));
                    break;
                }
                case BUTTON: {
                    options.add(new ConfigButton(() -> ((CallablePropertyValue)option.getValue()).invoke(option.getInstance()), (Object)option.getInstance(), this.getName(attributes), attributes.getDescription(), this.getCategory(attributes), this.getSubcategory(attributes), 2, attributes.getPlaceholder().isEmpty() ? "Activate" : attributes.getPlaceholder()));
                }
            }
            if (attributes.getType() != PropertyType.SWITCH && attributes.getType() != PropertyType.CHECKBOX) continue;
            this.optionNames.put(PropertyKt.fullPropertyPath((PropertyAttributesExt)option.getAttributesExt()), options.get(options.size() - 1));
        }
    }

    private Field getFieldOfProperty(PropertyData data2) {
        if (data2.getValue() instanceof FieldBackedPropertyValue) {
            FieldBackedPropertyValue fieldBackedPropertyValue = (FieldBackedPropertyValue)data2.getValue();
            try {
                Field field = fieldBackedPropertyValue.getClass().getDeclaredField("field");
                field.setAccessible(true);
                return (Field)field.get(fieldBackedPropertyValue);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        if (data2.getValue() instanceof ValueBackedPropertyValue) {
            ValueBackedPropertyValue valueBackedPropertyValue = (ValueBackedPropertyValue)data2.getValue();
            try {
                Field field = valueBackedPropertyValue.getClass().getDeclaredField("obj");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        if (data2.getValue() instanceof KPropertyBackedPropertyValue) {
            KPropertyBackedPropertyValue kPropertyBackedPropertyValue = (KPropertyBackedPropertyValue)data2.getValue();
            try {
                Field field = kPropertyBackedPropertyValue.getClass().getDeclaredField("property");
                field.setAccessible(true);
                KMutableProperty0 property = (KMutableProperty0)field.get(kPropertyBackedPropertyValue);
                return ReflectJvmMapping.getJavaField(property);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unknown property value type: " + data2.getValue().getClass());
    }

    private String getName(PropertyAttributesExt ext) {
        try {
            PropertyAttributesExt.class.getDeclaredField("i18nName").setAccessible(true);
            return Platform.getI18nPlatform().format(ChatColor.Companion.stripControlCodes((String)PropertyAttributesExt.class.getDeclaredField("i18nName").get(ext)), new Object[0]);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return ext.getName();
        }
    }

    private String getCategory(PropertyAttributesExt ext) {
        try {
            PropertyAttributesExt.class.getDeclaredField("i18nCategory").setAccessible(true);
            return Platform.getI18nPlatform().format(ChatColor.Companion.stripControlCodes((String)PropertyAttributesExt.class.getDeclaredField("i18nCategory").get(ext)), new Object[0]);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return ext.getCategory();
        }
    }

    private String getSubcategory(PropertyAttributesExt ext) {
        try {
            PropertyAttributesExt.class.getDeclaredField("i18nSubcategory").setAccessible(true);
            return Platform.getI18nPlatform().format(ChatColor.Companion.stripControlCodes((String)PropertyAttributesExt.class.getDeclaredField("i18nSubcategory").get(ext)), new Object[0]);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return ext.getSubcategory();
        }
    }

    public void addDependency(PropertyData property, PropertyData dependency) {
        BasicOption option = (BasicOption)this.optionNames.get(PropertyKt.fullPropertyPath((PropertyAttributesExt)property.getAttributesExt()));
        if (option != null) {
            option.addDependency(this.getName(dependency.getAttributesExt()), () -> Objects.equals(dependency.getValue().getValue(this.vigilant), true));
        }
    }

    @Override
    public boolean supportsProfiles() {
        return false;
    }

    private static class CompatConfigColorElement
    extends ConfigColorElement {
        private final Field color;
        private Color prevColor = null;
        private OneColor cachedColor = null;

        public CompatConfigColorElement(Field color, Vigilant parent, String name, String description2, String category, String subcategory, int size, boolean allowAlpha) {
            super(null, parent, name, description2, category, subcategory, size, allowAlpha);
            this.color = color;
        }

        @Override
        public Object get() throws IllegalAccessException {
            Color currentColor = (Color)this.color.get(this.parent);
            if (this.cachedColor == null || this.prevColor != this.color.get(this.parent)) {
                this.cachedColor = new OneColor(currentColor);
            }
            this.prevColor = currentColor;
            return this.cachedColor;
        }

        @Override
        protected void set(Object color) throws IllegalAccessException {
            if (color instanceof OneColor) {
                Color newColor = ((OneColor)color).toJavaColor();
                this.color.set(this.parent, newColor);
            }
        }
    }
}

