/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.config;

import cc.polyfrost.oneconfig.config.Config;
import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.gson.exclusion.ProfileExclusionStrategy;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class InternalConfig
extends Config {
    protected final transient Gson gson = this.addGsonOptions(new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new InternalConfigExclusionStrategy()})).create();

    public InternalConfig(String title, String configFile) {
        super(new Mod(title, null), configFile);
    }

    @Override
    public void initialize() {
        if (new File("OneConfig/" + this.configFile).exists()) {
            this.load();
        } else {
            this.save();
        }
        this.generateOptionList(this, this.mod.defaultPage, this.mod, false);
        this.mod.config = this;
    }

    @Override
    public void save() {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get("OneConfig/" + this.configFile, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
            writer.write(this.gson.toJson((Object)this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load() {
        Path path = Paths.get("OneConfig/" + this.configFile, new String[0]);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
            this.gson.fromJson((Reader)reader, this.getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
            File file = path.toFile();
            file.renameTo(new File(file.getParentFile(), file.getName() + ".corrupted"));
        }
    }

    private static final class InternalConfigExclusionStrategy
    extends ProfileExclusionStrategy {
        private InternalConfigExclusionStrategy() {
        }

        @Override
        public boolean shouldSkipField(FieldAttributes f) {
            return f.getName().equals("hypixelKey") || super.shouldSkipField(f);
        }
    }
}

