/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal.command;

import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.internal.config.OneConfigConfig;
import cc.polyfrost.oneconfig.internal.config.profiles.Profiles;
import cc.polyfrost.oneconfig.internal.gui.HudGui;
import cc.polyfrost.oneconfig.libs.universal.ChatColor;
import cc.polyfrost.oneconfig.libs.universal.UChat;
import cc.polyfrost.oneconfig.utils.commands.annotations.Command;
import cc.polyfrost.oneconfig.utils.commands.annotations.Description;
import cc.polyfrost.oneconfig.utils.commands.annotations.Greedy;
import cc.polyfrost.oneconfig.utils.commands.annotations.Main;
import cc.polyfrost.oneconfig.utils.commands.annotations.SubCommand;
import cc.polyfrost.oneconfig.utils.commands.annotations.SubCommandGroup;
import cc.polyfrost.oneconfig.utils.gui.GuiUtils;

@Command(value="oneconfig", aliases={"ocfg"})
public class OneConfigCommand {
    @Main(description="Opens the OneConfig GUI")
    private void main() {
        GuiUtils.displayScreen((Object)OneConfigGui.create());
    }

    @SubCommand(description="Opens the OneConfig HUD configurator.", aliases={"edithud"})
    private void hud() {
        GuiUtils.displayScreen((Object)new HudGui());
    }

    @SubCommand(description="Destroy the currently open OneConfig GUI.")
    private void destroy() {
        OneConfigGui.INSTANCE = null;
    }

    @SubCommandGroup(value="Profile", aliases={"profiles"})
    private static class Profile {
        private Profile() {
        }

        @SubCommand(description="View all profiles", aliases={"view"})
        private void list() {
            StringBuilder builder = new StringBuilder().append((Object)ChatColor.GOLD).append("Available profiles:");
            for (String profile : Profiles.getProfiles()) {
                builder.append("\n");
                if (OneConfigConfig.currentProfile.equals(profile)) {
                    builder.append((Object)ChatColor.GREEN);
                } else {
                    builder.append((Object)ChatColor.RED);
                }
                builder.append(profile);
            }
            UChat.chat(builder.toString());
        }

        @SubCommand(description="Switch to a Profile", aliases={"enable", "set", "load", "switch"})
        private void switchProfile(@Description(value="Profile Name") @Greedy String profile) {
            if (!Profiles.doesProfileExist(profile)) {
                UChat.chat((Object)((Object)ChatColor.RED) + "The Profile \"" + profile + "\" does not exist!");
            } else {
                Profiles.loadProfile(profile);
                UChat.chat((Object)((Object)ChatColor.GREEN) + "Switched to the \"" + profile + "\" Profile.");
            }
        }

        @SubCommand(description="Create a new Profile", aliases={"make"})
        private void create(@Description(value="Profile Name") @Greedy String profile) {
            if (Profiles.doesProfileExist(profile)) {
                UChat.chat((Object)((Object)ChatColor.RED) + "The Profile \"" + profile + "\" already exists!");
            } else {
                Profiles.createProfile(profile);
                if (Profiles.doesProfileExist(profile)) {
                    Profiles.loadProfile(profile);
                }
                UChat.chat((Object)((Object)ChatColor.GREEN) + "Created the \"" + profile + "\" Profile.");
            }
        }

        @SubCommand(description="Rename a Profile")
        private void rename(@Description(value="Old name") String profile, @Description(value="New name") @Greedy String newName) {
            if (!Profiles.doesProfileExist(profile)) {
                UChat.chat((Object)((Object)ChatColor.RED) + "The Profile \"" + profile + "\" does not exist!");
            } else {
                Profiles.renameProfile(profile, newName);
                UChat.chat((Object)((Object)ChatColor.GREEN) + "Renamed the \"" + profile + "\" Profile to \" " + newName + "\".");
            }
        }

        @SubCommand(description="Delete a Profile", aliases={"remove", "destroy"})
        private void delete(@Description(value="Profile name") @Greedy String profile) {
            if (!Profiles.doesProfileExist(profile)) {
                UChat.chat((Object)((Object)ChatColor.RED) + "The Profile \"" + profile + "\" does not exist!");
            } else {
                Profiles.deleteProfile(profile);
                UChat.chat((Object)((Object)ChatColor.GREEN) + "Deleted the \"" + profile + "\" Profile.");
            }
        }
    }
}

