/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.internal;

import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.data.ModType;
import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.events.event.ShutdownEvent;
import cc.polyfrost.oneconfig.internal.command.OneConfigCommand;
import cc.polyfrost.oneconfig.internal.config.OneConfigConfig;
import cc.polyfrost.oneconfig.internal.config.Preferences;
import cc.polyfrost.oneconfig.internal.config.compatibility.forge.ForgeCompat;
import cc.polyfrost.oneconfig.internal.config.core.ConfigCore;
import cc.polyfrost.oneconfig.internal.config.core.KeyBindHandler;
import cc.polyfrost.oneconfig.internal.gui.BlurHandler;
import cc.polyfrost.oneconfig.internal.hud.HudCore;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.ChatColor;
import cc.polyfrost.oneconfig.libs.universal.UChat;
import cc.polyfrost.oneconfig.libs.universal.UScreen;
import cc.polyfrost.oneconfig.libs.universal.wrappers.UPlayer;
import cc.polyfrost.oneconfig.utils.IgnoredGuiFactory;
import cc.polyfrost.oneconfig.utils.Notifications;
import cc.polyfrost.oneconfig.utils.TickDelay;
import cc.polyfrost.oneconfig.utils.commands.CommandManager;
import cc.polyfrost.oneconfig.utils.gui.GuiUtils;
import cc.polyfrost.oneconfig.utils.hypixel.HypixelUtils;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@net.minecraftforge.fml.common.Mod(modid="oneconfig", name="OneConfig", version="0.2.2-alpha216")
public class OneConfig {
    public static final OneConfig INSTANCE = new OneConfig();
    public static final Logger LOGGER = LogManager.getLogger((String)"OneConfig");
    private static boolean initialized = false;

    public OneConfig() {
        EventManager.INSTANCE.register(this);
    }

    public void init() {
        if (initialized) {
            return;
        }
        if (OneConfigConfig.getInstance() == null) {
            OneConfigConfig.getInstance();
        }
        if (Preferences.getInstance() == null) {
            Preferences.getInstance();
        }
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            if (modContainer == null) continue;
            try {
                boolean shouldAttempt = true;
                for (Mod configMod : ConfigCore.mods) {
                    String configModName = configMod.name.toLowerCase(Locale.ENGLISH);
                    String spacelessConfigModName = configModName.replace(" ", "");
                    if (!Objects.equals(configModName, modContainer.getName().toLowerCase(Locale.ENGLISH)) && !Objects.equals(configModName, modContainer.getModId()) && !Objects.equals(spacelessConfigModName, modContainer.getName().toLowerCase(Locale.ENGLISH)) && !Objects.equals(spacelessConfigModName, modContainer.getModId())) continue;
                    shouldAttempt = false;
                }
                for (ArtifactVersion dependency : modContainer.getDependencies()) {
                    if (!Objects.equals("oneconfig", dependency.getLabel())) continue;
                    shouldAttempt = false;
                }
                if (!shouldAttempt || this.handleForgeGui(modContainer)) continue;
                this.handleForgeCommand(modContainer);
            }
            catch (Throwable t2) {
                LOGGER.error("Failed to handle Forge compatibility for {}", (Object)modContainer.getModId(), (Object)t2);
            }
        }
        for (Map.Entry entry : ForgeCompat.compatMods.entrySet()) {
            ConfigCore.mods.add((Mod)entry.getKey());
        }
        Notifications.INSTANCE.getClass();
        EventManager.INSTANCE.register(Notifications.INSTANCE);
        GuiUtils.getDeltaTime();
        try {
            EventManager.INSTANCE.register(BlurHandler.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommandManager.INSTANCE.registerCommand(new OneConfigCommand());
        EventManager.INSTANCE.register(new HudCore());
        HypixelUtils.INSTANCE.initialize();
        EventManager.INSTANCE.register(KeyBindHandler.INSTANCE);
        ConfigCore.sortMods();
        initialized = true;
    }

    private void handleForgeCommand(ModContainer mod) {
        for (ICommand command2 : ClientCommandHandler.instance.func_71555_a().values()) {
            if (!Objects.equals(command2.func_71517_b(), mod.getModId())) continue;
            for (String alias : command2.func_71514_a()) {
                for (Mod configMod : ConfigCore.mods) {
                    if (!Objects.equals(configMod.name.toLowerCase(Locale.ENGLISH).replace(" ", ""), alias.toLowerCase(Locale.ENGLISH))) continue;
                    return;
                }
            }
            ForgeCompat.compatMods.put(new ForgeCompat.ForgeCompatMod(mod.getName(), ModType.THIRD_PARTY), () -> new TickDelay(() -> {
                UScreen.displayScreen(null);
                try {
                    command2.func_184881_a((MinecraftServer)Minecraft.func_71410_x().func_71401_C(), (ICommandSender)UPlayer.getPlayer(), new String[0]);
                }
                catch (Exception e) {
                    UChat.chat((Object)((Object)ChatColor.RED) + "Forge command compat has failed! Please report this to Polyfrost at https://polyfrost.cc/discord");
                }
            }, 1));
            return;
        }
    }

    private boolean handleForgeGui(ModContainer mod) {
        String modLogoFile;
        if ("fml".equalsIgnoreCase(mod.getModId())) {
            return false;
        }
        IModGuiFactory factory = FMLClientHandler.instance().getGuiFactoryFor(mod);
        if (factory == null || !factory.hasConfigGui()) {
            return false;
        }
        if (IgnoredGuiFactory.class.isAssignableFrom(factory.getClass())) {
            return false;
        }
        boolean isForgeContainer = "forge".equalsIgnoreCase(mod.getModId());
        ModMetadata metadata2 = mod.getMetadata();
        String string = modLogoFile = metadata2.logoFile == null || metadata2.logoFile.isEmpty() ? null : metadata2.logoFile;
        if (modLogoFile != null && !isForgeContainer) {
            if (!modLogoFile.startsWith("assets/")) {
                modLogoFile = "/assets/" + modLogoFile;
            }
            if (!(modLogoFile.startsWith("/") || modLogoFile.startsWith("http://") || modLogoFile.startsWith("https://"))) {
                modLogoFile = "/" + modLogoFile;
            }
            if (OneConfig.class.getResource(modLogoFile) == null) {
                LOGGER.warn("Mod '{}' has an invalid logo file: {}", (Object)mod.getName(), (Object)modLogoFile);
                modLogoFile = null;
            }
        }
        String icon = isForgeContainer ? "/assets/oneconfig/icons/forge_logo.png" : modLogoFile;
        ForgeCompat.compatMods.put(new ForgeCompat.ForgeCompatMod(mod.getName(), ModType.THIRD_PARTY, icon), () -> {
            try {
                GuiUtils.displayScreen(factory.createConfigGui(Minecraft.func_71410_x().field_71462_r));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return true;
    }

    @Subscribe
    private void onShutdown(ShutdownEvent event) {
        ConfigCore.saveAll();
    }
}

