/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.hud;

import cc.polyfrost.oneconfig.config.annotations.Color;
import cc.polyfrost.oneconfig.config.annotations.Dropdown;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.events.event.Stage;
import cc.polyfrost.oneconfig.events.event.TickEvent;
import cc.polyfrost.oneconfig.hud.BasicHud;
import cc.polyfrost.oneconfig.internal.hud.HudCore;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.TextRenderer;
import java.util.ArrayList;
import java.util.List;

public abstract class TextHud
extends BasicHud {
    protected transient List<String> lines = new ArrayList<String>();
    @Color(name="Text Color")
    protected OneColor color = new OneColor(255, 255, 255);
    @Dropdown(name="Text Type", options={"No Shadow", "Shadow", "Full Shadow"})
    protected int textType = 0;

    public TextHud(boolean enabled, float x, float y, float scale, boolean background, boolean rounded, float cornerRadius, float paddingX, float paddingY, OneColor bgColor, boolean border, float borderSize, OneColor borderColor) {
        super(enabled, x, y, scale, background, rounded, cornerRadius, paddingX, paddingY, bgColor, border, borderSize, borderColor);
        EventManager.INSTANCE.register(new TickHandler());
    }

    public TextHud(boolean enabled, int x, int y) {
        super(enabled, x, y);
        EventManager.INSTANCE.register(new TickHandler());
    }

    public TextHud(boolean enabled) {
        this(enabled, 0, 0);
    }

    protected abstract void getLines(List<String> var1, boolean var2);

    protected void getLinesFrequent(List<String> lines, boolean example) {
    }

    @Override
    public void draw(UMatrixStack matrices, float x, float y, float scale, boolean example) {
        if (this.lines == null || this.lines.size() == 0) {
            return;
        }
        float textY = y;
        for (String line : this.lines) {
            this.drawLine(line, x, textY, scale);
            textY += 12.0f * scale;
        }
    }

    protected void drawLine(String line, float x, float y, float scale) {
        TextRenderer.drawScaledString(line, x, y, this.color.getRGB(), TextRenderer.TextType.toType(this.textType), scale);
    }

    protected float getLineWidth(String line, float scale) {
        return (float)Platform.getGLPlatform().getStringWidth(line) * scale;
    }

    @Override
    protected void preRender(boolean example) {
        this.getLinesFrequent(this.lines, example);
    }

    @Override
    protected float getWidth(float scale, boolean example) {
        if (this.lines == null) {
            return 0.0f;
        }
        float width = 0.0f;
        for (String line : this.lines) {
            width = Math.max(width, this.getLineWidth(line, scale));
        }
        return width;
    }

    @Override
    protected float getHeight(float scale, boolean example) {
        return this.lines == null ? 0.0f : (float)(this.lines.size() * 12 - 4) * scale;
    }

    @Override
    public boolean shouldDrawBackground() {
        return super.shouldDrawBackground() && this.lines != null && this.lines.size() > 0;
    }

    private class TickHandler {
        private TickHandler() {
        }

        @Subscribe
        private void onTick(TickEvent event) {
            if (event.stage != Stage.END || !TextHud.this.isEnabled()) {
                return;
            }
            TextHud.this.lines.clear();
            TextHud.this.getLines(TextHud.this.lines, HudCore.editing);
        }
    }
}

