/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.hud;

import cc.polyfrost.oneconfig.config.annotations.Color;
import cc.polyfrost.oneconfig.config.annotations.Dropdown;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.annotations.Text;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.hud.TextHud;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import cc.polyfrost.oneconfig.renderer.TextRenderer;
import java.util.List;

public abstract class SingleTextHud
extends TextHud {
    @Switch(name="Brackets")
    protected boolean brackets = false;
    @Color(name="Brackets Color")
    protected OneColor bracketsColor = new OneColor(-1);
    @Text(name="Title")
    protected String title;
    @Dropdown(name="Title Location", options={"Left", "Right"})
    protected int titleLocation = 0;

    public SingleTextHud(String title, boolean enabled, float x, float y, float scale, boolean background, boolean rounded, float cornerRadius, float paddingX, float paddingY, OneColor bgColor, boolean border, float borderSize, OneColor borderColor) {
        super(enabled, x, y, scale, background, rounded, cornerRadius, paddingX, paddingY, bgColor, border, borderSize, borderColor);
        this.title = title;
    }

    public SingleTextHud(String title, boolean enabled, int x, int y) {
        this(title, enabled, x, y, 1.0f, true, false, 2.0f, 5.0f, 5.0f, new OneColor(0, 0, 0, 120), false, 2.0f, new OneColor(0, 0, 0));
    }

    public SingleTextHud(String title, boolean enabled) {
        this(title, enabled, 0, 0);
    }

    protected abstract String getText(boolean var1);

    protected String getTextFrequent(boolean example) {
        return null;
    }

    @Override
    protected void getLines(List<String> lines, boolean example) {
        lines.add(this.getCompleteText(this.getText(example)));
    }

    @Override
    protected void getLinesFrequent(List<String> lines, boolean example) {
        String text = this.getTextFrequent(example);
        if (text == null) {
            return;
        }
        lines.clear();
        lines.add(this.getCompleteText(text));
    }

    @Override
    public void draw(UMatrixStack matrices, float x, float y, float scale, boolean example) {
        float textX = x;
        if (this.brackets) {
            this.drawLine("[", textX, y, this.bracketsColor, scale);
            textX += this.getLineWidth("[", scale);
        }
        this.drawLine((String)this.lines.get(0), textX, y, scale);
        if (this.brackets) {
            this.drawLine("]", textX += this.getLineWidth((String)this.lines.get(0), scale), y, this.bracketsColor, scale);
        }
    }

    protected void drawLine(String line, float x, float y, OneColor color, float scale) {
        TextRenderer.drawScaledString(line, x, y, color.getRGB(), TextRenderer.TextType.toType(this.textType), scale);
    }

    protected final String getCompleteText(String text) {
        boolean showTitle = !this.title.trim().isEmpty();
        StringBuilder builder = new StringBuilder();
        if (showTitle && this.titleLocation == 0) {
            builder.append(this.title).append(": ");
        }
        builder.append(text);
        if (showTitle && this.titleLocation == 1) {
            builder.append(" ").append(this.title);
        }
        return builder.toString();
    }

    @Override
    protected float getWidth(float scale, boolean example) {
        if (this.lines == null || this.lines.isEmpty()) {
            return 0.0f;
        }
        if (!this.brackets) {
            return this.getLineWidth((String)this.lines.get(0), scale);
        }
        return this.getLineWidth("[" + (String)this.lines.get(0) + "]", scale);
    }
}

