/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.hud;

import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.hud.Hud;
import cc.polyfrost.oneconfig.libs.universal.UResolution;
import org.jetbrains.annotations.Nullable;

public class Position {
    public AnchorPosition anchor;
    private float x;
    private float y;
    @Exclude
    private float width;
    @Exclude
    private float height;
    @Exclude
    @Nullable
    private Hud hud;

    public Position(Hud hud, float x, float y, float width, float height, float screenWidth, float screenHeight) {
        this.hud = hud;
        this.setSize(width, height);
        this.setPosition(x, y, screenWidth, screenHeight);
    }

    public Position(Hud hud, float x, float y, float width, float height) {
        this(hud, x, y, width, height, 1920.0f, 1080.0f);
    }

    public void setPosition(float x, float y, float screenWidth, float screenHeight) {
        float rightX = x + this.width;
        float bottomY = y + this.height;
        this.anchor = x <= screenWidth / 3.0f && y <= screenHeight / 3.0f ? AnchorPosition.TOP_LEFT : (rightX >= screenWidth / 3.0f * 2.0f && y <= screenHeight / 3.0f ? AnchorPosition.TOP_RIGHT : (x <= screenWidth / 3.0f && bottomY >= screenHeight / 3.0f * 2.0f ? AnchorPosition.BOTTOM_LEFT : (rightX >= screenWidth / 3.0f * 2.0f && bottomY >= screenHeight / 3.0f * 2.0f ? AnchorPosition.BOTTOM_RIGHT : (y <= screenHeight / 3.0f ? AnchorPosition.TOP_CENTER : (x <= screenWidth / 3.0f ? AnchorPosition.MIDDLE_LEFT : (rightX >= screenWidth / 3.0f * 2.0f ? AnchorPosition.MIDDLE_RIGHT : (bottomY >= screenHeight / 3.0f * 2.0f ? AnchorPosition.BOTTOM_CENTER : AnchorPosition.MIDDLE_CENTER)))))));
        if (this.hud != null) {
            block0 : switch (this.hud.positionAlignment) {
                case 1: {
                    switch (this.anchor) {
                        case TOP_LEFT: 
                        case TOP_RIGHT: 
                        case TOP_CENTER: {
                            this.anchor = AnchorPosition.TOP_LEFT;
                            break;
                        }
                        case MIDDLE_LEFT: 
                        case MIDDLE_RIGHT: 
                        case MIDDLE_CENTER: {
                            this.anchor = AnchorPosition.MIDDLE_LEFT;
                            break;
                        }
                        case BOTTOM_LEFT: 
                        case BOTTOM_RIGHT: 
                        case BOTTOM_CENTER: {
                            this.anchor = AnchorPosition.BOTTOM_LEFT;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.anchor) {
                        case TOP_LEFT: 
                        case TOP_RIGHT: 
                        case TOP_CENTER: {
                            this.anchor = AnchorPosition.TOP_CENTER;
                            break;
                        }
                        case MIDDLE_LEFT: 
                        case MIDDLE_RIGHT: 
                        case MIDDLE_CENTER: {
                            this.anchor = AnchorPosition.MIDDLE_CENTER;
                            break;
                        }
                        case BOTTOM_LEFT: 
                        case BOTTOM_RIGHT: 
                        case BOTTOM_CENTER: {
                            this.anchor = AnchorPosition.BOTTOM_CENTER;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.anchor) {
                        case TOP_LEFT: 
                        case TOP_RIGHT: 
                        case TOP_CENTER: {
                            this.anchor = AnchorPosition.TOP_RIGHT;
                            break block0;
                        }
                        case MIDDLE_LEFT: 
                        case MIDDLE_RIGHT: 
                        case MIDDLE_CENTER: {
                            this.anchor = AnchorPosition.MIDDLE_RIGHT;
                            break block0;
                        }
                        case BOTTOM_LEFT: 
                        case BOTTOM_RIGHT: 
                        case BOTTOM_CENTER: {
                            this.anchor = AnchorPosition.BOTTOM_RIGHT;
                        }
                    }
                }
            }
        }
        this.x = x - this.getAnchorX(screenWidth) + this.getAnchorX(this.width);
        this.y = y - this.getAnchorY(screenHeight) + this.getAnchorY(this.height);
    }

    public void setPosition(float x, float y) {
        this.setPosition(x, y, UResolution.getScaledWidth(), UResolution.getScaledHeight());
    }

    public void setSize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public void setHud(Hud hud) {
        this.hud = hud;
    }

    public void updateSizePosition(float width, float height) {
        float x = this.getX();
        float y = this.getY();
        this.setSize(width, height);
        this.setPosition(x, y);
    }

    public float getX(float screenWidth) {
        return this.x + this.getAnchorX(screenWidth) - this.getAnchorX(this.width);
    }

    public float getX() {
        return this.getX(UResolution.getScaledWidth());
    }

    public void setX(float x) {
        this.x = x - this.getAnchorX(UResolution.getScaledWidth()) + this.getAnchorX(this.width);
    }

    public float getY(float screenHeight) {
        return this.y + this.getAnchorY(screenHeight) - this.getAnchorY(this.height);
    }

    public float getY() {
        return this.getY(UResolution.getScaledHeight());
    }

    public void setY(float y) {
        this.y = y - this.getAnchorY(UResolution.getScaledHeight()) + this.getAnchorY(this.height);
    }

    public float getRightX(float screenWidth) {
        return this.getX(screenWidth) + this.width;
    }

    public float getRightX() {
        return this.getRightX(UResolution.getScaledWidth());
    }

    public float getBottomY(float screenHeight) {
        return this.getY(screenHeight) + this.height;
    }

    public float getBottomY() {
        return this.getBottomY(UResolution.getScaledHeight());
    }

    public float getCenterX(float screenWidth) {
        return this.getX(screenWidth) + this.width / 2.0f;
    }

    public float getCenterX() {
        return this.getCenterX(UResolution.getScaledWidth());
    }

    public float getCenterY(float screenHeight) {
        return this.getY(screenHeight) + this.height / 2.0f;
    }

    public float getCenterY() {
        return this.getCenterY(UResolution.getScaledHeight());
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    private float getAnchorX(float value) {
        return value * this.anchor.x;
    }

    private float getAnchorY(float value) {
        return value * this.anchor.y;
    }

    public static enum AnchorPosition {
        TOP_LEFT(0.0f, 0.0f),
        TOP_CENTER(0.5f, 0.0f),
        TOP_RIGHT(1.0f, 0.0f),
        MIDDLE_LEFT(0.0f, 0.5f),
        MIDDLE_CENTER(0.5f, 0.5f),
        MIDDLE_RIGHT(1.0f, 0.5f),
        BOTTOM_LEFT(0.0f, 1.0f),
        BOTTOM_CENTER(0.5f, 1.0f),
        BOTTOM_RIGHT(1.0f, 1.0f);

        public final float x;
        public final float y;

        private AnchorPosition(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

