/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.hud;

import cc.polyfrost.oneconfig.config.Config;
import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.hud.Position;
import cc.polyfrost.oneconfig.internal.hud.HudCore;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import cc.polyfrost.oneconfig.platform.Platform;

public abstract class Hud {
    protected boolean enabled;
    protected boolean locked;
    protected boolean ignoreCaching;
    private transient Config config;
    public Position position;
    protected float scale;
    public int positionAlignment;
    @Exclude
    private int defaultAlignment;
    @Exclude
    public float deltaTicks;
    @Exclude
    private float defaultScale;
    @Exclude
    private final Runnable resetPosition = this::resetPosition;
    @Exclude
    private boolean loaded = false;
    @Exclude
    private Position defaultPosition;
    @Switch(name="Show in Chat")
    public boolean showInChat = true;
    @Switch(name="Show in F3 (Debug)")
    public boolean showInDebug = false;
    @Switch(name="Show in GUIs")
    public boolean showInGuis = true;

    public Hud(boolean enabled, float x, float y, int positionAlignment, float scale) {
        this.enabled = enabled;
        this.scale = scale;
        this.positionAlignment = positionAlignment;
        this.position = new Position(this, x, y, this.getWidth(scale, true), this.getHeight(scale, true));
        if (!this.loaded) {
            this.defaultPosition = this.position;
            this.defaultAlignment = positionAlignment;
            this.defaultScale = scale;
            this.loaded = true;
        }
    }

    public Hud(boolean enabled, float x, float y, float scale) {
        this(enabled, x, y, 0, scale);
    }

    public Hud(boolean enabled, float x, float y) {
        this(enabled, x, y, 1.0f);
    }

    public Hud(boolean enabled) {
        this(enabled, 0.0f, 0.0f, 1.0f);
    }

    public Hud() {
        this(false, 0.0f, 0.0f, 1.0f);
    }

    protected abstract void draw(UMatrixStack var1, float var2, float var3, float var4, boolean var5);

    protected abstract float getWidth(float var1, boolean var2);

    protected abstract float getHeight(float var1, boolean var2);

    protected void preRender(boolean example) {
    }

    protected void resetPosition() {
        Position pos = this.defaultPosition;
        float width = this.position.getWidth();
        float height = this.position.getHeight();
        this.positionAlignment = this.defaultAlignment;
        this.scale = this.defaultScale;
        this.position.anchor = pos.anchor;
        float anchorX = this.position.anchor.x;
        float anchorY = this.position.anchor.y;
        if (anchorX == 0.0f) {
            this.position.setX(pos.getX());
        } else if (anchorX == 0.5f) {
            this.position.setX(pos.getCenterX() - width / 2.0f);
        } else {
            this.position.setX(pos.getRightX() - width);
        }
        if (anchorY == 0.0f) {
            this.position.setY(pos.getY());
        } else if (anchorY == 0.5f) {
            this.position.setY(pos.getCenterY() - height / 2.0f);
        } else {
            this.position.setY(pos.getBottomY() - height);
        }
    }

    public void drawAll(UMatrixStack matrices, boolean example) {
        if (!example && !this.shouldShow()) {
            return;
        }
        this.preRender(example);
        this.position.setSize(this.getWidth(this.scale, example), this.getHeight(this.scale, example));
        this.draw(matrices, this.position.getX(), this.position.getY(), this.scale, example);
    }

    protected boolean shouldShow() {
        if (!this.showInGuis && Platform.getGuiPlatform().getCurrentScreen() != null && !(Platform.getGuiPlatform().getCurrentScreen() instanceof OneConfigGui)) {
            return false;
        }
        if (!this.showInChat && Platform.getGuiPlatform().isInChat()) {
            return false;
        }
        return this.showInDebug || !Platform.getGuiPlatform().isInDebug();
    }

    public boolean isEnabled() {
        return this.enabled && (this.config == null || this.config.enabled);
    }

    public boolean isLocked() {
        return this.locked && (this.config == null || this.config.enabled);
    }

    public boolean isCachingIgnored() {
        return this.ignoreCaching && (this.config == null || this.config.enabled) && HudCore.isPatcher();
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale, boolean example) {
        this.scale = scale;
        this.position.updateSizePosition(this.getWidth(scale, example), this.getHeight(scale, example));
    }
}

