/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.hud;

import cc.polyfrost.oneconfig.config.Config;
import cc.polyfrost.oneconfig.config.annotations.HUD;
import cc.polyfrost.oneconfig.config.core.ConfigUtils;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.config.elements.OptionPage;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigButton;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigCheckbox;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigColorElement;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigDropdown;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigHeader;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigSlider;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigSwitch;
import cc.polyfrost.oneconfig.hud.BasicHud;
import cc.polyfrost.oneconfig.hud.Hud;
import cc.polyfrost.oneconfig.internal.gui.HudGui;
import cc.polyfrost.oneconfig.internal.hud.HudCore;
import cc.polyfrost.oneconfig.platform.Platform;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class HUDUtils {
    public static void addHudOptions(OptionPage page, final Field field, final Object instance, Config config) {
        HUD hudAnnotation = field.getAnnotation(HUD.class);
        Hud hud = (Hud)ConfigUtils.getField(field, instance);
        if (hud == null) {
            return;
        }
        hud.position.setHud(hud);
        hud.setConfig(config);
        HudCore.huds.put(new Map.Entry<Field, Object>(){

            @Override
            public Field getKey() {
                return field;
            }

            @Override
            public Object getValue() {
                return instance;
            }

            @Override
            public Object setValue(Object value) {
                return null;
            }
        }, hud);
        String category = hudAnnotation.category();
        String subcategory = hudAnnotation.subcategory();
        ArrayList<BasicOption> options = new ArrayList<BasicOption>();
        try {
            ArrayList<Field> fieldArrayList = ConfigUtils.getClassFields(hud.getClass());
            HashMap<String, Field> fields2 = new HashMap<String, Field>();
            for (Field f : fieldArrayList) {
                fields2.put(f.getName(), f);
            }
            options.add(new ConfigHeader(field, hud, hudAnnotation.name(), category, subcategory, 2));
            options.add(new ConfigSwitch((Field)fields2.get("enabled"), hud, "Enabled", "If the HUD is enabled", category, subcategory, 1));
            options.add(new ConfigButton((Field)fields2.get("resetPosition"), (Object)hud, "Position", "Reset HUD to default position", category, subcategory, 1, "Reset"));
            options.add(new ConfigSwitch((Field)fields2.get("locked"), hud, "Locked", "If the position is locked", category, subcategory, 1));
            ConfigSwitch ignoreCaching = new ConfigSwitch((Field)fields2.get("ignoreCaching"), hud, "Ignore HUD Caching", "Ignore Patcher's HUD Caching feature, which limits HUDs to a specific FPS.", category, subcategory, 1);
            ignoreCaching.addHideCondition(() -> !HudCore.isPatcher());
            options.add(ignoreCaching);
            options.add(new ConfigSlider((Field)fields2.get("scale"), hud, "Scale", "The scale of the HUD", category, subcategory, 0.3f, 10.0f, 0, false));
            ConfigDropdown dropdown = new ConfigDropdown((Field)fields2.get("positionAlignment"), hud, "Position Alignment", "The alignment of the HUD", category, subcategory, 2, new String[]{"Auto", "Left", "Center", "Right"});
            dropdown.addListener(() -> hud.setScale(hud.scale, Platform.getGuiPlatform().getCurrentScreen() instanceof HudGui));
            options.add(dropdown);
            options.addAll(ConfigUtils.getClassOptions(hud));
            if (hud instanceof BasicHud) {
                options.add(new ConfigCheckbox((Field)fields2.get("background"), hud, "Background", "If the background of the HUD is enabled.", category, subcategory, 1));
                options.add(new ConfigCheckbox((Field)fields2.get("rounded"), hud, "Rounded corners", "If the background has rounded corners.", category, subcategory, 1));
                ((BasicOption)options.get(options.size() - 1)).addDependency("Background or Border", () -> ((BasicHud)hud).background || ((BasicHud)hud).border);
                options.add(new ConfigCheckbox((Field)fields2.get("border"), hud, "Outline/border", "If the hud has an outline.", category, subcategory, 1));
                options.add(new ConfigColorElement((Field)fields2.get("bgColor"), hud, "Background color:", "The color of the background.", category, subcategory, 1, true));
                ((BasicOption)options.get(options.size() - 1)).addDependency("Background", () -> ((BasicHud)hud).background);
                options.add(new ConfigColorElement((Field)fields2.get("borderColor"), hud, "Border color:", "The color of the border.", category, subcategory, 1, true));
                ((BasicOption)options.get(options.size() - 1)).addDependency("Border", () -> ((BasicHud)hud).border);
                options.add(new ConfigSlider((Field)fields2.get("cornerRadius"), hud, "Corner radius:", "The corner radius of the background.", category, subcategory, 0.0f, 10.0f, 0, false));
                ((BasicOption)options.get(options.size() - 1)).addDependency("Rounded", () -> ((BasicHud)hud).rounded);
                options.add(new ConfigSlider((Field)fields2.get("borderSize"), hud, "Border thickness:", "The thickness of the outline.", category, subcategory, 0.0f, 10.0f, 0, false));
                ((BasicOption)options.get(options.size() - 1)).addDependency("Border", () -> ((BasicHud)hud).border);
                Field paddingX = (Field)fields2.get("paddingX");
                Field paddingY = (Field)fields2.get("paddingY");
                try {
                    boolean changed = false;
                    if (((Float)ConfigUtils.getField(paddingX, hud)).floatValue() > 10.0f) {
                        paddingX.set(hud, Float.valueOf(5.0f));
                        changed = true;
                    }
                    if (((Float)ConfigUtils.getField(paddingY, hud)).floatValue() > 10.0f) {
                        paddingY.set(hud, Float.valueOf(5.0f));
                        changed = true;
                    }
                    if (changed) {
                        config.save();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                options.add(new ConfigSlider(paddingX, hud, "X-Padding", "The horizontal padding of the HUD.", category, subcategory, 0.0f, 10.0f, 0, false));
                options.add(new ConfigSlider(paddingY, hud, "Y-Padding", "The vertical padding of the HUD.", category, subcategory, 0.0f, 10.0f, 0, false));
                ((BasicOption)options.get(options.size() - 2)).addDependency("Background or Border", () -> ((BasicHud)hud).background || ((BasicHud)hud).border);
                ((BasicOption)options.get(options.size() - 1)).addDependency("Background or Border", () -> ((BasicHud)hud).background || ((BasicHud)hud).border);
            }
            for (BasicOption option : options) {
                if (option.name.equals("Enabled")) continue;
                option.addDependency(hudAnnotation.name(), hud::isEnabled);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HudCore.hudOptions.addAll(options);
        ConfigUtils.getSubCategory((OptionPage)page, (String)hudAnnotation.category(), (String)hudAnnotation.subcategory()).options.addAll(options);
    }
}

