/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.hud;

import cc.polyfrost.oneconfig.config.annotations.Exclude;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.hud.Hud;
import cc.polyfrost.oneconfig.libs.universal.UMatrixStack;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;

public abstract class BasicHud
extends Hud {
    protected boolean background;
    protected boolean rounded;
    protected boolean border;
    protected OneColor bgColor;
    protected OneColor borderColor;
    protected float cornerRadius;
    protected float borderSize;
    protected float defaultPaddingX;
    protected float paddingX;
    protected float defaultPaddingY;
    protected float paddingY;
    @Exclude
    private boolean loaded = false;

    public BasicHud(boolean enabled, float x, float y, float scale, boolean background, boolean rounded, float cornerRadius, float paddingX, float paddingY, OneColor bgColor, boolean border, float borderSize, OneColor borderColor) {
        super(enabled, x, y, scale);
        this.background = background;
        this.rounded = rounded;
        this.cornerRadius = cornerRadius;
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        this.bgColor = bgColor;
        this.border = border;
        this.borderSize = borderSize;
        this.borderColor = borderColor;
        this.position.setSize(this.getWidth(scale, true) + paddingX * scale * 2.0f, this.getHeight(scale, true) + paddingY * scale * 2.0f);
        if (!this.loaded) {
            this.defaultPaddingX = paddingX;
            this.defaultPaddingY = paddingY;
            this.loaded = true;
        }
    }

    public BasicHud(boolean enabled, float x, float y, float scale) {
        this(enabled, x, y, scale, true, false, 2.0f, 5.0f, 5.0f, new OneColor(0, 0, 0, 120), false, 2.0f, new OneColor(0, 0, 0));
    }

    public BasicHud(boolean enabled, float x, float y) {
        this(enabled, x, y, 1.0f, true, false, 2.0f, 5.0f, 5.0f, new OneColor(0, 0, 0, 120), false, 2.0f, new OneColor(0, 0, 0));
    }

    public BasicHud(boolean enabled) {
        this(enabled, 0.0f, 0.0f, 1.0f, true, false, 2.0f, 5.0f, 5.0f, new OneColor(0, 0, 0, 120), false, 2.0f, new OneColor(0, 0, 0));
    }

    public BasicHud() {
        this(false, 0.0f, 0.0f, 1.0f, true, false, 2.0f, 5.0f, 5.0f, new OneColor(0, 0, 0, 120), false, 2.0f, new OneColor(0, 0, 0));
    }

    @Override
    public void drawAll(UMatrixStack matrices, boolean example) {
        if (!example && !this.shouldShow()) {
            return;
        }
        this.preRender(example);
        this.position.setSize(this.getWidth(this.scale, example) + this.paddingX * this.scale * 2.0f, this.getHeight(this.scale, example) + this.paddingY * this.scale * 2.0f);
        if (this.shouldDrawBackground() && this.background) {
            this.drawBackground(this.position.getX(), this.position.getY(), this.position.getWidth(), this.position.getHeight(), this.scale);
        }
        this.draw(matrices, this.position.getX() + this.paddingX * this.scale, this.position.getY() + this.paddingY * this.scale, this.scale, example);
    }

    @Override
    protected void resetPosition() {
        this.paddingX = this.defaultPaddingX;
        this.paddingY = this.defaultPaddingY;
        super.resetPosition();
    }

    @Override
    public void setScale(float scale, boolean example) {
        this.scale = scale;
        this.position.updateSizePosition(this.getWidth(scale, example) + this.paddingX * scale * 2.0f, this.getHeight(scale, example) + this.paddingY * scale * 2.0f);
    }

    protected boolean shouldDrawBackground() {
        return true;
    }

    protected void drawBackground(float x, float y, float width, float height, float scale) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        nanoVGHelper.setupAndDraw(true, vg -> {
            if (this.rounded) {
                nanoVGHelper.drawRoundedRect(vg, x, y, width, height, this.bgColor.getRGB(), this.cornerRadius * scale);
                if (this.border) {
                    nanoVGHelper.drawHollowRoundRect(vg, x - this.borderSize * scale, y - this.borderSize * scale, width + this.borderSize * scale, height + this.borderSize * scale, this.borderColor.getRGB(), this.cornerRadius * scale, this.borderSize * scale);
                }
            } else {
                nanoVGHelper.drawRect(vg, x, y, width, height, this.bgColor.getRGB());
                if (this.border) {
                    nanoVGHelper.drawHollowRoundRect(vg, x - this.borderSize * scale, y - this.borderSize * scale, width + this.borderSize * scale, height + this.borderSize * scale, this.borderColor.getRGB(), 0.0f, this.borderSize * scale);
                }
            }
        });
    }
}

