/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.pages;

import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.ColorAnimation;
import cc.polyfrost.oneconfig.gui.animations.EaseOutQuad;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.scissor.Scissor;
import cc.polyfrost.oneconfig.renderer.scissor.ScissorHelper;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import java.util.ArrayList;
import java.util.Objects;

public abstract class Page {
    protected String title;
    protected Animation scrollAnimation;
    private final ColorAnimation colorAnimation = new ColorAnimation(new ColorPalette(Colors.TRANSPARENT, Colors.GRAY_400_60, Colors.GRAY_400_60), 200);
    protected float scrollTarget;
    private long scrollTime;
    private boolean mouseWasDown;
    private boolean dragging;
    private float yStart;
    protected float scroll;
    public final ArrayList<Page> parents = new ArrayList();
    private String previousSearch = "";

    public Page(String title) {
        this.title = title;
    }

    public abstract void draw(long var1, int var3, int var4, InputHandler var5);

    public int drawStatic(long vg, int x, int y, InputHandler inputHandler) {
        return 0;
    }

    public void finishUpAndClose() {
        this.scroll = 0.0f;
        this.scrollTarget = 0.0f;
        this.scrollTime = 0L;
        this.scrollAnimation = null;
    }

    public void scrollWithDraw(long vg, int x, int y, InputHandler inputHandler) {
        ScissorHelper scissorHelper = ScissorHelper.INSTANCE;
        int maxScroll = this.getMaxScrollHeight();
        int scissorOffset = this.drawStatic(vg, x, y, inputHandler);
        if (OneConfigGui.INSTANCE != null && !Objects.equals(this.previousSearch, OneConfigGui.INSTANCE.getSearchValue())) {
            this.previousSearch = OneConfigGui.INSTANCE.getSearchValue();
            this.finishUpAndClose();
        }
        this.scroll = this.scrollAnimation == null ? this.scrollTarget : this.scrollAnimation.get();
        float scrollBarLength = 728.0f / (float)maxScroll * 728.0f;
        Scissor scissor = scissorHelper.scissor(vg, x, y + scissorOffset, x + 1056, y + 728 - scissorOffset);
        Scissor inputScissor = inputHandler.blockInputArea(x, y, 1056.0f, scissorOffset);
        float dWheel = (float)inputHandler.getDWheel();
        if (dWheel != 0.0f) {
            this.scrollTarget += dWheel;
            if (this.scrollTarget > 0.0f) {
                this.scrollTarget = 0.0f;
            } else if (this.scrollTarget < (float)(-maxScroll + 728)) {
                this.scrollTarget = -maxScroll + 728;
            }
            this.scrollAnimation = new EaseOutQuad(150, this.scroll, this.scrollTarget, false);
            this.scrollTime = System.currentTimeMillis();
        } else if (this.scrollAnimation != null && this.scrollAnimation.isFinished()) {
            this.scrollAnimation = null;
        }
        if (maxScroll <= 728) {
            this.draw(vg, x, y, inputHandler);
            scissorHelper.resetScissor(vg, scissor);
            inputHandler.stopBlock(inputScissor);
            return;
        }
        this.draw(vg, x, (int)((float)y + this.scroll), inputHandler);
        if (this.dragging && inputHandler.isClicked(true)) {
            this.dragging = false;
        }
        scissorHelper.resetScissor(vg, scissor);
        inputHandler.stopBlock(inputScissor);
        if (!(scrollBarLength > 727.0f)) {
            boolean scrollTimePeriod;
            float scrollBarY = this.scroll / (float)maxScroll * 720.0f;
            boolean isMouseDown = Platform.getMousePlatform().isButtonDown(0);
            boolean scrollHover = inputHandler.isAreaHovered(x + 1042, (int)((float)y - scrollBarY), 12.0f, (int)scrollBarLength);
            boolean bl = scrollTimePeriod = System.currentTimeMillis() - this.scrollTime < 1000L;
            if (scrollHover && isMouseDown && !this.mouseWasDown) {
                this.yStart = inputHandler.mouseY();
                this.dragging = true;
            }
            this.mouseWasDown = isMouseDown;
            if (this.dragging) {
                this.scrollTarget = -(inputHandler.mouseY() - this.yStart) * (float)maxScroll / 728.0f;
                if (this.scrollTarget > 0.0f) {
                    this.scrollTarget = 0.0f;
                } else if (this.scrollTarget < (float)(-maxScroll + 728)) {
                    this.scrollTarget = -maxScroll + 728;
                }
                this.scrollAnimation = new EaseOutQuad(150, this.scroll, this.scrollTarget, false);
            }
            NanoVGHelper.INSTANCE.drawRoundedRect(vg, x + 1048, (float)y - scrollBarY, 4.0f, scrollBarLength, this.colorAnimation.getColor(scrollHover || scrollTimePeriod, this.dragging), 4.0f);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void keyTyped(char key, int keyCode) {
    }

    public boolean isBase() {
        return false;
    }

    public int getMaxScrollHeight() {
        return 728;
    }
}

