/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.pages;

import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.data.ModType;
import cc.polyfrost.oneconfig.config.elements.SubConfig;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.elements.BasicButton;
import cc.polyfrost.oneconfig.gui.elements.ModCard;
import cc.polyfrost.oneconfig.gui.pages.Page;
import cc.polyfrost.oneconfig.gui.pages.SubModsPage;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.config.OneConfigConfig;
import cc.polyfrost.oneconfig.internal.config.core.ConfigCore;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.SearchUtils;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import java.util.ArrayList;

public class ModsPage
extends Page {
    public final ArrayList<ModCard> modCards = new ArrayList();
    private final ArrayList<BasicButton> modCategories = new ArrayList();
    private int size;

    public ModsPage() {
        super("Mods");
        this.reloadMods();
        this.modCategories.add(new BasicButton(64, 32, "All", 2, ColorPalette.SECONDARY));
        this.modCategories.add(new BasicButton(80, 32, "Combat", 2, ColorPalette.SECONDARY));
        this.modCategories.add(new BasicButton(64, 32, "HUD", 2, ColorPalette.SECONDARY));
        this.modCategories.add(new BasicButton(104, 32, "Utility & QoL", 2, ColorPalette.SECONDARY));
        this.modCategories.add(new BasicButton(80, 32, "Hypixel", 2, ColorPalette.SECONDARY));
        this.modCategories.add(new BasicButton(80, 32, "Skyblock", 2, ColorPalette.SECONDARY));
        this.modCategories.add(new BasicButton(88, 32, "3rd Party", 2, ColorPalette.SECONDARY));
        for (int i = 0; i < this.modCategories.size(); ++i) {
            this.modCategories.get(i).setToggleable(true);
            int finalI = i;
            this.modCategories.get(i).setClickAction(() -> this.unselect(finalI));
        }
        this.modCategories.get(0).setToggled(true);
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        String filter2 = OneConfigGui.INSTANCE == null ? "" : OneConfigGui.INSTANCE.getSearchValue().toLowerCase().trim();
        int iX = x + 16;
        int iY = y + 72;
        ArrayList<ModCard> finalModCards = new ArrayList<ModCard>(this.modCards);
        for (ModCard modCard : finalModCards) {
            if (!this.inSelection(modCard) || !filter2.equals("") && !SearchUtils.isSimilar(modCard.getModData().name, filter2)) continue;
            if ((float)(iY + 135) >= (float)y - this.scroll && (float)iY <= (float)(y + 728) - this.scroll) {
                modCard.draw(vg, iX, iY, inputHandler);
            }
            if ((iX += 260) <= x + 796) continue;
            iX = x + 16;
            iY += 135;
        }
        this.size = iY - y + 135;
        if (iX == x + 16 && iY == y + 72) {
            NanoVGHelper.INSTANCE.drawText(vg, "Looks like there is nothing here. Try another category?", x + 16, y + 72, Colors.WHITE_60, 14.0f, Fonts.MEDIUM);
        }
    }

    @Override
    public int drawStatic(long vg, int x, int y, InputHandler inputHandler) {
        int iXCat = x + 16;
        boolean selected = false;
        for (BasicButton btn : this.modCategories) {
            btn.draw(vg, iXCat, y + 16, inputHandler);
            iXCat += btn.getWidth() + 8;
            if (!btn.isToggled()) continue;
            selected = true;
        }
        if (!selected) {
            this.modCategories.get(0).setToggled(true);
        }
        return 60;
    }

    private void unselect(int index2) {
        for (int i = 0; i < this.modCategories.size(); ++i) {
            if (index2 == i) continue;
            this.modCategories.get(i).setToggled(false);
        }
    }

    private boolean inSelection(ModCard modCard) {
        return this.modCategories.get(0).isToggled() || this.modCategories.get(1).isToggled() && modCard.getModData().modType == ModType.PVP || this.modCategories.get(2).isToggled() && modCard.getModData().modType == ModType.HUD || this.modCategories.get(3).isToggled() && modCard.getModData().modType == ModType.UTIL_QOL || this.modCategories.get(4).isToggled() && modCard.getModData().modType == ModType.HYPIXEL || this.modCategories.get(5).isToggled() && modCard.getModData().modType == ModType.SKYBLOCK || this.modCategories.get(6).isToggled() && modCard.getModData().modType == ModType.THIRD_PARTY;
    }

    public void reloadMods() {
        this.modCards.clear();
        for (Mod modData : ConfigCore.mods) {
            Mod parentMod;
            if (!(this instanceof SubModsPage) ? modData.config instanceof SubConfig : (parentMod = ((SubModsPage)this).parentMod) != null && !ConfigCore.subMods.get(parentMod).contains(modData)) continue;
            this.modCards.add(new ModCard(modData, modData.config == null || modData.config.enabled, false, OneConfigConfig.favoriteMods.contains(modData.name), this));
        }
        ConfigCore.sortMods();
    }

    @Override
    public int getMaxScrollHeight() {
        return this.size;
    }

    @Override
    public boolean isBase() {
        return true;
    }
}

