/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.pages;

import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.config.elements.OptionCategory;
import cc.polyfrost.oneconfig.config.elements.OptionPage;
import cc.polyfrost.oneconfig.config.elements.OptionSubcategory;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.elements.BasicButton;
import cc.polyfrost.oneconfig.gui.pages.Page;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.renderer.scissor.ScissorHelper;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.SearchUtils;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModConfigPage
extends Page {
    private final OptionPage page;
    private final List<BasicButton> categories = new ArrayList<BasicButton>();
    private String selectedCategory;
    private int totalSize = 724;
    private final boolean base;
    private int categoryY = 0;
    private final ArrayList<OptionSubcategory> empty = new ArrayList();

    public ModConfigPage(OptionPage page, boolean base) {
        super(page.name);
        this.page = page;
        this.base = base;
        if (page.categories.size() == 0) {
            return;
        }
        Iterator<String> iterator2 = page.categories.keySet().iterator();
        if (iterator2.hasNext()) {
            String category;
            this.selectedCategory = category = iterator2.next();
        }
        if (page.categories.size() < 2) {
            return;
        }
        for (String category : page.categories.keySet()) {
            BasicButton button = new BasicButton(0, 32, category, 2, ColorPalette.SECONDARY);
            button.setClickAction(() -> this.switchCategory(category));
            button.setToggleable(true);
            if (category.equals(this.selectedCategory)) {
                button.setToggled(true);
            }
            this.categories.add(button);
        }
    }

    public ModConfigPage(OptionPage page) {
        this(page, false);
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        if (this.page.categories.size() == 0) {
            return;
        }
        ScissorHelper scissorHelper = ScissorHelper.INSTANCE;
        int optionY = y + (this.page.categories.size() == 1 ? 16 : 64) + this.categoryY;
        List<OptionSubcategory> subcategories = this.getSubcategories();
        for (OptionSubcategory subCategory : subcategories) {
            optionY += subCategory.draw(vg, x + 30, optionY, inputHandler);
        }
        scissorHelper.save();
        scissorHelper.clearScissors(vg);
        for (OptionSubcategory subCategory : subcategories) {
            subCategory.drawLast(vg, x + 30, inputHandler);
        }
        scissorHelper.restore(vg);
        this.totalSize = optionY - y;
    }

    @Override
    public int drawStatic(long vg, int x, int y, InputHandler inputHandler) {
        this.categoryY = 0;
        if (this.categories.size() <= 1) {
            return 0;
        }
        int buttonX = x + 16;
        int returned = 0;
        boolean searching = !OneConfigGui.INSTANCE.getSearchValue().trim().isEmpty();
        for (BasicButton button : this.categories) {
            if (button.getWidth() == 0) {
                button.setWidth((int)(Math.ceil(NanoVGHelper.INSTANCE.getTextWidth(vg, button.getText(), 12.0f, Fonts.MEDIUM) / 8.0f) * 8.0 + 16.0));
            }
            if (buttonX + button.getWidth() >= x + 1024 - 16) {
                buttonX = x + 16;
                returned += 48;
                this.categoryY += 48;
            }
            if (searching) {
                boolean similar = SearchUtils.isSimilar(button.getText(), OneConfigGui.INSTANCE.getSearchValue());
                boolean selected = button.isToggled();
                button.setToggled(similar);
                button.draw(vg, buttonX, y + 16 + returned, inputHandler);
                buttonX += button.getWidth() + 16;
                button.setToggled(selected);
                continue;
            }
            button.draw(vg, buttonX, y + 16 + returned, inputHandler);
            buttonX += button.getWidth() + 16;
        }
        return 60 + returned;
    }

    @Override
    public void finishUpAndClose() {
        this.page.mod.config.save();
        OneConfigGui.INSTANCE.closeColorSelector();
        for (OptionSubcategory subCategory : this.getSubcategories()) {
            for (BasicOption option : subCategory.options) {
                option.finishUpAndClose();
            }
        }
    }

    @Override
    public void keyTyped(char key, int keyCode) {
        if (this.page.categories.isEmpty()) {
            return;
        }
        for (OptionSubcategory subCategory : this.getSubcategories()) {
            for (BasicOption option : subCategory.options) {
                option.keyTyped(key, keyCode);
            }
        }
    }

    private List<OptionSubcategory> getSubcategories() {
        if (OneConfigGui.INSTANCE.getSearchValue().isEmpty()) {
            if (this.page.categories.isEmpty()) {
                return this.empty;
            }
            return this.page.categories.get((Object)this.selectedCategory).subcategories;
        }
        ArrayList<OptionSubcategory> subcategories = new ArrayList<OptionSubcategory>();
        for (Map.Entry<String, OptionCategory> category : this.page.categories.entrySet()) {
            if (SearchUtils.isSimilar(category.getKey(), OneConfigGui.INSTANCE.getSearchValue())) {
                subcategories.addAll(category.getValue().subcategories);
                continue;
            }
            block1: for (OptionSubcategory subcategory : category.getValue().subcategories) {
                if (SearchUtils.isSimilar(subcategory.getName(), OneConfigGui.INSTANCE.getSearchValue())) {
                    subcategories.add(subcategory);
                    continue;
                }
                for (BasicOption option : subcategory.options) {
                    if (!SearchUtils.isSimilar(option.name, OneConfigGui.INSTANCE.getSearchValue())) continue;
                    subcategories.add(subcategory);
                    continue block1;
                }
            }
        }
        return subcategories;
    }

    public void switchCategory(String newCategory) {
        if (!this.page.categories.containsKey(newCategory)) {
            return;
        }
        this.selectedCategory = newCategory;
        for (BasicButton button : this.categories) {
            if (button.getText().equals(newCategory)) continue;
            button.setToggled(false);
            this.scrollTarget = 0.0f;
            this.scrollAnimation = null;
        }
        OneConfigGui.INSTANCE.closeColorSelector();
    }

    @Override
    public int getMaxScrollHeight() {
        return this.totalSize;
    }

    @Override
    public boolean isBase() {
        return this.base;
    }

    public OptionPage getPage() {
        return this.page;
    }

    public String getSelectedCategory() {
        return this.selectedCategory;
    }
}

