/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.text;

import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.events.event.RenderEvent;
import cc.polyfrost.oneconfig.events.event.Stage;
import cc.polyfrost.oneconfig.gui.elements.BasicElement;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.UKeyboard;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.asset.SVG;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.renderer.scissor.Scissor;
import cc.polyfrost.oneconfig.renderer.scissor.ScissorHelper;
import cc.polyfrost.oneconfig.utils.IOUtils;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.MathUtils;
import cc.polyfrost.oneconfig.utils.TextUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class TextInputField
extends BasicElement {
    protected final String defaultText;
    protected final boolean multiLine;
    private float radius;
    private float boarderThickness = 1.0f;
    private float textSize = 12.0f;
    protected String input;
    protected String selectedText;
    protected boolean password;
    protected int caretPos;
    protected float x;
    protected float y;
    protected float start;
    protected float end;
    protected int startLine;
    protected int endLine;
    protected long vg;
    protected int prevCaret = 0;
    protected boolean isDoubleClick = false;
    protected boolean onlyNums = false;
    protected boolean errored = false;
    protected boolean centered = false;
    protected SVG icon;
    protected ArrayList<String> wrappedText = null;
    private long clickTimeD1;
    private int lines = 1;
    private static boolean anyCheckInit = false;
    private static boolean isAnySelected = false;

    public TextInputField(int width, int height, String defaultText, boolean multiLine, boolean password, SVG icon, float radius) {
        super(width, height, false);
        if (!anyCheckInit) {
            anyCheckInit = true;
            EventManager.INSTANCE.register(new TextInputSelectionChecker());
        }
        this.multiLine = multiLine;
        this.defaultText = defaultText;
        this.password = password;
        this.input = "";
        this.icon = icon;
        this.radius = radius;
    }

    public TextInputField(int width, int height, String defaultText, boolean multiLine, boolean password, SVG icon) {
        this(width, height, defaultText, multiLine, password, null, 12.0f);
    }

    public TextInputField(int width, int height, String defaultText, boolean multiLine, boolean password) {
        this(width, height, defaultText, multiLine, password, null, 12.0f);
    }

    public TextInputField(int width, int height, boolean centered, String defaultText) {
        this(width, height, defaultText, false, false, null, 12.0f);
        this.centered = centered;
    }

    public TextInputField(int width, int height, boolean centered, float radius) {
        this(width, height, "", false, false, null, radius);
        this.setCentered(centered);
    }

    public static boolean isAllowedCharacter(char character) {
        return character != '\u00a7' && character >= ' ' && character != '\u007f';
    }

    public void onlyAcceptNumbers(boolean state) {
        this.onlyNums = state;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public boolean getPassword() {
        return this.password;
    }

    public void setPassword(boolean password) {
        this.password = password;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public boolean isErrored() {
        return this.errored;
    }

    public void setErrored(boolean errored) {
        this.errored = errored;
    }

    @Override
    public void draw(long vg, float x, float y, InputHandler inputHandler) {
        ScissorHelper scissorHelper = ScissorHelper.INSTANCE;
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        this.x = x;
        this.y = y;
        this.vg = vg;
        try {
            int caretLine;
            float width;
            int color;
            int colorOutline;
            nanoVGHelper.drawRoundedRect(vg, x + this.boarderThickness, y + this.boarderThickness, (float)this.width - this.boarderThickness * 2.0f, (float)this.height - this.boarderThickness * 2.0f, Colors.GRAY_850, this.radius);
            int n = colorOutline = this.errored ? Colors.ERROR_700 : Colors.GRAY_700;
            if (!this.toggled) {
                nanoVGHelper.drawHollowRoundRect(vg, x, y, (float)this.width - 0.5f, (float)this.height - 0.5f, colorOutline, this.radius, this.boarderThickness);
            } else {
                nanoVGHelper.drawHollowRoundRect(vg, x, y, (float)this.width - 0.5f, (float)this.height - 0.5f, this.errored ? Colors.ERROR_600 : Colors.PRIMARY_600, this.radius, this.boarderThickness);
            }
            Scissor scissor = scissorHelper.scissor(vg, x, y, this.width, this.height);
            super.update(x, y, inputHandler);
            if (Platform.getMousePlatform().isButtonDown(0) && !this.hovered) {
                this.onClose();
                this.toggled = false;
            }
            int n2 = color = this.toggled ? Colors.WHITE : Colors.WHITE_60;
            if (!this.toggled) {
                this.caretPos = this.input.length();
            }
            if (this.caretPos > this.input.length()) {
                this.caretPos = this.input.length();
            }
            if (this.prevCaret > this.input.length()) {
                this.prevCaret = this.input.length();
            }
            if (this.caretPos < 0) {
                this.caretPos = 0;
            }
            if (this.prevCaret < 0) {
                this.prevCaret = 0;
            }
            if (this.icon != null) {
                nanoVGHelper.drawSvg(vg, this.icon, x + 10.0f, y + (float)this.height / 2.0f - 10.0f, 20.0f, 20.0f, color);
                this.x = x += 36.0f;
            }
            StringBuilder s2 = new StringBuilder();
            if (this.multiLine) {
                this.wrappedText = TextUtils.wrapText(vg, this.input, this.width - 24, this.textSize, Fonts.REGULAR);
                this.lines = this.wrappedText.size();
                if (!this.toggled) {
                    this.caretPos = this.wrappedText.get(this.wrappedText.size() - 1).length();
                }
                int caretLine2 = (int)MathUtils.clamp(this.getCaretLine(this.caretPos), 0.0f, this.wrappedText.size() - 1);
                width = nanoVGHelper.getTextWidth(vg, this.wrappedText.get(caretLine2).substring(0, this.getLineCaret(this.caretPos, caretLine2)), this.textSize, Fonts.REGULAR);
            } else if (!this.password) {
                width = nanoVGHelper.getTextWidth(vg, this.input.substring(0, this.caretPos), this.textSize, Fonts.REGULAR);
            } else {
                for (int i = 0; i < this.input.length(); ++i) {
                    s2.append("*");
                }
                width = nanoVGHelper.getTextWidth(vg, s2.substring(0, this.caretPos), this.textSize, Fonts.REGULAR);
            }
            if (this.hovered) {
                int state = Platform.getMousePlatform().getButtonState(0);
                if (state == 1) {
                    if (this.multiLine) {
                        caretLine = Math.max(0, Math.min(this.wrappedText.size() - 1, (int)Math.floor((inputHandler.mouseY() - y - 10.0f) / 24.0f)));
                        this.caretPos = this.calculatePos(inputHandler.mouseX(), this.wrappedText.get(caretLine));
                    } else {
                        this.prevCaret = this.calculatePos(inputHandler.mouseX(), this.input);
                    }
                    if (System.currentTimeMillis() - this.clickTimeD1 < 300L) {
                        this.onDoubleClick(inputHandler);
                        this.isDoubleClick = true;
                    }
                    this.clickTimeD1 = System.currentTimeMillis();
                } else {
                    long clickTimeU = System.currentTimeMillis();
                    if (clickTimeU - this.clickTimeD1 < 200L) {
                        if (!this.isDoubleClick) {
                            this.start = 0.0f;
                            this.end = 0.0f;
                        }
                        this.prevCaret = this.caretPos;
                        this.isDoubleClick = false;
                    }
                }
            }
            float halfTextWidth = this.getTextWidth(vg, this.input) / 2.0f;
            if (this.start != 0.0f && this.end != 0.0f && this.toggled) {
                if (!this.multiLine) {
                    nanoVGHelper.drawRect(vg, this.start, y + (float)this.height / 2.0f - 10.0f, this.end, 20.0f, Colors.GRAY_300);
                } else if (this.startLine == this.endLine) {
                    nanoVGHelper.drawRect(vg, this.start, y + 10.0f + (float)(24 * this.startLine), this.end, 20.0f, Colors.GRAY_300);
                } else {
                    nanoVGHelper.drawRect(vg, this.start, y + 10.0f + (float)(24 * this.startLine), this.width - 24, 20.0f, Colors.GRAY_300);
                    for (int i = this.startLine + 1; i < this.endLine; ++i) {
                        nanoVGHelper.drawRect(vg, x + 12.0f, y + 10.0f + (float)(24 * i), this.width - 24, 20.0f, Colors.GRAY_300);
                    }
                    nanoVGHelper.drawRect(vg, x + 12.0f, y + 10.0f + (float)(24 * this.endLine), this.end, 20.0f, Colors.GRAY_300);
                }
            }
            if (this.hovered && Platform.getMousePlatform().isButtonDown(0) && !this.isDoubleClick) {
                if (this.multiLine) {
                    caretLine = Math.max(0, Math.min(this.wrappedText.size() - 1, (int)Math.floor((inputHandler.mouseY() - y - 10.0f) / 24.0f)));
                    this.caretPos = this.calculatePos(inputHandler.mouseX(), this.wrappedText.get(caretLine));
                    for (int i = 0; i < caretLine; ++i) {
                        this.caretPos += this.wrappedText.get(i).length();
                    }
                } else {
                    this.caretPos = this.calculatePos(inputHandler.mouseX(), this.input);
                }
                if (this.caretPos > this.prevCaret) {
                    this.start = !this.centered ? x + 12.0f + this.getTextWidth(vg, this.input.substring(0, this.prevCaret)) : x + (float)this.width / 2.0f - halfTextWidth + this.getTextWidth(vg, this.input.substring(0, this.prevCaret));
                    this.end = this.getTextWidth(vg, this.input.substring(this.prevCaret, this.caretPos));
                    this.selectedText = this.input.substring(this.prevCaret, this.caretPos);
                } else {
                    this.start = !this.centered ? x + 12.0f + this.getTextWidth(vg, this.input.substring(0, this.prevCaret)) : x + (float)this.width / 2.0f - halfTextWidth + this.getTextWidth(vg, this.input.substring(0, this.prevCaret));
                    this.end = -this.getTextWidth(vg, this.input.substring(this.caretPos, this.prevCaret));
                    this.selectedText = this.input.substring(this.caretPos, this.prevCaret);
                }
            }
            if (this.disabled) {
                nanoVGHelper.setAlpha(vg, 0.5f);
            }
            if (this.toggled) {
                if (this.multiLine) {
                    float lineY = y + 20.0f + (float)(this.getCaretLine(this.caretPos) * 24);
                    nanoVGHelper.drawLine(vg, x + width + 12.0f, lineY - 10.0f, x + width + 12.0f, lineY + 10.0f, 1.0f, Colors.WHITE);
                } else if (!this.centered) {
                    nanoVGHelper.drawLine(vg, x + width + 12.0f, y + (float)this.height / 2.0f - 10.0f, x + width + 12.0f, y + (float)this.height / 2.0f + 10.0f, 1.0f, Colors.WHITE);
                } else {
                    nanoVGHelper.drawLine(vg, x + (float)this.width / 2.0f - halfTextWidth + width, y + (float)this.height / 2.0f - 10.0f, x + (float)this.width / 2.0f - halfTextWidth + width, y + (float)this.height / 2.0f + 10.0f, 1.0f, Colors.WHITE);
                }
            }
            if (this.input.equals("")) {
                if (this.multiLine) {
                    nanoVGHelper.drawText(vg, this.defaultText, x + 12.0f, y + 16.0f, color, this.textSize, Fonts.REGULAR);
                } else if (!this.centered) {
                    nanoVGHelper.drawText(vg, this.defaultText, x + 12.0f, y + (float)this.height / 2.0f, color, this.textSize, Fonts.REGULAR);
                } else {
                    nanoVGHelper.drawText(vg, this.defaultText, x + (float)this.width / 2.0f - halfTextWidth, y + (float)this.height / 2.0f, color, this.textSize, Fonts.REGULAR);
                }
            }
            if (!this.password) {
                if (this.multiLine) {
                    float textY = y + 20.0f;
                    for (String line : this.wrappedText) {
                        nanoVGHelper.drawText(vg, line, x + 12.0f, textY, color, this.textSize, Fonts.REGULAR);
                        textY += 24.0f;
                    }
                } else if (!this.centered) {
                    nanoVGHelper.drawText(vg, this.input, x + 12.0f, y + (float)this.height / 2.0f, color, this.textSize, Fonts.REGULAR);
                } else {
                    nanoVGHelper.drawText(vg, this.input, x + (float)this.width / 2.0f - halfTextWidth, y + (float)this.height / 2.0f, color, this.textSize, Fonts.REGULAR);
                }
            } else {
                nanoVGHelper.drawText(vg, s2.toString(), x + 12.0f, y + (float)this.height / 2.0f, color, this.textSize, Fonts.REGULAR);
            }
            nanoVGHelper.setAlpha(vg, 1.0f);
            scissorHelper.resetScissor(vg, scissor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.toggled) {
            isAnySelected = true;
        }
    }

    public void keyTyped(char c, int key) {
        block51: {
            try {
                if (!this.toggled) break block51;
                if (UKeyboard.isKeyComboCtrlC(key)) {
                    if (this.selectedText != null && this.start != 0.0f && this.end != 0.0f) {
                        IOUtils.copyStringToClipboard(this.selectedText);
                    }
                    return;
                }
                if (UKeyboard.isKeyComboCtrlV(key) || key == 210) {
                    try {
                        String clip = IOUtils.getStringFromClipboard();
                        this.input = this.input.substring(0, this.caretPos) + clip + this.input.substring(this.caretPos);
                        this.caretPos += Objects.requireNonNull(clip).length();
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (key == UKeyboard.KEY_DELETE) {
                    this.input = "";
                }
                if (UKeyboard.isCtrlKeyDown()) {
                    if (key == UKeyboard.KEY_BACKSPACE && !UKeyboard.isKeyComboCtrlX(key)) {
                        try {
                            this.input = this.input.substring(0, this.input.lastIndexOf(" "));
                            this.caretPos = this.input.length();
                        }
                        catch (Exception e) {
                            this.input = "";
                            this.caretPos = 0;
                        }
                        return;
                    }
                    if (UKeyboard.isKeyComboCtrlA(key)) {
                        this.prevCaret = 0;
                        this.caretPos = this.input.length();
                        this.start = !this.centered ? this.x + 12.0f : this.x + (float)this.width / 2.0f - this.getTextWidth(this.vg, this.input) / 2.0f;
                        this.selectedText = this.input;
                        if (!this.multiLine) {
                            this.end = this.getTextWidth(this.vg, this.input);
                        }
                        if (this.multiLine) {
                            this.end = this.getTextWidth(this.vg, this.wrappedText.get(this.wrappedText.size() - 1));
                            this.startLine = 0;
                            this.endLine = this.wrappedText.size() - 1;
                        }
                        return;
                    }
                    if (UKeyboard.isKeyComboCtrlX(key)) {
                        if (this.selectedText != null && this.start != 0.0f && this.end != 0.0f) {
                            IOUtils.copyStringToClipboard(this.selectedText);
                            key = UKeyboard.KEY_BACKSPACE;
                        } else {
                            return;
                        }
                    }
                    if (key == UKeyboard.KEY_LEFT) {
                        this.caretPos = this.input.substring(0, this.caretPos).lastIndexOf(32) + 1;
                    }
                    if (key == UKeyboard.KEY_RIGHT) {
                        this.caretPos = this.input.indexOf(32, this.caretPos);
                        if (this.caretPos == -1) {
                            this.caretPos = this.input.length();
                        }
                    }
                }
                if (key == UKeyboard.KEY_BACKSPACE) {
                    if (this.input.length() > 0) {
                        if (this.start != 0.0f && this.end != 0.0f) {
                            this.start = 0.0f;
                            this.end = 0.0f;
                            if (this.caretPos > this.prevCaret) {
                                this.input = this.input.substring(0, this.prevCaret) + this.input.substring(this.caretPos);
                                this.caretPos = this.prevCaret;
                            }
                            if (this.caretPos < this.prevCaret) {
                                this.input = this.input.substring(0, this.caretPos) + this.input.substring(this.prevCaret);
                            }
                            return;
                        }
                        this.input = this.caretPos == this.input.length() ? this.input.substring(0, this.input.length() - 1) : this.input.substring(0, this.caretPos - 1) + this.input.substring(this.caretPos);
                        --this.caretPos;
                    }
                    return;
                }
                if (key == UKeyboard.KEY_TAB) {
                    if (this.onlyNums) {
                        return;
                    }
                    this.input = this.input + "    ";
                    this.caretPos += 4;
                    return;
                }
                if (key == UKeyboard.KEY_RIGHT) {
                    ++this.caretPos;
                    if (this.caretPos > this.input.length()) {
                        this.caretPos = this.input.length();
                    }
                    if (this.start != 0.0f && this.end != 0.0f) {
                        this.start = 0.0f;
                        this.end = 0.0f;
                    }
                    return;
                }
                if (key == UKeyboard.KEY_LEFT) {
                    --this.caretPos;
                    if (this.caretPos < 0) {
                        this.caretPos = 0;
                    }
                    if (this.start != 0.0f && this.end != 0.0f) {
                        this.start = 0.0f;
                        this.end = 0.0f;
                    }
                    return;
                }
                if (key == UKeyboard.KEY_UP || key == 201) {
                    this.caretPos = 0;
                    if (this.start != 0.0f && this.end != 0.0f) {
                        this.start = 0.0f;
                        this.end = 0.0f;
                    }
                    return;
                }
                if (key == UKeyboard.KEY_DOWN || key == 209) {
                    this.caretPos = this.input.length();
                    if (this.start != 0.0f && this.end != 0.0f) {
                        this.start = 0.0f;
                        this.end = 0.0f;
                    }
                    return;
                }
                if (key == UKeyboard.KEY_ENTER) {
                    this.onClose();
                    this.toggled = false;
                    if (this.start != 0.0f && this.end != 0.0f) {
                        this.start = 0.0f;
                        this.end = 0.0f;
                    }
                }
                if (key == UKeyboard.KEY_END) {
                    this.onClose();
                    this.toggled = false;
                }
                if (key == UKeyboard.KEY_LCONTROL || key == UKeyboard.KEY_RCONTROL || key == UKeyboard.KEY_LMENU || key == UKeyboard.KEY_RMENU || key == UKeyboard.KEY_LMETA || key == UKeyboard.KEY_RMETA || key == UKeyboard.KEY_LSHIFT || key == UKeyboard.KEY_RSHIFT || key == UKeyboard.KEY_ENTER || key == UKeyboard.KEY_CAPITAL || key == 221 || key == UKeyboard.KEY_HOME) {
                    return;
                }
                if (this.onlyNums && !Character.isDigit(c) && key != 52) {
                    return;
                }
                if (!Character.isDefined(key)) {
                    return;
                }
                if (!Character.isDefined(c)) {
                    return;
                }
                if (UKeyboard.isCtrlKeyDown()) {
                    return;
                }
                if (TextInputField.isAllowedCharacter(c)) {
                    if (this.selectedText != null) {
                        if (this.caretPos > this.prevCaret) {
                            this.caretPos = this.prevCaret;
                        }
                        if (this.selectedText.equals(this.input)) {
                            this.input = "";
                        }
                        this.selectedText = null;
                    }
                    this.input = this.addCharAtPoint(this.caretPos, c);
                    ++this.caretPos;
                }
                if (this.start != 0.0f && this.end != 0.0f) {
                    this.start = 0.0f;
                    this.end = 0.0f;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    private String addCharAtPoint(int index2, char c) {
        return this.input.substring(0, index2) + c + this.input.substring(index2);
    }

    @Override
    public void onClick() {
        this.toggled = true;
    }

    private void onDoubleClick(InputHandler inputHandler) {
        this.prevCaret = this.input.substring(0, this.caretPos).lastIndexOf(32) + 1;
        this.caretPos = this.input.indexOf(32, this.caretPos);
        if (this.caretPos == -1) {
            this.caretPos = this.input.length();
        }
        this.selectedText = this.input.substring(this.prevCaret, this.caretPos);
        if (this.multiLine) {
            int caretLine;
            this.startLine = caretLine = Math.max(0, Math.min(this.wrappedText.size() - 1, (int)Math.floor((inputHandler.mouseY() - this.y - 10.0f) / 24.0f)));
            this.endLine = caretLine;
            this.start = this.x + 12.0f + this.getTextWidth(this.vg, this.wrappedText.get(caretLine).substring(0, this.getLineCaret(this.prevCaret, this.startLine)));
            this.end = this.getTextWidth(this.vg, this.wrappedText.get(caretLine).substring(this.getLineCaret(this.prevCaret, this.startLine), this.getLineCaret(this.caretPos, this.startLine)));
        } else {
            this.start = this.x + 12.0f + this.getTextWidth(this.vg, this.input.substring(0, this.prevCaret));
            this.end = this.getTextWidth(this.vg, this.input.substring(this.prevCaret, this.caretPos));
        }
    }

    private int calculatePos(float pos, String string) {
        if (this.centered) {
            pos -= 12.0f;
        }
        String s1 = "";
        for (char c : string.toCharArray()) {
            if (pos - this.x - 12.0f < 0.0f) {
                return 0;
            }
            if (pos - this.x - 12.0f > this.getTextWidth(this.vg, string)) {
                return string.length();
            }
            int i = (int)this.getTextWidth(this.vg, s1 = s1 + c);
            if (!((float)i >= pos - this.x - 16.0f)) continue;
            return s1.length();
        }
        return 0;
    }

    public void onClose() {
    }

    private float getTextWidth(long vg, String s2) {
        if (this.password) {
            StringBuilder s1 = new StringBuilder();
            while (s1.length() < s2.length()) {
                s1.append('*');
            }
            s2 = s1.toString();
        }
        return NanoVGHelper.INSTANCE.getTextWidth(vg, s2, this.textSize, Fonts.REGULAR);
    }

    private int getCaretLine(int caret) {
        int pos = 0;
        for (int i = 0; i < this.wrappedText.size(); ++i) {
            if ((pos += this.wrappedText.get(i).length()) < caret - 1) continue;
            return i;
        }
        return 0;
    }

    private float getCaretX(int caret) {
        int pos = 0;
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        for (String text : this.wrappedText) {
            float length = nanoVGHelper.getTextWidth(this.vg, text, this.textSize, Fonts.REGULAR);
            if ((float)pos + length < (float)caret) {
                pos = (int)((float)pos + length);
                continue;
            }
            return nanoVGHelper.getTextWidth(this.vg, text.substring(0, caret - pos), this.textSize, Fonts.REGULAR);
        }
        return 0.0f;
    }

    private int getLineCaret(int caret, int line) {
        int pos = 0;
        for (String text : this.wrappedText) {
            int length = text.length();
            if (pos + length < caret - 1) {
                pos += length;
                continue;
            }
            return caret - pos;
        }
        return 0;
    }

    public int getLines() {
        return this.lines;
    }

    public void setBoarderThickness(float thickness) {
        this.boarderThickness = thickness;
    }

    public void setFontSize(float textSize) {
        this.textSize = textSize;
    }

    public static boolean isAnySelected() {
        return isAnySelected;
    }

    private static class TextInputSelectionChecker {
        private TextInputSelectionChecker() {
        }

        @Subscribe
        private void onRender(RenderEvent event) {
            if (event.stage == Stage.START) {
                isAnySelected = false;
            }
        }
    }
}

