/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.text;

import cc.polyfrost.oneconfig.gui.animations.ColorAnimation;
import cc.polyfrost.oneconfig.gui.elements.BasicElement;
import cc.polyfrost.oneconfig.gui.elements.text.TextInputField;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;

public class NumberInputField
extends TextInputField {
    private final BasicElement upArrow = new BasicElement(12, 14, false);
    private final BasicElement downArrow = new BasicElement(12, 14, false);
    private final ColorAnimation colorTop = new ColorAnimation(ColorPalette.SECONDARY);
    private final ColorAnimation colorBottom = new ColorAnimation(ColorPalette.SECONDARY);
    private float min;
    private float max;
    private float step;
    private float current;

    public NumberInputField(int width, int height, float defaultValue, float min2, float max, float step) {
        super(width - 16, height, true, "");
        this.onlyNums = true;
        this.min = min2;
        this.max = max;
        this.step = step;
        this.input = String.format("%.01f", Float.valueOf(defaultValue));
    }

    @Override
    public void draw(long vg, float x, float y, InputHandler inputHandler) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        this.errored = false;
        if (this.disabled) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        nanoVGHelper.drawRoundedRect(vg, x + (float)this.width + 4.0f, y, 12.0f, 28.0f, Colors.GRAY_500, 6.0f);
        this.upArrow.disable(this.disabled);
        this.downArrow.disable(this.disabled);
        this.upArrow.update(x + (float)this.width + 4.0f, y, inputHandler);
        this.downArrow.update(x + (float)this.width + 4.0f, y + 14.0f, inputHandler);
        try {
            this.current = Float.parseFloat(this.input);
        }
        catch (NumberFormatException e) {
            this.errored = true;
        }
        if (this.current < this.min || this.current > this.max) {
            this.errored = true;
        } else {
            this.upArrow.disable(false);
            this.downArrow.disable(false);
        }
        if (this.upArrow.isClicked()) {
            this.current += this.step;
            if (this.current > this.max) {
                this.current = this.max;
            }
            this.setCurrentValue(this.current);
        }
        if (this.downArrow.isClicked()) {
            this.current -= this.step;
            if (this.current < this.min) {
                this.current = this.min;
            }
            this.setCurrentValue(this.current);
        }
        if (this.current >= this.max && !this.disabled) {
            nanoVGHelper.setAlpha(vg, 0.3f);
            this.upArrow.disable(true);
        }
        nanoVGHelper.drawRoundedRectVaried(vg, x + (float)this.width + 4.0f, y, 12.0f, 14.0f, this.colorTop.getColor(this.upArrow.isHovered(), this.upArrow.isPressed()), 6.0f, 6.0f, 0.0f, 0.0f);
        nanoVGHelper.drawSvg(vg, SVGs.CHEVRON_UP, x + (float)this.width + 5.0f, y + 2.0f, 10.0f, 10.0f);
        if (this.current >= this.max && !this.disabled) {
            nanoVGHelper.setAlpha(vg, 1.0f);
        }
        if (this.current <= this.min && !this.disabled) {
            nanoVGHelper.setAlpha(vg, 0.3f);
            this.downArrow.disable(true);
        }
        nanoVGHelper.drawRoundedRectVaried(vg, x + (float)this.width + 4.0f, y + 14.0f, 12.0f, 14.0f, this.colorBottom.getColor(this.downArrow.isHovered(), this.downArrow.isPressed()), 0.0f, 0.0f, 6.0f, 6.0f);
        nanoVGHelper.drawSvg(vg, SVGs.CHEVRON_DOWN, x + (float)this.width + 5.0f, y + 15.0f, 10.0f, 10.0f);
        if (!this.disabled) {
            nanoVGHelper.setAlpha(vg, 1.0f);
        }
        try {
            super.draw(vg, x, y - 2.0f, inputHandler);
        }
        catch (Exception e) {
            this.setCurrentValue(this.current);
            this.caretPos = 0;
            this.prevCaret = 0;
        }
        if (this.disabled) {
            nanoVGHelper.setAlpha(vg, 1.0f);
        }
    }

    public float getCurrentValue() {
        return this.current;
    }

    public void setCurrentValue(float value) {
        this.input = String.format("%.01f", Float.valueOf(value));
    }

    @Override
    public void onClose() {
        try {
            if (this.current < this.min) {
                this.current = this.min;
            }
            if (this.current > this.max) {
                this.current = this.max;
            }
            this.setCurrentValue(this.current);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStep(float step) {
        this.step = step;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public void setMin(float min2) {
        this.min = min2;
    }

    public boolean arrowsClicked() {
        return this.upArrow.isClicked() || this.downArrow.isClicked();
    }
}

