/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.config;

import cc.polyfrost.oneconfig.config.annotations.HypixelKey;
import cc.polyfrost.oneconfig.config.annotations.Text;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.gui.elements.IFocusable;
import cc.polyfrost.oneconfig.gui.elements.text.TextInputField;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.asset.SVG;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import java.lang.reflect.Field;

public class ConfigTextBox
extends BasicOption
implements IFocusable {
    private final boolean secure;
    private final boolean multiLine;
    public final TextInputField textField;

    public ConfigTextBox(Field field, Object parent, String name, String description2, String category, String subcategory, int size, String placeholder, boolean secure, boolean multiLine) {
        super(field, parent, name, description2, category, subcategory, size);
        this.secure = secure;
        this.multiLine = multiLine;
        this.textField = new TextInputField(size == 1 ? 256 : 640, multiLine ? 64 : 32, placeholder, multiLine, secure, SVGs.TEXT_INPUT, 12.0f);
    }

    public static ConfigTextBox create(Field field, Object parent) {
        Text text = field.getAnnotation(Text.class);
        return new ConfigTextBox(field, parent, text.name(), text.description(), text.category(), text.subcategory(), text.secure() || text.multiline() ? 2 : text.size(), text.placeholder(), text.secure() || field.isAnnotationPresent(HypixelKey.class), text.multiline());
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        if (!this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        this.textField.disable(!this.isEnabled());
        nanoVGHelper.drawText(vg, this.name, x, y + 16, this.nameColor, 14.0f, Fonts.MEDIUM);
        try {
            String value = (String)this.get();
            this.textField.setInput(value == null ? "" : value);
        }
        catch (IllegalAccessException value) {
            // empty catch block
        }
        if (this.multiLine && this.textField.getLines() > 2) {
            this.textField.setHeight(64 + 24 * (this.textField.getLines() - 2));
        } else if (this.multiLine) {
            this.textField.setHeight(64);
        }
        this.textField.draw(vg, x + (this.size == 1 ? 224 : 352), y, inputHandler);
        if (this.secure) {
            int color;
            SVG icon = this.textField.getPassword() ? SVGs.EYE_OFF : SVGs.EYE;
            boolean hovered = inputHandler.isAreaHovered(x + 967, y + 7, 18.0f, 18.0f) && this.isEnabled();
            int n = color = hovered ? Colors.WHITE : Colors.WHITE_80;
            if (hovered && inputHandler.isClicked()) {
                this.textField.setPassword(!this.textField.getPassword());
            }
            if (hovered && Platform.getMousePlatform().isButtonDown(0)) {
                nanoVGHelper.setAlpha(vg, 0.5f);
            }
            nanoVGHelper.drawSvg(vg, icon, (float)(x + 967), (float)(y + 7), 18.0f, 18.0f, color);
        }
        nanoVGHelper.setAlpha(vg, 1.0f);
    }

    @Override
    public void keyTyped(char key, int keyCode) {
        if (!this.isEnabled()) {
            return;
        }
        this.textField.keyTyped(key, keyCode);
        try {
            this.set(this.textField.getInput());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public int getHeight() {
        return this.multiLine ? this.textField.getHeight() : 32;
    }

    @Override
    protected boolean shouldDrawDescription() {
        return super.shouldDrawDescription() && !this.textField.isToggled();
    }

    @Override
    public boolean hasFocus() {
        return this.textField.isToggled();
    }
}

